/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.core.crypto.AKeyPair;
import convex.core.data.Address;
import convex.core.data.Keyword;
import convex.core.util.Utils;
import convex.peer.Server;
import convex.restapi.api.ChainAPI;
import convex.restapi.api.DepAPI;
import io.javalin.Javalin;
import io.javalin.community.ssl.SslPlugin;
import io.javalin.config.JavalinConfig;
import io.javalin.http.staticfiles.Location;
import io.javalin.openapi.plugin.OpenApiPlugin;
import io.javalin.openapi.plugin.redoc.ReDocPlugin;
import io.javalin.openapi.plugin.swagger.SwaggerPlugin;
import io.javalin.plugin.Plugin;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTServer {
    protected static final Logger log = LoggerFactory.getLogger((String)RESTServer.class.getName());
    protected final Server server;
    protected final Convex convex;
    protected final Javalin app;
    protected ChainAPI chainAPI;
    protected DepAPI depAPI;

    private RESTServer(Server server) {
        this.server = server;
        this.convex = ConvexLocal.create((Server)server, (Address)server.getPeerController(), (AKeyPair)server.getKeyPair());
        SslPlugin sslPlugin = this.getSSLPlugin(server.getConfig());
        this.app = Javalin.create((T config) -> {
            config.staticFiles.enableWebjars();
            config.bundledPlugins.enableCors(cors -> cors.addRule(corsConfig -> corsConfig.anyHost()));
            if (sslPlugin != null) {
                config.registerPlugin((Plugin)sslPlugin);
            }
            this.addOpenApiPlugins((JavalinConfig)config);
            config.staticFiles.add(staticFiles -> {
                staticFiles.hostedPath = "/";
                staticFiles.location = Location.CLASSPATH;
                staticFiles.directory = "/public";
                staticFiles.precompress = false;
                staticFiles.aliasCheck = null;
                staticFiles.skipFileFunction = req -> false;
            });
        });
        this.app.exception(Exception.class, (e, ctx) -> {
            e.printStackTrace();
            String message = "Unexpected error: " + String.valueOf(e);
            ctx.result(message);
            ctx.status(500);
        });
        this.addAPIRoutes(this.app);
    }

    protected SslPlugin getSSLPlugin(HashMap<Keyword, Object> config) {
        boolean useSSL = true;
        SslPlugin sslPlugin = null;
        if (useSSL) {
            try {
                Path certFile = Utils.getHomePath().resolve(".convex/ssl/certificate.pem");
                Path privateFile = Utils.getHomePath().resolve(".convex/ssl/private.pem");
                if (Files.exists(certFile, new LinkOption[0]) && Files.exists(privateFile, new LinkOption[0])) {
                    InputStream certS = Files.newInputStream(certFile, new OpenOption[0]);
                    InputStream privateS = Files.newInputStream(privateFile, new OpenOption[0]);
                    sslPlugin = new SslPlugin(conf -> conf.pemFromInputStream(certS, privateS));
                } else {
                    log.warn("Failed to find SSL cerificates, defaulting back to HTTP");
                }
            }
            catch (Exception e) {
                log.warn("Failed to create SSL plugin, will use insecure HTTP only", (Throwable)e);
            }
        }
        return sslPlugin;
    }

    protected void addOpenApiPlugins(JavalinConfig config) {
        config.registerPlugin((Plugin)new OpenApiPlugin(pluginConfig -> pluginConfig.withDefinitionConfiguration((version, definition) -> definition.withInfo(info -> {
            info.setTitle("Convex REST API");
            info.setVersion("0.1.1");
        }))));
        config.registerPlugin((Plugin)new SwaggerPlugin());
        config.registerPlugin((Plugin)new ReDocPlugin());
    }

    private void addAPIRoutes(Javalin app) {
        this.chainAPI = new ChainAPI(this);
        this.chainAPI.addRoutes(app);
        this.depAPI = new DepAPI(this);
        this.depAPI.addRoutes(app);
    }

    public static RESTServer create(Server server) {
        RESTServer newServer = new RESTServer(server);
        return newServer;
    }

    public static RESTServer create(Convex convex) {
        return RESTServer.create(convex.getLocalServer());
    }

    public void start() {
        this.app.start();
    }

    public void start(Integer port) {
        if (port == null) {
            this.app.start();
        } else {
            this.app.start(port.intValue());
        }
    }

    public void stop() {
        this.app.stop();
    }

    public Convex getConvex() {
        return this.convex;
    }

    public Server getServer() {
        return this.server;
    }

    public int getPort() {
        return this.app.port();
    }
}

