/*
 * Decompiled with CFR 0.152.
 */
package convex.java.asset;

import convex.core.cvm.Address;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.Keyword;
import convex.core.data.Maps;
import convex.core.data.prim.CVMLong;
import convex.java.ConvexJSON;
import convex.java.asset.Fungible;
import java.util.Map;

public class TokenBuilder {
    private static final Keyword SUPPLY = Keyword.create((String)"supply");
    private final AMap<Keyword, ACell> config;

    public TokenBuilder(AMap<Keyword, ACell> config) {
        this.config = config;
    }

    public TokenBuilder() {
        this((AMap<Keyword, ACell>)Maps.empty());
    }

    private TokenBuilder withConfig(AMap<Keyword, ACell> config) {
        return new TokenBuilder(config);
    }

    public TokenBuilder withSupply(long supply) {
        if (supply < 0L) {
            throw new IllegalArgumentException("Requested supply must be non-negative!");
        }
        return this.withConfig((AMap<Keyword, ACell>)this.config.assoc((ACell)SUPPLY, (ACell)CVMLong.create((long)supply)));
    }

    public String generateCode() {
        StringBuilder sb = new StringBuilder();
        sb.append("(do (import convex.fungible :as fungible) \n");
        sb.append("  (deploy [(fungible/build-token " + this.config.toString() + ")\n");
        sb.append("]))");
        return sb.toString();
    }

    public Fungible deploy(ConvexJSON convex) {
        String code = this.generateCode();
        Map<String, Object> result = convex.transact(code);
        if (result.containsKey("errorCode")) {
            throw new Error("Token deployment failed" + String.valueOf(result));
        }
        Object value = result.get("value");
        if (value instanceof Long) {
            Long aNum = (Long)value;
            Address addr = Address.create((long)aNum);
            return Fungible.create(convex, addr);
        }
        throw new Error("Unexpected return value: " + String.valueOf(value));
    }
}

