/*
 * Decompiled with CFR 0.152.
 */
package convex.java;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.Keyword;
import convex.core.util.JSONUtils;
import convex.java.HTTPClients;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;

public class ARESTClient {
    private final URI host;
    private URI baseURI;

    public ARESTClient(URI host, String basePath) {
        this.host = host;
        this.baseURI = host.resolve(basePath);
    }

    public URI getHost() {
        return this.host;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    protected CompletableFuture<Result> doRequest(SimpleHttpRequest request) {
        try {
            CompletableFuture<SimpleHttpResponse> future = HTTPClients.execute(request);
            return future.thenApply(response -> {
                String rbody = null;
                try {
                    rbody = response.getBody().getBodyText();
                    return Result.create(null, (ACell)JSONUtils.parse((String)rbody));
                }
                catch (Exception e) {
                    if (rbody == null) {
                        rbody = "<Body not readable as String>";
                    }
                    Result res = Result.error((Keyword)ErrorCodes.FORMAT, (String)("Can't parse JSON body: " + rbody));
                    return res;
                }
            });
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(Result.fromException((Throwable)e));
        }
    }
}

