/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.key;

import convex.cli.CLIError;
import convex.cli.key.AKeyCommand;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="list", mixinStandardHelpOptions=true, description={"List available key pairs."})
public class KeyList
extends AKeyCommand {
    static final Logger log = LoggerFactory.getLogger(KeyList.class);

    @Override
    public void execute() {
        KeyStore keyStore = this.storeMixin.loadKeyStore();
        if (keyStore == null) {
            throw new CLIError(66, "Keystore does not exist. Specify a valid --keystore or use `convex key gen` to create one.");
        }
        int n = 0;
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                this.println(alias);
                ++n;
            }
        }
        catch (KeyStoreException e) {
            throw new CLIError("Unexpected error reading keystore", e);
        }
        if (n == 0) {
            this.inform("Keystore contains no keys");
        } else {
            this.inform(3, n + " key(s) found");
        }
    }
}

