/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.mixins;

import convex.cli.mixins.AMixin;
import convex.core.data.AccountKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class PeerKeyMixin
extends AMixin {
    @CommandLine.Option(names={"--peer-key"}, defaultValue="${env:CONVEX_PEER_KEY}", scope=CommandLine.ScopeType.INHERIT, description={"Peer key. Allows a hex prefix of a public key in keystore. Can also specify with CONVEX_PEER_KEY."})
    protected String publicKey;
    @CommandLine.Option(names={"--peer-keypass"}, defaultValue="${env:CONVEX_PEER_KEY_PASSWORD}", scope=CommandLine.ScopeType.INHERIT, description={"Peer key password in keystore. Can also specify with CONVEX_PEER_KEY_PASSWORD."})
    protected String keyPassword;
    static Logger log = LoggerFactory.getLogger(PeerKeyMixin.class);

    public String getPublicKey() {
        return this.publicKey;
    }

    public char[] getKeyPassword() {
        char[] keypass = null;
        if (this.keyPassword != null) {
            keypass = this.keyPassword.toCharArray();
        } else {
            if (this.isInteractive()) {
                keypass = this.readPassword("Peer Key Encryption Password: ");
            }
            if (keypass == null) {
                log.warn("No password for key: defaulting to blank password");
                keypass = new char[]{};
            }
            this.keyPassword = new String(keypass);
        }
        if (keypass.length == 0) {
            this.paranoia("Cannot use an empty password in --strict-security mode");
        }
        return keypass;
    }

    public AccountKey getAcountKey() {
        String ks = this.getPublicKey();
        AccountKey result = AccountKey.parse((String)ks);
        return result;
    }
}

