/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.etch;

import convex.cli.CLIError;
import convex.cli.Main;
import convex.cli.etch.AEtchCommand;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.RefSoft;
import convex.core.exceptions.InvalidDataException;
import convex.core.text.Text;
import convex.etch.Etch;
import convex.etch.EtchCorruptionError;
import convex.etch.EtchStore;
import convex.etch.EtchUtils;
import convex.etch.IEtchIndexVisitor;
import java.io.IOException;
import picocli.CommandLine;

@CommandLine.Command(name="validate", mixinStandardHelpOptions=true, description={"Validates an Etch store"})
public class EtchValidate
extends AEtchCommand {
    @CommandLine.Option(names={"-m", "--max-failures"}, description={"Maximum number of failures to recognise before abort."})
    private Long maxFailures;

    @Override
    public void execute() {
        EtchStore store = this.store();
        try {
            ValidateVisitor visitor = new ValidateVisitor(this.cli());
            Etch etch = store.getEtch();
            etch.visitIndex((IEtchIndexVisitor)visitor);
            long fails = visitor.failures;
            if (fails > 0L) {
                throw new CLIError("Etch validation failed!");
            }
            long len = etch.getDataLength();
            long cellCount = visitor.values;
            this.cli().println("Etch validation completed with " + fails + " error(s)");
            this.cli().println("Index nodes:              " + Text.toFriendlyNumber((long)visitor.indexPtrs));
            this.cli().println("Cells:                    " + Text.toFriendlyNumber((long)cellCount));
            this.cli().println("Empty:                    " + Text.toFriendlyNumber((long)visitor.empty));
            this.cli().println("Database size:            " + Text.toFriendlyNumber((long)len));
            this.cli().println("Avg. Encoding Length:     " + Text.toFriendlyDecimal((double)((double)visitor.encoded / (double)cellCount)));
            this.cli().println("Storage per Cell (bytes): " + Text.toFriendlyDecimal((double)((double)len / (double)cellCount)));
        }
        catch (EtchCorruptionError e) {
            throw new CLIError("Etch file corrupt: " + String.valueOf(store), e);
        }
        catch (IOException e) {
            throw new CLIError("IO Error traversing etch store: " + String.valueOf(store), e);
        }
    }

    public class ValidateVisitor
    extends EtchUtils.FullValidator {
        protected Main cli;
        public long failures = 0L;
        public long encoded = 0L;

        public ValidateVisitor(Main cli) {
            this.cli = cli;
        }

        public void visitHash(Etch e, Hash h) {
            try {
                RefSoft r = e.read((AArrayBlob)h);
                ACell cell = r.getValue();
                cell.validate();
                Blob encoding = cell.getEncoding();
                this.encoded += encoding.count();
            }
            catch (InvalidDataException | IOException e1) {
                this.fail("Failed to validate cell " + String.valueOf(h) + " cause:" + String.valueOf(e1));
            }
        }

        public void fail(String msg) {
            this.cli.inform(msg);
            ++this.failures;
            if (EtchValidate.this.maxFailures != null && this.failures >= EtchValidate.this.maxFailures) {
                throw new CLIError("Max Failures exceeded");
            }
        }
    }
}

