/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.core.crypto.PFXTools;
import convex.core.util.Utils;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picocli.CommandLine;

public class Helpers {
    public static final CommandLine.Help.ColorScheme usageColourScheme = new CommandLine.Help.ColorScheme.Builder().commands(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.bold, CommandLine.Help.Ansi.Style.underline}).options(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_yellow}).parameters(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_yellow}).optionParams(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.italic}).errors(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_red, CommandLine.Help.Ansi.Style.bold}).stackTraces(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.italic}).build();

    public static List<String> splitArrayParameter(String ... parameterValues) {
        ArrayList<String> result = new ArrayList<String>(parameterValues.length);
        for (int index = 0; index < parameterValues.length; ++index) {
            String value = parameterValues[index];
            if (value.indexOf(",") > 0) {
                String[] items = value.split(",");
                for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
                    String newValue = items[itemIndex].trim();
                    if (newValue.length() <= 0) continue;
                    result.add(newValue);
                }
                continue;
            }
            result.add(value.trim());
        }
        return result;
    }

    public static File createTempFile(String name, String ext) throws IOException {
        File temp = File.createTempFile(name, ext);
        temp.deleteOnExit();
        return temp;
    }

    public static File createTempKeystore(String name, char[] password) throws IOException, GeneralSecurityException {
        File temp = File.createTempFile(name, ".pfx");
        PFXTools.createStore((File)temp, (char[])password);
        return temp;
    }

    public static int[] getPortList(String[] ports, int count) {
        try {
            Pattern rangePattern = Pattern.compile("([0-9]+)\\s*-\\s*([0-9]*)");
            List<String> portTextList = Helpers.splitArrayParameter(ports);
            ArrayList<Integer> portList = new ArrayList<Integer>();
            int countLeft = count;
            for (int index = 0; index < portTextList.size() && countLeft > 0; ++index) {
                String item = portTextList.get(index);
                Matcher matcher = rangePattern.matcher(item);
                if (matcher.matches()) {
                    int portFrom = Integer.parseInt(matcher.group(1));
                    int portTo = portFrom + count + 1;
                    if (!matcher.group(2).isEmpty()) {
                        portTo = Integer.parseInt(matcher.group(2));
                    }
                    for (int portIndex = portFrom; portIndex <= portTo && countLeft > 0; ++portIndex, --countLeft) {
                        portList.add(portIndex);
                    }
                    continue;
                }
                if (item.isBlank()) continue;
                portList.add(Integer.parseInt(item));
                --countLeft;
            }
            return portList.stream().mapToInt(Integer::intValue).toArray();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getConvexArt() {
        try {
            String art = Utils.readResourceAsString((String)"/art/convex.logo");
            return art;
        }
        catch (IOException e) {
            return null;
        }
    }
}

