/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.sort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultRowSorter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.sort.SortUtils;
import org.jdesktop.swingx.sort.StringValueProvider;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultSortController<M>
extends DefaultRowSorter<M, Integer>
implements SortController<M> {
    public static final Comparator COMPARABLE_COMPARATOR = new ComparableComparator();
    private static final SortOrder[] DEFAULT_CYCLE = new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING};
    private List<SortOrder> sortCycle;
    private boolean sortable;
    private StringValueProvider stringValueProvider;
    protected int cachedModelRowCount;
    private static final StringValueProvider DEFAULT_PROVIDER = new StringValueProvider(){

        public StringValue getStringValue(int row, int column) {
            return StringValues.TO_STRING;
        }
    };

    public DefaultSortController() {
        this.setSortable(true);
        this.setSortOrderCycle(DEFAULT_CYCLE);
        this.setSortsOnUpdates(true);
    }

    @Override
    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public void setSortable(int column, boolean sortable) {
        super.setSortable(column, sortable);
    }

    @Override
    public boolean isSortable(int column) {
        if (!this.isSortable()) {
            return false;
        }
        return super.isSortable(column);
    }

    @Override
    public void toggleSortOrder(int column) {
        RowSorter.SortKey sortKey;
        this.checkColumn(column);
        if (!this.isSortable(column)) {
            return;
        }
        SortOrder firstInCycle = this.getFirstInCycle();
        if (firstInCycle == null) {
            return;
        }
        List<RowSorter.SortKey> keys2 = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        if (keys2.indexOf(sortKey = SortUtils.getFirstSortKeyForColumn(keys2, column)) == 0) {
            keys2.set(0, new RowSorter.SortKey(column, this.getNextInCycle(sortKey.getSortOrder())));
        } else {
            keys2.remove(sortKey);
            keys2.add(0, new RowSorter.SortKey(column, this.getFirstInCycle()));
        }
        if (keys2.size() > this.getMaxSortKeys()) {
            keys2 = keys2.subList(0, this.getMaxSortKeys());
        }
        this.setSortKeys(keys2);
    }

    private SortOrder getNextInCycle(SortOrder current) {
        int pos = this.sortCycle.indexOf((Object)current);
        if (pos < 0) {
            return this.getFirstInCycle();
        }
        if (++pos >= this.sortCycle.size()) {
            pos = 0;
        }
        return this.sortCycle.get(pos);
    }

    private SortOrder getFirstInCycle() {
        return this.sortCycle.size() > 0 ? this.sortCycle.get(0) : null;
    }

    private void checkColumn(int column) {
        if (column < 0 || column >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }

    @Override
    public void setSortOrder(int column, SortOrder sortOrder) {
        if (!this.isSortable(column)) {
            return;
        }
        RowSorter.SortKey replace = new RowSorter.SortKey(column, sortOrder);
        ArrayList<RowSorter.SortKey> keys2 = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        SortUtils.removeFirstSortKeyForColumn(keys2, column);
        keys2.add(0, replace);
        this.setSortKeys(keys2);
    }

    @Override
    public SortOrder getSortOrder(int column) {
        RowSorter.SortKey key = SortUtils.getFirstSortKeyForColumn(this.getSortKeys(), column);
        return key != null ? key.getSortOrder() : SortOrder.UNSORTED;
    }

    @Override
    public void resetSortOrders() {
        if (!this.isSortable()) {
            return;
        }
        ArrayList<RowSorter.SortKey> keys2 = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        for (int i = keys2.size() - 1; i >= 0; --i) {
            RowSorter.SortKey sortKey = (RowSorter.SortKey)keys2.get(i);
            if (!this.isSortable(sortKey.getColumn())) continue;
            keys2.remove(sortKey);
        }
        this.setSortKeys(keys2);
    }

    @Override
    public SortOrder[] getSortOrderCycle() {
        return this.sortCycle.toArray(new SortOrder[0]);
    }

    @Override
    public void setSortOrderCycle(SortOrder ... cycle) {
        Contract.asNotNull(cycle, "Elements of SortOrderCycle must not be null");
        this.sortCycle = Arrays.asList(cycle);
    }

    @Override
    public void setStringValueProvider(StringValueProvider registry) {
        this.stringValueProvider = registry;
    }

    @Override
    public StringValueProvider getStringValueProvider() {
        if (this.stringValueProvider == null) {
            this.stringValueProvider = DEFAULT_PROVIDER;
        }
        return this.stringValueProvider;
    }

    public static SortOrder[] getDefaultSortOrderCycle() {
        return Arrays.copyOf(DEFAULT_CYCLE, DEFAULT_CYCLE.length);
    }

    @Override
    public int convertRowIndexToModel(int viewIndex) {
        if (viewIndex < 0 || viewIndex >= this.getViewRowCount()) {
            throw new IndexOutOfBoundsException("valid viewIndex: 0 <= index < " + this.getViewRowCount() + " but was: " + viewIndex);
        }
        try {
            return super.convertRowIndexToModel(viewIndex);
        }
        catch (Exception exception) {
            return viewIndex;
        }
    }

    @Override
    public int convertRowIndexToView(int modelIndex) {
        if (modelIndex < 0 || modelIndex >= this.getModelRowCount()) {
            throw new IndexOutOfBoundsException("valid modelIndex: 0 <= index < " + this.getModelRowCount() + " but was: " + modelIndex);
        }
        try {
            return super.convertRowIndexToView(modelIndex);
        }
        catch (Exception exception) {
            return modelIndex;
        }
    }

    @Override
    public int getModelRowCount() {
        return this.cachedModelRowCount;
    }

    @Override
    public int getViewRowCount() {
        if (this.hasRowFilter()) {
            return super.getViewRowCount();
        }
        return this.getModelRowCount();
    }

    private boolean hasRowFilter() {
        return this.getRowFilter() != null;
    }

    @Override
    public void allRowsChanged() {
        this.cachedModelRowCount = this.getModelWrapper().getRowCount();
        super.allRowsChanged();
    }

    @Override
    public void modelStructureChanged() {
        super.modelStructureChanged();
        this.cachedModelRowCount = this.getModelWrapper().getRowCount();
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
        this.cachedModelRowCount = this.getModelWrapper().getRowCount();
        super.rowsDeleted(firstRow, endRow);
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
        this.cachedModelRowCount = this.getModelWrapper().getRowCount();
        super.rowsInserted(firstRow, endRow);
    }

    private static class ComparableComparator
    implements Comparator {
        private ComparableComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    }
}

