/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.painter.AbstractPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusyPainter
extends AbstractPainter<Object> {
    private int frame = -1;
    private int points = 8;
    private Color baseColor = new Color(200, 200, 200);
    private Color highlightColor = Color.BLACK;
    private int trailLength = 4;
    private Shape pointShape;
    private Shape trajectory;
    private JXBusyLabel.Direction direction = JXBusyLabel.Direction.RIGHT;
    private boolean paintCentered;

    public BusyPainter() {
        this(26);
    }

    public BusyPainter(int height) {
        this(BusyPainter.getScaledDefaultPoint(height), BusyPainter.getScaledDefaultTrajectory(height));
    }

    protected static Shape getScaledDefaultTrajectory(int height) {
        return new Ellipse2D.Float(height * 8 / 26 / 2, height * 8 / 26 / 2, height - height * 8 / 26, height - height * 8 / 26);
    }

    protected static Shape getScaledDefaultPoint(int height) {
        return new RoundRectangle2D.Float(0.0f, 0.0f, height * 8 / 26, 4.0f, 4.0f, 4.0f);
    }

    public BusyPainter(Shape point, Shape trajectory) {
        this.init(point, trajectory, Color.LIGHT_GRAY, Color.BLACK);
    }

    protected void init(Shape point, Shape trajectory, Color baseColor, Color highlightColor) {
        this.baseColor = baseColor;
        this.highlightColor = highlightColor;
        this.pointShape = point;
        this.trajectory = trajectory;
    }

    @Override
    protected void doPaint(Graphics2D g, Object t, int width, int height) {
        int i;
        Rectangle r = this.getTrajectory().getBounds();
        int tw = width - r.width - 2 * r.x;
        int th = height - r.height - 2 * r.y;
        if (this.isPaintCentered()) {
            g.translate(tw / 2, th / 2);
        }
        PathIterator pi = this.trajectory.getPathIterator(null);
        float[] coords = new float[6];
        Point2D.Float cp = new Point2D.Float();
        Point2D.Float sp = new Point2D.Float();
        float totalDist = 0.0f;
        ArrayList<float[]> segStack = new ArrayList<float[]>();
        do {
            float c;
            int ret;
            try {
                ret = pi.currentSegment(coords);
            }
            catch (NoSuchElementException e) {
                return;
            }
            if (ret == 1 || ret == 4 && (sp.x != cp.x || sp.y != cp.y)) {
                c = this.calcLine(coords, cp);
                totalDist += c;
                segStack.add(new float[]{c, 0.0f, 0.0f, 0.0f, 0.0f, coords[0], coords[1], ret});
                cp.x = coords[0];
                cp.y = coords[1];
            }
            if (ret == 0) {
                sp.x = cp.x = coords[0];
                sp.y = cp.y = coords[1];
            }
            if (ret == 3) {
                c = this.calcCube(coords, cp);
                totalDist += c;
                segStack.add(new float[]{c, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], ret});
                cp.x = coords[4];
                cp.y = coords[5];
            }
            if (ret == 2) {
                c = this.calcLengthOfQuad(coords, cp);
                totalDist += c;
                segStack.add(new float[]{c, coords[0], coords[1], 0.0f, 0.0f, coords[2], coords[3], ret});
                cp.x = coords[2];
                cp.y = coords[3];
            }
            pi.next();
        } while (!pi.isDone());
        float nxtP = totalDist / (float)this.getPoints();
        ArrayList<Point2D.Float> pList = new ArrayList<Point2D.Float>();
        pList.add(new Point2D.Float(sp.x, sp.y));
        int sgIdx = 0;
        float[] sgmt = (float[])segStack.get(sgIdx);
        float len = sgmt[0];
        float travDist = nxtP;
        Point2D.Float center = new Point2D.Float(sp.x, sp.y);
        for (i = 1; i < this.getPoints(); ++i) {
            while (len < nxtP) {
                sp.x = sgmt[5];
                sp.y = sgmt[6];
                sgmt = (float[])segStack.get(++sgIdx);
                travDist = nxtP - len;
                len += sgmt[0];
            }
            len -= nxtP;
            Point2D.Float p = this.calcPoint(travDist, sp, sgmt, width, height);
            pList.add(p);
            center.x += p.x;
            center.y += p.y;
            travDist += nxtP;
        }
        center.x = (float)width / 2.0f;
        center.y = (float)height / 2.0f;
        i = 0;
        g.translate(center.x, center.y);
        for (Point2D.Float p : pList) {
            this.drawAt(g, i++, p, center);
        }
        g.translate(-center.x, -center.y);
        if (this.isPaintCentered()) {
            g.translate(-tw / 2, -th / 2);
        }
    }

    public boolean isPaintCentered() {
        return this.paintCentered;
    }

    private void drawAt(Graphics2D g, int i, Point2D.Float p, Point2D.Float c) {
        g.setColor(this.calcFrameColor(i));
        this.paintRotatedCenteredShapeAtPoint(p, c, g);
    }

    private void paintRotatedCenteredShapeAtPoint(Point2D.Float p, Point2D.Float c, Graphics2D g) {
        Shape s = this.getPointShape();
        double hh = s.getBounds().getHeight() / 2.0;
        double wh = s.getBounds().getWidth() / 2.0;
        double a = c.y - p.y;
        double b = p.x - c.x;
        double sa = Math.signum(a);
        double sb = Math.signum(b);
        sa = sa == 0.0 ? 1.0 : sa;
        sb = sb == 0.0 ? 1.0 : sb;
        a = Math.abs(a);
        b = Math.abs(b);
        double t = Math.atan(a / b);
        t = sa > 0.0 ? (sb > 0.0 ? -t : -Math.PI + t) : (sb > 0.0 ? t : Math.PI - t);
        double x = Math.sqrt(a * a + b * b) - wh;
        double y = -hh;
        g.rotate(t);
        g.translate(x, y);
        g.fill(s);
        g.translate(-x, -y);
        g.rotate(-t);
    }

    private Point2D.Float calcPoint(float dist2go, Point2D.Float startPoint, float[] sgmt, int w, int h) {
        Point2D.Float f = new Point2D.Float();
        if (sgmt[7] == 1.0f) {
            float a = sgmt[5] - startPoint.x;
            float b = sgmt[6] - startPoint.y;
            float pathLen = sgmt[0];
            f.x = startPoint.x + a * dist2go / pathLen;
            f.y = startPoint.y + b * dist2go / pathLen;
        } else if (sgmt[7] == 2.0f) {
            Point2D.Float ctrl = new Point2D.Float(sgmt[1] / (float)w, sgmt[2] / (float)h);
            Point2D.Float end = new Point2D.Float(sgmt[5] / (float)w, sgmt[6] / (float)h);
            Point2D.Float start2 = new Point2D.Float(startPoint.x / (float)w, startPoint.y / (float)h);
            f = BusyPainter.getXY(dist2go / sgmt[0], start2, ctrl, end);
            f.x *= (float)w;
            f.y *= (float)h;
        } else if (sgmt[7] == 3.0f) {
            float x = Math.abs(startPoint.x - sgmt[5]);
            float y = Math.abs(startPoint.y - sgmt[6]);
            float c1rx = Math.abs(startPoint.x - sgmt[1]) / x;
            float c1ry = Math.abs(startPoint.y - sgmt[2]) / y;
            float c2rx = Math.abs(startPoint.x - sgmt[3]) / x;
            float c2ry = Math.abs(startPoint.y - sgmt[4]) / y;
            f = this.getXY(dist2go / sgmt[0], c1rx, c1ry, c2rx, c2ry);
            float a = startPoint.x - sgmt[5];
            float b = startPoint.y - sgmt[6];
            f.x = startPoint.x - f.x * a;
            f.y = startPoint.y - f.y * b;
        }
        return f;
    }

    private float calcLine(float[] coords, Point2D.Float cp) {
        float a = cp.x - coords[0];
        float b = cp.y - coords[1];
        float c = (float)Math.sqrt(a * a + b * b);
        return c;
    }

    private float calcCube(float[] coords, Point2D.Float cp) {
        float x = Math.abs(cp.x - coords[4]);
        float y = Math.abs(cp.y - coords[5]);
        float c1rx = Math.abs(cp.x - coords[0]) / x;
        float c1ry = Math.abs(cp.y - coords[1]) / y;
        float c2rx = Math.abs(cp.x - coords[2]) / x;
        float c2ry = Math.abs(cp.y - coords[3]) / y;
        float prevLength = 0.0f;
        float prevX = 0.0f;
        float prevY = 0.0f;
        for (float t = 0.01f; t <= 1.0f; t += 0.01f) {
            Point2D.Float xy = this.getXY(t, c1rx, c1ry, c2rx, c2ry);
            prevLength += (float)Math.sqrt((xy.x - prevX) * (xy.x - prevX) + (xy.y - prevY) * (xy.y - prevY));
            prevX = xy.x;
            prevY = xy.y;
        }
        float z = (Math.abs(x) + Math.abs(y)) / 2.0f * prevLength;
        return z;
    }

    private float calcLengthOfQuad(float[] coords, Point2D.Float cp) {
        Point2D.Float ctrl = new Point2D.Float(coords[0], coords[1]);
        Point2D.Float end = new Point2D.Float(coords[2], coords[3]);
        float c1ax = Math.abs(cp.x - ctrl.x);
        float c1ay = Math.abs(cp.y - ctrl.y);
        float e1ax = Math.abs(cp.x - end.x);
        float e1ay = Math.abs(cp.y - end.y);
        float maxX = Math.max(c1ax, e1ax);
        float maxY = Math.max(c1ay, e1ay);
        ctrl.x = c1ax / maxX;
        ctrl.y = c1ay / maxY;
        end.x = e1ax / maxX;
        end.y = e1ay / maxY;
        float prevLength = 0.0f;
        float prevX = 0.0f;
        float prevY = 0.0f;
        for (float t = 0.01f; t <= 1.0f; t += 0.01f) {
            Point2D.Float xy = BusyPainter.getXY(t, new Point2D.Float(0.0f, 0.0f), ctrl, end);
            prevLength += (float)Math.sqrt((xy.x - prevX) * (xy.x - prevX) + (xy.y - prevY) * (xy.y - prevY));
            prevX = xy.x;
            prevY = xy.y;
        }
        float a = Math.abs(coords[2] - cp.x);
        float b = Math.abs(coords[3] - cp.y);
        float dist = (float)Math.sqrt(a * a + b * b);
        return prevLength * dist;
    }

    private Point2D.Float getXY(float t, float x1, float y1, float x2, float y2) {
        float invT = 1.0f - t;
        float b1 = 3.0f * t * (invT * invT);
        float b2 = 3.0f * (t * t) * invT;
        float b3 = t * t * t;
        Point2D.Float xy = new Point2D.Float(b1 * x1 + b2 * x2 + b3, b1 * y1 + b2 * y2 + b3);
        return xy;
    }

    public static Point2D.Float getXY(float t, Point2D.Float begin, Point2D.Float ctrl, Point2D.Float end) {
        float invT = 1.0f - t;
        float b0 = invT * invT;
        float b1 = 2.0f * t * invT;
        float b2 = t * t;
        Point2D.Float xy = new Point2D.Float(b0 * begin.x + b1 * ctrl.x + b2 * end.x, b0 * begin.y + b1 * ctrl.y + b2 * end.y);
        return xy;
    }

    private Color calcFrameColor(int i) {
        if (this.frame == -1) {
            return this.getBaseColor();
        }
        for (int t = 0; t < this.getTrailLength(); ++t) {
            if (this.direction == JXBusyLabel.Direction.RIGHT && i == (this.frame - t + this.getPoints()) % this.getPoints()) {
                float terp = 1.0f - (float)(this.getTrailLength() - t) / (float)this.getTrailLength();
                return ColorUtil.interpolate(this.getBaseColor(), this.getHighlightColor(), terp);
            }
            if (this.direction != JXBusyLabel.Direction.LEFT || i != (this.frame + t) % this.getPoints()) continue;
            float terp = (float)t / (float)this.getTrailLength();
            return ColorUtil.interpolate(this.getBaseColor(), this.getHighlightColor(), terp);
        }
        return this.getBaseColor();
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        int old = this.getFrame();
        this.frame = frame;
        this.firePropertyChange("frame", old, this.getFrame());
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color baseColor) {
        Color old = this.getBaseColor();
        this.baseColor = baseColor;
        this.firePropertyChange("baseColor", old, this.getBaseColor());
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        Color old = this.getHighlightColor();
        this.highlightColor = highlightColor;
        this.firePropertyChange("highlightColor", old, this.getHighlightColor());
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        int old = this.getPoints();
        this.points = points;
        this.firePropertyChange("points", old, this.getPoints());
    }

    public int getTrailLength() {
        return this.trailLength;
    }

    public void setTrailLength(int trailLength) {
        int old = this.getTrailLength();
        this.trailLength = trailLength;
        this.firePropertyChange("trailLength", old, this.getTrailLength());
    }

    public final Shape getPointShape() {
        return this.pointShape;
    }

    public final void setPointShape(Shape pointShape) {
        Shape old = this.getPointShape();
        this.pointShape = pointShape;
        if (this.getPointShape() != old && this.getPointShape() != null && !this.getPointShape().equals(old)) {
            this.firePropertyChange("pointShape", old, this.getPointShape());
        }
    }

    public final Shape getTrajectory() {
        return this.trajectory;
    }

    public final void setTrajectory(Shape trajectory) {
        Shape old = this.getTrajectory();
        this.trajectory = trajectory;
        if (this.getTrajectory() != old && this.getTrajectory() != null && !this.getTrajectory().equals(old)) {
            this.firePropertyChange("trajectory", old, this.getTrajectory());
        }
    }

    public void setDirection(JXBusyLabel.Direction dir) {
        JXBusyLabel.Direction old = this.getDirection();
        this.direction = dir;
        if (this.getDirection() != old && this.getDirection() != null && !this.getDirection().equals((Object)old)) {
            this.firePropertyChange("direction", (Object)old, (Object)this.getDirection());
        }
    }

    public JXBusyLabel.Direction getDirection() {
        return this.direction;
    }

    protected Shape provideShape(Graphics2D g, Object comp, int width, int height) {
        return new Rectangle(0, 0, width, height);
    }

    public void setPaintCentered(boolean paintCentered) {
        boolean old = this.isPaintCentered();
        this.paintCentered = paintCentered;
        this.firePropertyChange("paintCentered", old, this.isPaintCentered());
    }
}

