/*
 * Decompiled with CFR 0.152.
 */
package convex.core.transactions;

import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Symbol;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.transactions.ATransaction;
import java.nio.ByteBuffer;

public class Call
extends ATransaction {
    protected final Address target;
    protected final long offer;
    protected final Symbol functionName;
    protected final AVector<ACell> args;

    protected Call(Address address, long sequence, Address target, long offer, Symbol functionName, AVector<ACell> args2) {
        super(address, sequence);
        this.target = target;
        this.functionName = functionName;
        this.offer = offer;
        this.args = args2;
    }

    public static Call create(Address address, long sequence, Address target, long offer, Symbol functionName, AVector<ACell> args2) {
        return new Call(address, sequence, target, 0L, functionName, args2);
    }

    public static Call create(Address address, long sequence, Address target, Symbol functionName, AVector<ACell> args2) {
        return Call.create(address, sequence, target, 0L, functionName, args2);
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append("{");
        bb.append(":target ");
        if (!RT.print(bb, this.target, limit)) {
            return false;
        }
        if (this.offer > 0L) {
            bb.append(" :offer ");
            bb.append(Long.toString(this.offer));
        }
        bb.append('}');
        return bb.check(limit);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -46;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = super.encodeRaw(bs, pos);
        pos = Format.write(bs, pos, this.target);
        pos = Format.writeVLCLong(bs, pos, this.offer);
        pos = Format.write(bs, pos, this.functionName);
        pos = Format.write(bs, pos, this.args);
        return pos;
    }

    public static ATransaction read(ByteBuffer bb) throws BadFormatException {
        Address address = Address.create(Format.readVLCLong(bb));
        long sequence = Format.readVLCLong(bb);
        Address target = (Address)Format.read(bb);
        long offer = Format.readVLCLong(bb);
        Symbol functionName = (Symbol)Format.read(bb);
        AVector args2 = (AVector)Format.read(bb);
        return Call.create(address, sequence, target, offer, functionName, args2);
    }

    @Override
    public int estimatedEncodingSize() {
        return 100;
    }

    @Override
    public <T extends ACell> Context<T> apply(Context<?> ctx) {
        return ctx.actorCall(this.target, this.offer, this.functionName, this.args.toCellArray());
    }

    @Override
    public Long getMaxJuice() {
        return 1000000L;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.target.validateCell();
    }

    @Override
    public int getRefCount() {
        return this.args.getRefCount();
    }

    public <T extends ACell> Ref<T> getRef(int i) {
        return this.args.getRef(i);
    }

    @Override
    public ACell updateRefs(IRefFunction func) {
        ACell newArgs = this.args.updateRefs(func);
        if (this.args == newArgs) {
            return this;
        }
        return new Call(this.origin, this.sequence, this.target, this.offer, this.functionName, (AVector<ACell>)newArgs);
    }

    @Override
    public Call withSequence(long newSequence) {
        if (newSequence == this.sequence) {
            return this;
        }
        return Call.create(this.origin, newSequence, this.target, this.offer, this.functionName, this.args);
    }

    @Override
    public Call withOrigin(Address newAddress) {
        if (newAddress == this.origin) {
            return this;
        }
        return Call.create(newAddress, this.sequence, this.target, this.offer, this.functionName, this.args);
    }

    @Override
    public byte getTag() {
        return -46;
    }
}

