/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.plaf.ButtonUI;
import org.jdesktop.swingx.hyperlink.HyperlinkAction;
import org.jdesktop.swingx.plaf.HyperlinkAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXHyperlink
extends JButton {
    public static final String uiClassID = "HyperlinkUI";
    private boolean hasBeenVisited = false;
    private Color unclickedColor = new Color(0, 51, 255);
    private Color clickedColor = new Color(153, 0, 153);
    private boolean overrulesActionOnClick;

    public JXHyperlink() {
        this((Action)null);
    }

    public JXHyperlink(Action action) {
        this.setAction(action);
        this.init();
    }

    public void setURI(URI uri2) {
        this.setAction(HyperlinkAction.createHyperlinkAction(uri2));
    }

    public Color getUnclickedColor() {
        return this.unclickedColor;
    }

    public void setClickedColor(Color color) {
        Color old = this.getClickedColor();
        this.clickedColor = color;
        if (this.isClicked()) {
            this.setForeground(this.getClickedColor());
        }
        this.firePropertyChange("clickedColor", old, this.getClickedColor());
    }

    public Color getClickedColor() {
        return this.clickedColor;
    }

    public void setUnclickedColor(Color color) {
        Color old = this.getUnclickedColor();
        this.unclickedColor = color;
        if (!this.isClicked()) {
            this.setForeground(this.getUnclickedColor());
        }
        this.firePropertyChange("unclickedColor", old, this.getUnclickedColor());
    }

    public void setClicked(boolean clicked) {
        boolean old = this.isClicked();
        this.hasBeenVisited = clicked;
        this.setForeground(this.isClicked() ? this.getClickedColor() : this.getUnclickedColor());
        this.firePropertyChange("clicked", old, this.isClicked());
    }

    public boolean isClicked() {
        return this.hasBeenVisited;
    }

    public void setOverrulesActionOnClick(boolean overrule) {
        boolean old = this.getOverrulesActionOnClick();
        this.overrulesActionOnClick = overrule;
        this.firePropertyChange("overrulesActionOnClick", old, this.getOverrulesActionOnClick());
    }

    public boolean getOverrulesActionOnClick() {
        return this.overrulesActionOnClick;
    }

    protected void fireActionPerformed(ActionEvent event) {
        super.fireActionPerformed(event);
        if (this.isAutoSetClicked()) {
            this.setClicked(true);
        }
    }

    protected boolean isAutoSetClicked() {
        return this.getAction() == null || this.getOverrulesActionOnClick();
    }

    protected PropertyChangeListener createActionPropertyChangeListener(final Action a) {
        final PropertyChangeListener superListener = super.createActionPropertyChangeListener(a);
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("visited".equals(evt.getPropertyName())) {
                    JXHyperlink.this.configureClickedPropertyFromAction(a);
                } else {
                    superListener.propertyChange(evt);
                }
            }
        };
    }

    protected void configurePropertiesFromAction(Action a) {
        super.configurePropertiesFromAction(a);
        this.configureClickedPropertyFromAction(a);
    }

    private void configureClickedPropertyFromAction(Action a) {
        boolean clicked = false;
        if (a != null) {
            clicked = Boolean.TRUE.equals(a.getValue("visited"));
        }
        this.setClicked(clicked);
    }

    private void init() {
        this.setForeground(this.isClicked() ? this.getClickedColor() : this.getUnclickedColor());
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        this.setUI((ButtonUI)LookAndFeelAddons.getUI(this, ButtonUI.class));
    }

    static {
        LookAndFeelAddons.contribute(new HyperlinkAddon());
    }
}

