/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.utils;

import java.awt.FontMetrics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import mdlaf.utils.Utils;

public class WrapperSwingUtilities {
    private static WrapperSwingUtilities SINGLETON;
    protected Class wrapperClass;
    protected Method getClippedString;

    public static WrapperSwingUtilities getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new WrapperSwingUtilities();
        }
        return SINGLETON;
    }

    private WrapperSwingUtilities() {
        this.initMethodWithJavaVersion();
    }

    public void initMethodWithJavaVersion() {
        try {
            if (Utils.isJavaVersionUnderJava9()) {
                this.wrapperClass = Class.forName("sun.swing.SwingUtilities2");
                this.getClippedString = this.wrapperClass.getMethod("clipStringIfNecessary", JComponent.class, FontMetrics.class, String.class, Integer.TYPE);
            } else {
                this.wrapperClass = Class.forName("javax.swing.plaf.basic.BasicGraphicsUtils");
                this.getClippedString = this.wrapperClass.getMethod("getClippedString", JComponent.class, FontMetrics.class, String.class, Integer.TYPE);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getCause());
        }
    }

    public String getClippedString(JComponent component, FontMetrics fontMetrics, String text, int availTextWidth) {
        try {
            return (String)this.getClippedString.invoke((Object)this.wrapperClass, component, fontMetrics, text, availTextWidth);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getCause());
        }
    }
}

