/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import java.lang.ref.SoftReference;

public final class BlobCache {
    private SoftReference<ACell>[] cache;
    private int size;

    private BlobCache(int size) {
        this.size = size;
        this.cache = new SoftReference[size];
    }

    public static BlobCache create(int size) {
        return new BlobCache(size);
    }

    int getSize() {
        return this.size;
    }

    public ACell getCell(ABlob encoding) {
        int ix = this.calcIndex(encoding);
        SoftReference<ACell> ref = this.cache[ix];
        if (ref == null) {
            return null;
        }
        ACell cell = ref.get();
        if (cell != null) {
            if (encoding.equals(cell.getEncoding())) {
                return cell;
            }
            return null;
        }
        this.cache[ix] = null;
        return null;
    }

    public void putCell(ACell cell) {
        int ix = this.calcIndex(cell.getEncoding());
        this.cache[ix] = new SoftReference<ACell>(cell);
    }

    private int calcIndex(ABlob encoding) {
        int hash = Long.hashCode(encoding.toLong());
        int ix = Math.floorMod(hash, this.size);
        return ix;
    }
}

