/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.BlobBuilder;
import convex.core.data.Strings;
import convex.core.data.prim.APrimitive;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;

public final class CVMBool
extends APrimitive {
    private final boolean value;
    public static final CVMBool TRUE = new CVMBool(true);
    public static final CVMBool FALSE = new CVMBool(false);
    public static final int MAX_ENCODING_LENGTH = 1;

    private CVMBool(boolean value) {
        this.value = value;
    }

    @Override
    public AType getType() {
        return Types.BOOLEAN;
    }

    public static CVMBool create(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static CVMBool of(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public long longValue() {
        return this.value ? 1L : 0L;
    }

    @Override
    public int estimatedEncodingSize() {
        return 1;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.value ? -79 : -80;
        return pos;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        throw new UnsupportedOperationException("Not meaningful to encode raw data for CVMBool");
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(this.value ? Strings.TRUE : Strings.FALSE);
        return bb.check(limit);
    }

    @Override
    public double doubleValue() {
        return this.value ? 1.0 : 0.0;
    }

    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public byte getTag() {
        return this.value ? (byte)-79 : -80;
    }

    public static ACell parse(String text) {
        if ("true".equals(text)) {
            return TRUE;
        }
        if ("false".equals(text)) {
            return FALSE;
        }
        return null;
    }

    @Override
    public AString toCVMString(long limit) {
        return this.value ? Strings.TRUE : Strings.FALSE;
    }
}

