/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.resourceloader;

import com.sun.jna.Platform;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoader {
    private final Logger logger = LoggerFactory.getLogger("ResourceLoader");
    private final Collection<PosixFilePermission> writePerms = new ArrayList<PosixFilePermission>();
    private final Collection<PosixFilePermission> readPerms = new ArrayList<PosixFilePermission>();
    private final Collection<PosixFilePermission> execPerms = new ArrayList<PosixFilePermission>();
    private static final long FILE_COPY_BUFFER_SIZE = 30000000L;

    ResourceLoader() {
        this.readPerms.add(PosixFilePermission.OWNER_READ);
        this.readPerms.add(PosixFilePermission.OTHERS_READ);
        this.readPerms.add(PosixFilePermission.GROUP_READ);
        this.writePerms.add(PosixFilePermission.OWNER_WRITE);
        this.writePerms.add(PosixFilePermission.OTHERS_WRITE);
        this.writePerms.add(PosixFilePermission.GROUP_WRITE);
        this.execPerms.add(PosixFilePermission.OWNER_EXECUTE);
        this.execPerms.add(PosixFilePermission.OTHERS_EXECUTE);
        this.execPerms.add(PosixFilePermission.GROUP_EXECUTE);
    }

    public File copyToTempDirectory(String relativePath, Class outsideClass) throws IOException, URISyntaxException {
        File extracted;
        File mainTempDir = ResourceLoader.createMainTempDirectory();
        mainTempDir.mkdirs();
        URL fullJarPathURL = ResourceLoader.getThePathToTheJarWeAreIn(outsideClass);
        if (this.isJarFile(fullJarPathURL) && (extracted = this.extractFromWithinAJarFile(fullJarPathURL, mainTempDir, relativePath)) != null) {
            return extracted;
        }
        return this.getFileFromFileSystem(relativePath, mainTempDir);
    }

    public File extractFromWithinAJarFile(URL jarPath, File mainTempDir, String relativePath) throws IOException, URISyntaxException {
        if (jarPath == null) {
            return null;
        }
        String fullPath = jarPath.toString() + this.prefixStringWithSlashIfNotAlready(relativePath);
        return this.nestedExtract(mainTempDir, fullPath);
    }

    private String prefixStringWithSlashIfNotAlready(String s) {
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        return s;
    }

    private File nestedExtract(File extractTo, String fullPath) throws IOException, URISyntaxException {
        String JAR = ".jar";
        String[] split = fullPath.split("(\\.jar/)");
        if (split.length > 20) {
            throw new StackOverflowError("We cannot extract a file 10 layers deep.");
        }
        if (split.length == 1) {
            this.logger.debug("Extracted {} to {}", (Object)fullPath, (Object)extractTo.getAbsolutePath());
            return this.extractFilesOrFoldersFromJar(extractTo, new URL(fullPath), "");
        }
        String currentExtractionPath = "";
        File extracted = null;
        for (int i = 0; i < split.length - 1; ++i) {
            boolean isLastIteration;
            String part = currentExtractionPath + split[i] + ".jar";
            if (!part.startsWith("file:")) {
                part = "file:" + part;
            }
            String nextPart = "/" + split[i + 1];
            boolean bl = isLastIteration = i == split.length - 2;
            if (!isLastIteration) {
                nextPart = nextPart + ".jar";
            }
            this.logger.debug("Extracting {} from {}", (Object)nextPart, (Object)part);
            extracted = this.extractFilesOrFoldersFromJar(extractTo, new URL(part), nextPart);
            this.logger.debug("Extracted: {}", (Object)extracted.getAbsolutePath());
            currentExtractionPath = extracted.getParentFile().getAbsolutePath() + "/";
        }
        return extracted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJarFile(URL jarUrl) {
        if (jarUrl == null) return false;
        try (JarFile jarFile = new JarFile(jarUrl.getPath());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException | IllegalStateException | SecurityException e) {
            this.logger.debug("This is not a JAR file due to {}", (Object)e.getMessage());
        }
        return false;
    }

    private File extractFilesOrFoldersFromJar(File outputDir, URL jarUrl, String pathInJar) throws URISyntaxException, IOException {
        File jar = ResourceLoader.urlToFile(jarUrl);
        ResourceLoader.unzip(jar.getAbsolutePath(), outputDir.getAbsolutePath());
        String filePath = outputDir.getAbsolutePath() + pathInJar;
        return new File(filePath);
    }

    private File getFileFromFileSystem(String relativePath, File outputDir) throws IOException, URISyntaxException {
        relativePath = this.prefixStringWithSlashIfNotAlready(relativePath);
        URL url2 = ResourceLoader.class.getResource(relativePath);
        String urlString = url2.getFile();
        File file = Platform.isWindows() ? Paths.get(url2.toURI()).toFile() : new File(urlString);
        if (file.isFile()) {
            File resource = new File(relativePath);
            File resourceCopiedToTempFolder = new File(outputDir, resource.getName());
            ResourceLoader.doCopyFile(file, resourceCopiedToTempFolder);
            return resourceCopiedToTempFolder;
        }
        ResourceLoader.copyDirectory(file, outputDir);
        return outputDir;
    }

    private static void unzip(String zipFilePath, String unzipLocation) throws IOException {
        if (!Files.exists(Paths.get(unzipLocation, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(unzipLocation, new String[0]), new FileAttribute[0]);
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                Path filePath = Paths.get(unzipLocation, entry.getName());
                if (!entry.isDirectory()) {
                    filePath.getParent().toFile().mkdirs();
                    ResourceLoader.unzipFiles(zipInputStream, filePath);
                } else {
                    Files.createDirectories(filePath, new FileAttribute[0]);
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
    }

    private static void unzipFiles(ZipInputStream zipInputStream, Path unzipFilePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(unzipFilePath.toAbsolutePath().toString()));){
            byte[] bytesIn = new byte[1024];
            int read = 0;
            while ((read = zipInputStream.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    private static void doCopyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        try (FileInputStream fis = new FileInputStream(srcFile);
             FileChannel input = fis.getChannel();
             FileOutputStream fos = new FileOutputStream(destFile);
             FileChannel output = fos.getChannel();){
            long bytesCopied;
            long size = input.size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += bytesCopied) {
                long remain = size - pos;
                count = remain > 30000000L ? 30000000L : remain;
                bytesCopied = output.transferFrom(input, pos, count);
                if (bytesCopied != 0L) continue;
                break;
            }
        }
        long srcLen = srcFile.length();
        long dstLen = destFile.length();
        if (srcLen != dstLen) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "' Expected length: " + srcLen + " Actual: " + dstLen);
        }
    }

    private static void copyDirectory(File srcDir, File destDir) throws IOException {
        File[] srcFiles;
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are the same");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath()) && (srcFiles = srcDir.listFiles()) != null && srcFiles.length > 0) {
            exclusionList = new ArrayList<String>(srcFiles.length);
            for (File srcFile : srcFiles) {
                File copiedFile = new File(destDir, srcFile.getName());
                exclusionList.add(copiedFile.getCanonicalPath());
            }
        }
        ResourceLoader.doCopyDirectory(srcDir, destDir, exclusionList);
    }

    private static void doCopyDirectory(File srcDir, File destDir, List<String> exclusionList) throws IOException {
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (exclusionList != null && exclusionList.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                ResourceLoader.doCopyDirectory(srcFile, dstFile, exclusionList);
                continue;
            }
            ResourceLoader.doCopyFile(srcFile, dstFile);
        }
    }

    public static File createMainTempDirectory() throws IOException {
        Path path = Files.createTempDirectory("resource-loader", new FileAttribute[0]);
        File dir = path.toFile();
        dir.mkdir();
        dir.deleteOnExit();
        return dir;
    }

    public File setPermissions(File file) throws IOException {
        return this.setPermissions(file, new HashSet<PosixFilePermission>());
    }

    public File setPermissions(File file, Set<PosixFilePermission> filePermissions) throws IOException {
        if (this.isPosixCompliant()) {
            if (filePermissions.isEmpty()) {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                perms.add(PosixFilePermission.OWNER_READ);
                perms.add(PosixFilePermission.OWNER_WRITE);
                perms.add(PosixFilePermission.OWNER_EXECUTE);
                perms.add(PosixFilePermission.OTHERS_READ);
                perms.add(PosixFilePermission.OTHERS_WRITE);
                perms.add(PosixFilePermission.OTHERS_EXECUTE);
                perms.add(PosixFilePermission.GROUP_READ);
                perms.add(PosixFilePermission.GROUP_WRITE);
                perms.add(PosixFilePermission.GROUP_EXECUTE);
                filePermissions = perms;
            }
            Files.setPosixFilePermissions(file.toPath(), filePermissions);
        } else if (filePermissions.stream().anyMatch(this.readPerms::contains)) {
            file.setReadable(true);
        } else if (filePermissions.stream().anyMatch(this.writePerms::contains)) {
            file.setWritable(true);
        } else {
            file.setExecutable(true);
        }
        return file;
    }

    public void requestDeletion(File file) {
        if (this.isPosixCompliant()) {
            file.delete();
        } else {
            file.deleteOnExit();
        }
    }

    protected boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    public static URL getThePathToTheJarWeAreIn(Class<?> c) {
        String suffix;
        if (c == null) {
            return null;
        }
        try {
            URL codeSourceLocation = c.getProtectionDomain().getCodeSource().getLocation();
            if (codeSourceLocation != null) {
                return codeSourceLocation;
            }
        }
        catch (SecurityException codeSourceLocation) {
        }
        catch (NullPointerException codeSourceLocation) {
            // empty catch block
        }
        URL classResource = c.getResource(c.getSimpleName() + ".class");
        if (classResource == null) {
            return null;
        }
        String url2 = classResource.toString();
        if (!url2.endsWith(suffix = c.getCanonicalName().replace('.', '/') + ".class")) {
            return null;
        }
        String path = url2.substring(0, url2.length() - suffix.length());
        if (path.startsWith("jar:")) {
            path = path.substring(4);
        }
        if ((path = path.replaceAll("(\\.jar\\!)+", ".jar")).endsWith("/")) {
            path = path.replaceAll("\\/*$", "");
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File urlToFile(URL url2) {
        return url2 == null ? null : ResourceLoader.urlToFile(url2.toString());
    }

    public static File urlToFile(String url2) {
        String path = url2;
        if (path.startsWith("jar:")) {
            int index = path.indexOf("!/");
            path = path.substring(4, index);
        }
        try {
            if (Platform.isWindows() && path.matches("file:[A-Za-z]:.*")) {
                path = "file:/" + path.substring(5);
            }
            return new File(new URL(path).toURI());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
            return new File(path);
        }
        throw new IllegalArgumentException("Invalid URL: " + url2);
    }
}

