/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Peer;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.net.Connection;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChallengeRequest {
    private static final Logger log = LoggerFactory.getLogger(ChallengeRequest.class.getName());
    private static final int TIMEOUT_SECONDS = 10;
    protected AccountKey peerKey;
    protected long timeout;
    protected Hash token;
    protected Hash sendHash;

    private ChallengeRequest(AccountKey peerKey, long timeout) {
        this.peerKey = peerKey;
        this.timeout = timeout;
    }

    public static ChallengeRequest create(AccountKey peerKey) {
        return ChallengeRequest.create(peerKey, 10);
    }

    public static ChallengeRequest create(AccountKey peerKey, int timeoutSeconds) {
        long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutSeconds);
        return new ChallengeRequest(peerKey, timeout);
    }

    public long send(Connection connection, Peer peer) {
        AVector values2 = null;
        try {
            SecureRandom random = new SecureRandom();
            byte[] bytes = new byte[120];
            random.nextBytes(bytes);
            this.token = Blob.create(bytes).getHash();
            values2 = Vectors.of(this.token, peer.getNetworkID(), this.peerKey);
            SignedData<ACell> challenge = peer.sign(values2);
            this.sendHash = challenge.getHash();
            return connection.sendChallenge(challenge);
        }
        catch (IOException e) {
            log.warn("Cannot send challenge to remote peer at {}", (Object)connection.getRemoteAddress());
            values2 = null;
            return -1L;
        }
    }

    public AccountKey getPeerKey() {
        return this.peerKey;
    }

    public Hash getToken() {
        return this.token;
    }

    public Hash getSendHash() {
        return this.sendHash;
    }

    public boolean isTimedout() {
        return this.timeout < System.currentTimeMillis();
    }
}

