/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.mainpanels;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.crypto.AKeyPair;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.gui.components.ActionPanel;
import convex.gui.components.PeerComponent;
import convex.gui.components.PeerView;
import convex.gui.components.ScrollyList;
import convex.gui.manager.PeerGUI;
import convex.peer.API;
import convex.peer.Server;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeersListPanel
extends JPanel {
    JPanel peersPanel;
    static DefaultListModel<PeerView> peerList = new DefaultListModel();
    JPanel peerViewPanel;
    JScrollPane scrollPane;
    private static final Logger log = LoggerFactory.getLogger(PeersListPanel.class.getName());

    public void launchAllPeers(PeerGUI manager) {
        block3: {
            try {
                int N = PeerGUI.KEYPAIRS.size();
                List<Server> serverList = API.launchLocalPeers(PeerGUI.KEYPAIRS, PeerGUI.genesisState);
                for (Server server : serverList) {
                    PeerView peer = new PeerView();
                    peer.peerServer = server;
                    this.addPeer(peer);
                }
            }
            catch (Exception e) {
                if (e instanceof ClosedChannelException) break block3;
                throw e;
            }
        }
    }

    public void launchPeer(PeerGUI manager) {
        AKeyPair kp = AKeyPair.generate();
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        config.put(Keywords.KEYPAIR, kp);
        config.put(Keywords.STATE, PeerGUI.genesisState);
        Server server = API.launchPeer(config);
        PeerView peer = new PeerView();
        peer.peerServer = server;
        this.addPeer(peer);
    }

    public static PeerView getFirst() {
        return peerList.elementAt(0);
    }

    public List<PeerView> getPeerViews() {
        ArrayList<PeerView> al = new ArrayList<PeerView>();
        int n = peerList.getSize();
        for (int i = 0; i < n; ++i) {
            PeerView p = peerList.getElementAt(i);
            al.add(p);
        }
        return al;
    }

    private void addPeer(PeerView peer) {
        peerList.addElement(peer);
    }

    public PeersListPanel(PeerGUI manager) {
        this.setLayout(new BorderLayout(0, 0));
        ActionPanel toolBar = new ActionPanel();
        this.add((Component)toolBar, "South");
        JButton btnLaunch = new JButton("Launch!");
        toolBar.add(btnLaunch);
        btnLaunch.addActionListener(e -> this.launchPeer(manager));
        JButton btnConnect = new JButton("Connect...");
        toolBar.add(btnConnect);
        btnConnect.addActionListener(e -> {
            String input = JOptionPane.showInputDialog("Enter host address: ", (Object)"");
            if (input == null) {
                return;
            }
            String[] ss = input.split(":");
            String host2 = ss[0].trim();
            int port = ss.length > 1 ? Integer.parseInt(ss[1].trim()) : 0;
            InetSocketAddress hostAddress = new InetSocketAddress(host2, port);
            try {
                ConvexRemote pc = Convex.connect(hostAddress, null, null);
                PeerView pv = new PeerView();
                pv.peerConnection = pc;
                this.addPeer(pv);
            }
            catch (Throwable e1) {
                JOptionPane.showMessageDialog(this, "Connect failed: " + e1.toString());
            }
        });
        ScrollyList<PeerView> scrollyList = new ScrollyList<PeerView>(peerList, peer -> new PeerComponent(manager, (PeerView)peer));
        this.add(scrollyList, "Center");
    }

    public void closePeers() {
        int n = peerList.getSize();
        for (int i = 0; i < n; ++i) {
            PeerView p = peerList.getElementAt(i);
            p.peerServer.close();
        }
    }
}

