/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlobMap;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.ARecord;
import convex.core.data.AString;
import convex.core.data.Address;
import convex.core.data.BlobMaps;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.lang.impl.RecordFormat;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public class PeerStatus
extends ARecord {
    private static final Keyword[] PEER_KEYS = new Keyword[]{Keywords.CONTROLLER, Keywords.STAKE, Keywords.STAKES, Keywords.DELEGATED_STAKE, Keywords.METADATA};
    private static final RecordFormat FORMAT = RecordFormat.of(PEER_KEYS);
    private final Address controller;
    private final long stake;
    private final long delegatedStake;
    private final ABlobMap<Address, CVMLong> stakes;
    private final AHashMap<Keyword, ACell> metadata;

    private PeerStatus(Address controller, long stake, ABlobMap<Address, CVMLong> stakes, long delegatedStake, AHashMap<Keyword, ACell> metadata) {
        super(FORMAT);
        this.controller = controller;
        this.stake = stake;
        this.delegatedStake = delegatedStake;
        this.metadata = metadata;
        this.stakes = stakes;
    }

    public static PeerStatus create(Address controller, long stake) {
        return PeerStatus.create(controller, stake, null);
    }

    public static PeerStatus create(Address controller, long stake, AHashMap<Keyword, ACell> metadata) {
        return new PeerStatus(controller, stake, (ABlobMap<Address, CVMLong>)BlobMaps.empty(), 0L, metadata);
    }

    public long getTotalStake() {
        return this.stake + this.delegatedStake;
    }

    public long getPeerStake() {
        return this.stake;
    }

    public Address getController() {
        return this.controller;
    }

    public long getDelegatedStake() {
        return this.delegatedStake;
    }

    public AString getHostname() {
        if (this.metadata == null) {
            return null;
        }
        return RT.ensureString(this.metadata.get(Keywords.URL));
    }

    public AHashMap<Keyword, ACell> getMetadata() {
        return this.metadata == null ? Maps.empty() : this.metadata;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -62;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.write(bs, pos, this.controller);
        pos = Format.writeVLCLong(bs, pos, this.stake);
        pos = Format.write(bs, pos, this.stakes);
        pos = Format.writeVLCLong(bs, pos, this.delegatedStake);
        pos = Format.write(bs, pos, this.metadata);
        return pos;
    }

    public static PeerStatus read(ByteBuffer bb) throws BadFormatException {
        Address owner = (Address)Format.read(bb);
        long stake = Format.readVLCLong(bb);
        ABlobMap stakes = (ABlobMap)Format.read(bb);
        long delegatedStake = Format.readVLCLong(bb);
        AHashMap metadata = (AHashMap)Format.read(bb);
        return new PeerStatus(owner, stake, stakes, delegatedStake, metadata);
    }

    @Override
    public int estimatedEncodingSize() {
        return 100;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public long getDelegatedStake(Address delegator) {
        CVMLong a = this.stakes.get(delegator);
        if (a == null) {
            return 0L;
        }
        return a.longValue();
    }

    public PeerStatus withDelegatedStake(Address delegator, long newStake) {
        long oldStake = this.getDelegatedStake(delegator);
        if (oldStake == newStake) {
            return this;
        }
        long newDelegatedStake = this.delegatedStake + newStake - oldStake;
        ABlobMap<Address, CVMLong> newStakes = newStake == 0L ? this.stakes.dissoc(delegator) : this.stakes.assoc(delegator, CVMLong.create(newStake));
        return new PeerStatus(this.controller, this.stake, newStakes, newDelegatedStake, this.metadata);
    }

    public PeerStatus withPeerStake(long newStake) {
        if (this.stake == newStake) {
            return this;
        }
        return new PeerStatus(this.controller, newStake, this.stakes, this.delegatedStake, this.metadata);
    }

    public PeerStatus withHostname(AString newHostname) {
        AMap newMeta = this.metadata;
        newMeta = newMeta == null ? Maps.create(Keywords.URL, newHostname) : newMeta.assoc(Keywords.URL, newHostname);
        if (this.metadata == newMeta) {
            return this;
        }
        return new PeerStatus(this.controller, this.stake, this.stakes, this.delegatedStake, (AHashMap<Keyword, ACell>)newMeta);
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public ACell get(ACell key) {
        if (Keywords.CONTROLLER.equals(key)) {
            return this.controller;
        }
        if (Keywords.STAKE.equals(key)) {
            return CVMLong.create(this.stake);
        }
        if (Keywords.STAKES.equals(key)) {
            return this.stakes;
        }
        if (Keywords.DELEGATED_STAKE.equals(key)) {
            return CVMLong.create(this.delegatedStake);
        }
        if (Keywords.METADATA.equals(key)) {
            return this.metadata;
        }
        return null;
    }

    @Override
    public byte getTag() {
        return -62;
    }

    @Override
    protected PeerStatus updateAll(ACell[] newVals) {
        Address newOwner = (Address)newVals[0];
        long newStake = ((CVMLong)newVals[1]).longValue();
        ABlobMap newStakes = (ABlobMap)newVals[2];
        long newDelStake = ((CVMLong)newVals[3]).longValue();
        AHashMap newMeta = (AHashMap)newVals[4];
        if (this.stake == newStake && this.stakes == newStakes && this.metadata == newMeta && this.delegatedStake == newDelStake) {
            return this;
        }
        return new PeerStatus(newOwner, newStake, newStakes, newDelStake, newMeta);
    }

    protected static long computeDelegatedStake(ABlobMap<Address, CVMLong> stakes) {
        long ds = stakes.reduceValues((? super R acc, ? super V e) -> acc + e.longValue(), 0L);
        return ds;
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof PeerStatus)) {
            return false;
        }
        PeerStatus ps = (PeerStatus)a;
        return this.equals(ps);
    }

    public boolean equals(PeerStatus a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Utils.equals(h, ha);
        }
        if (this.stake != a.stake) {
            return false;
        }
        if (this.delegatedStake != a.delegatedStake) {
            return false;
        }
        if (!Utils.equals(this.metadata, a.metadata)) {
            return false;
        }
        if (!Utils.equals(this.stakes, a.stakes)) {
            return false;
        }
        return Utils.equals(this.controller, a.controller);
    }
}

