/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.exceptions.BadFormatException;
import convex.core.store.Stores;
import convex.net.Connection;
import convex.net.message.Message;
import convex.peer.Server;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOServer
implements Closeable {
    public static final int DEFAULT_PORT = 18888;
    private static final Logger log = LoggerFactory.getLogger(NIOServer.class.getName());
    private ServerSocketChannel ssc = null;
    private BlockingQueue<Message> receiveQueue;
    private Selector selector = null;
    private boolean running = false;
    private final Server server;
    private Runnable selectorLoop = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Stores.setCurrent(NIOServer.this.server.getStore());
            try {
                block37: while (true) {
                    if (!NIOServer.this.running) {
                        try {
                            for (SelectionKey key : NIOServer.this.selector.keys()) {
                                key.channel().close();
                            }
                            NIOServer.this.selector.close();
                            NIOServer.this.selector = null;
                        }
                        catch (IOException e) {
                            log.error("IOException while closing NIO server");
                            e.printStackTrace();
                        }
                        finally {
                            NIOServer.this.selector = null;
                        }
                        if (NIOServer.this.ssc != null) {
                            try {
                                NIOServer.this.ssc.close();
                            }
                            catch (IOException e) {
                                log.error("IOException while closing NIO socket channel");
                                e.printStackTrace();
                            }
                            finally {
                                NIOServer.this.ssc = null;
                            }
                        }
                        log.info("Selector loop ended on port: " + NIOServer.this.getPort());
                        return;
                    }
                    NIOServer.this.selector.select(1000L);
                    Set<SelectionKey> keys = NIOServer.this.selector.selectedKeys();
                    Iterator it = keys.iterator();
                    while (true) {
                        if (!it.hasNext()) continue block37;
                        SelectionKey key = (SelectionKey)it.next();
                        it.remove();
                        try {
                            if (key.isAcceptable()) {
                                NIOServer.this.accept(NIOServer.this.selector);
                                continue;
                            }
                            if (key.isReadable()) {
                                NIOServer.this.selectRead(key);
                                continue;
                            }
                            if (!key.isWritable()) continue;
                            NIOServer.this.selectWrite(key);
                        }
                        catch (ClosedChannelException e) {
                            log.debug("Client closed channel");
                            key.cancel();
                        }
                        catch (IOException e) {
                            log.warn("Unexpected IOException, canceling key: {}", e);
                            key.cancel();
                        }
                        catch (CancelledKeyException e) {
                            log.warn("Cancelled key: {}", e);
                            key.cancel();
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error("Unexpected IOException, terminating selector loop: {}", e);
                e.printStackTrace();
                return;
            }
            finally {
                try {
                    for (SelectionKey key : NIOServer.this.selector.keys()) {
                        key.channel().close();
                    }
                    NIOServer.this.selector.close();
                    NIOServer.this.selector = null;
                }
                catch (IOException e) {
                    log.error("IOException while closing NIO server");
                    e.printStackTrace();
                }
                finally {
                    NIOServer.this.selector = null;
                }
                if (NIOServer.this.ssc != null) {
                    try {
                        NIOServer.this.ssc.close();
                    }
                    catch (IOException e) {
                        log.error("IOException while closing NIO socket channel");
                        e.printStackTrace();
                    }
                    finally {
                        NIOServer.this.ssc = null;
                    }
                }
                log.info("Selector loop ended on port: " + NIOServer.this.getPort());
            }
        }
    };

    private NIOServer(Server server, BlockingQueue<Message> receiveQueue) {
        this.server = server;
        this.receiveQueue = receiveQueue;
    }

    public static NIOServer create(Server server, BlockingQueue<Message> receiveQueue) {
        return new NIOServer(server, receiveQueue);
    }

    public void launch(Integer port) {
        this.launch(null, port);
    }

    public void launch(String bindAddress, Integer port) {
        if (port == null) {
            port = 0;
        }
        try {
            this.ssc = ServerSocketChannel.open();
            this.ssc.socket().setReceiveBufferSize(0x100000);
            bindAddress = bindAddress == null ? "localhost" : bindAddress;
            InetSocketAddress address = new InetSocketAddress(bindAddress, (int)port);
            this.ssc.bind(address);
            address = (InetSocketAddress)this.ssc.getLocalAddress();
            this.ssc.configureBlocking(false);
            port = this.ssc.socket().getLocalPort();
            this.selector = Selector.open();
            this.ssc.register(this.selector, 16);
            this.running = true;
            Thread selectorThread = new Thread(this.selectorLoop, "NIO Server selector loop on port: " + port);
            selectorThread.setDaemon(true);
            selectorThread.start();
            log.info("NIO server started on port {}", (Object)port);
        }
        catch (Exception e) {
            throw new Error("Can't bind NIOServer to port: " + port, e);
        }
    }

    public int getPort() {
        if (this.ssc == null) {
            return 0;
        }
        ServerSocket socket = this.ssc.socket();
        if (socket == null) {
            return 0;
        }
        return socket.getLocalPort();
    }

    protected void selectWrite(SelectionKey key) throws IOException {
        this.ensureConnection(key);
        Connection.selectWrite(key);
    }

    private Connection ensureConnection(SelectionKey key) throws IOException {
        Connection pc = (Connection)key.attachment();
        if (pc != null) {
            return pc;
        }
        SocketChannel sc = (SocketChannel)key.channel();
        assert (!sc.isBlocking());
        pc = this.createPC(sc, this.receiveQueue);
        key.attach(pc);
        return pc;
    }

    private Connection createPC(SocketChannel sc, BlockingQueue<Message> queue) throws IOException {
        return Connection.create(sc, this.server.getReceiveAction(), this.server.getStore(), null);
    }

    protected void selectRead(SelectionKey key) throws IOException {
        Connection conn = this.ensureConnection(key);
        if (conn == null) {
            throw new Error("No PeerConnection specified");
        }
        try {
            int n = conn.handleChannelRecieve();
            if (n == 0) {
                log.debug("No bytes received for key: {}", (Object)key);
            }
        }
        catch (SocketException | ClosedChannelException e) {
            log.debug("Channel closed from: {}", (Object)conn.getRemoteAddress());
            key.cancel();
        }
        catch (BadFormatException e) {
            log.warn("Cancelled connection: Bad data format from: {} message: {}", (Object)conn.getRemoteAddress(), (Object)e.getMessage());
            key.cancel();
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public void close() {
        this.running = false;
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    private void accept(Selector selector) throws IOException, ClosedChannelException {
        SocketChannel socketChannel = this.ssc.accept();
        if (socketChannel == null) {
            return;
        }
        log.debug("New connection accepted: {}", (Object)socketChannel);
        socketChannel.configureBlocking(false);
        socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        socketChannel.register(selector, 1);
    }

    public InetSocketAddress getHostAddress() {
        if (this.ssc == null) {
            return null;
        }
        ServerSocket socket = this.ssc.socket();
        if (socket == null) {
            return null;
        }
        return new InetSocketAddress(socket.getInetAddress(), socket.getLocalPort());
    }
}

