/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.api.Convex;
import convex.cli.Account;
import convex.cli.CLIError;
import convex.cli.Main;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.lang.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="balance", aliases={"bal"}, mixinStandardHelpOptions=true, description={"Get account balance."})
public class AccountBalance
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AccountBalance.class);
    @CommandLine.ParentCommand
    private Account accountParent;
    @CommandLine.Option(names={"--port"}, description={"Port number to connect to a peer."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname to connect to a peer. Default: ${DEFAULT-VALUE}"})
    private String hostname;
    @CommandLine.Parameters(paramLabel="address", description={"Address of the account to get the balance ."})
    private long addressNumber;
    @CommandLine.Option(names={"-t", "--timeout"}, description={"Timeout in miliseconds."})
    private long timeout = 5000L;

    @Override
    public void run() {
        Main mainParent = this.accountParent.mainParent;
        if (this.addressNumber == 0L) {
            log.warn("You need to provide a valid address number");
            return;
        }
        Convex convex = null;
        Address address = Address.create(this.addressNumber);
        convex = mainParent.connectToSessionPeer(this.hostname, this.port, address, null);
        String queryCommand = String.format("(balance #%d)", address.longValue());
        Object message = Reader.read(queryCommand);
        try {
            Result result = convex.querySync((ACell)message, this.timeout);
            mainParent.printResult(result);
        }
        catch (Exception e) {
            throw new CLIError("Error executing query", e);
        }
    }
}

