/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.password;

import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;
import javax.swing.text.View;
import mdlaf.components.textfield.MaterialComponentField;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialPasswordFieldUI
extends MaterialComponentField {
    protected static final String ProprietyPrefix = "PasswordField";
    protected BasicPasswordFieldUI basicPasswordFieldUI = new BasicPasswordFieldUI();

    public MaterialPasswordFieldUI() {
        this(true);
    }

    public MaterialPasswordFieldUI(boolean drawLine) {
        this.drawLine = drawLine;
    }

    public static ComponentUI createUI(JComponent c) {
        return new MaterialPasswordFieldUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return ProprietyPrefix;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.basicPasswordFieldUI.installUI(c);
        JPasswordField passwordField = (JPasswordField)c;
        passwordField.setEchoChar(((Character)UIManager.get("PasswordField.echoChar")).charValue());
        this.installMyDefaults(passwordField);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setCursor(Cursor.getDefaultCursor());
        this.basicPasswordFieldUI.uninstallUI(c);
        this.textComponent = null;
        super.uninstallUI(c);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.getComponent().setBorder(null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this.focusListenerColorLine);
        this.getComponent().addPropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListenerColorLine);
        this.getComponent().removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        super.uninstallListeners();
    }

    @Override
    protected void paintBackground(Graphics g) {
        super.paintBackground(MaterialDrawingUtils.getAliasedGraphics(g));
    }

    @Override
    public void paintSafely(Graphics g) {
        super.paintSafely(g);
        this.changeColorOnFocus(g);
        this.paintLine(g);
    }

    @Override
    public View create(Element elem) {
        return new MaterialPasswordView(elem);
    }

    protected class MaterialPasswordView
    extends PasswordView {
        private MaterialPasswordView(Element elem) {
            super(elem);
        }

        @Override
        protected int drawEchoCharacter(Graphics g, int x, int y, char c) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fm = g2.getFontMetrics();
            int r = fm.charWidth(c) - 2;
            g2.fillOval(x + 1, y + 5 - fm.getAscent(), r, r);
            g2.dispose();
            return x + fm.charWidth(c);
        }
    }
}

