/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.Key;
import convex.cli.Main;
import convex.core.crypto.AKeyPair;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="generate", aliases={"ge"}, mixinStandardHelpOptions=true, description={"Generate 1 or more private key pairs."})
public class KeyGenerate
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(KeyGenerate.class);
    @CommandLine.ParentCommand
    protected Key keyParent;
    @CommandLine.Parameters(paramLabel="count", defaultValue="1", description={"Number of keys to generate. Default: ${DEFAULT-VALUE}"})
    private int count;

    @Override
    public void run() {
        Main mainParent = this.keyParent.mainParent;
        if (this.count <= 0) {
            log.warn("You to provide 1 or more count of keys to generate");
            return;
        }
        log.info("Generating {} keys", (Object)this.count);
        try {
            List<AKeyPair> keyPairList = mainParent.generateKeyPairs(this.count);
            for (int index = 0; index < keyPairList.size(); ++index) {
                String publicKeyHexString = keyPairList.get(index).getAccountKey().toHexString();
                mainParent.output.setField("Index", String.format("%5d", index));
                mainParent.output.setField("Public Key", publicKeyHexString);
                mainParent.output.addRow();
            }
        }
        catch (Error e) {
            mainParent.showError(e);
        }
    }
}

