/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.exceptions.BadFormatException;
import convex.net.Connection;
import convex.net.MessageType;
import convex.net.message.Message;
import convex.net.message.MessageRemote;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReceiver {
    public static final int RECEIVE_BUFFER_SIZE = 81930;
    private ByteBuffer buffer = ByteBuffer.allocate(81930);
    private final Consumer<Message> action;
    private final Connection connection;
    private long receivedMessageCount = 0L;
    private static final Logger log = LoggerFactory.getLogger(MessageReceiver.class.getName());

    public MessageReceiver(Consumer<Message> receiveAction, Connection pc) {
        this.action = receiveAction;
        this.connection = pc;
    }

    public Consumer<Message> getAction() {
        return this.action;
    }

    public long getReceivedCount() {
        return this.receivedMessageCount;
    }

    public synchronized int receiveFromChannel(ReadableByteChannel chan) throws IOException, BadFormatException {
        int len;
        int numRead = 0;
        if (this.buffer.position() < 2) {
            this.buffer.limit(2);
            numRead = chan.read(this.buffer);
            if (numRead < 0) {
                chan.close();
                throw new ClosedChannelException();
            }
            if (this.buffer.position() < 2) {
                return numRead;
            }
        }
        int lengthLength = (len = Format.peekMessageLength(this.buffer)) < 64 ? 1 : 2;
        int totalFrameSize = lengthLength + len;
        this.buffer.limit(totalFrameSize);
        int n = chan.read(this.buffer);
        if (n < 0) {
            throw new ClosedChannelException();
        }
        numRead += n;
        if (this.buffer.hasRemaining()) {
            return numRead;
        }
        this.buffer.flip();
        this.buffer.position(lengthLength);
        byte mType = this.buffer.get();
        MessageType type = MessageType.decode(mType);
        byte[] bs = new byte[len - 1];
        this.buffer.get(bs);
        assert (!this.buffer.hasRemaining());
        Blob encoding = Blob.wrap(bs);
        this.receiveMessage(type, encoding);
        this.buffer.clear();
        return numRead;
    }

    private void receiveMessage(MessageType type, ABlob encoding) throws BadFormatException {
        ACell payload = this.connection.getStore().decode(encoding);
        MessageRemote message = Message.create(this.connection, type, payload);
        ++this.receivedMessageCount;
        if (this.action != null) {
            try {
                log.trace("Message received: {}", (Object)message.getType());
                this.action.accept(message);
            }
            catch (Throwable e) {
                log.warn("Exception not handled from: " + this.connection.getRemoteAddress());
                e.printStackTrace();
            }
        } else {
            log.warn("Ignored message because no receive action set: " + message);
        }
    }
}

