/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.Result;
import convex.core.lang.RT;
import convex.core.util.Utils;
import convex.gui.components.Toast;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReceiveAction
implements Consumer<Result> {
    public static final Logger log = LoggerFactory.getLogger(DefaultReceiveAction.class.getName());
    private JComponent parent;

    public DefaultReceiveAction(JComponent parent) {
        this.parent = parent;
    }

    @Override
    public void accept(Result t) {
        if (t.isError()) {
            this.handleError((Long)RT.jvm(t.getID()), t.getErrorCode(), t.getValue());
        } else {
            this.handleResult(t.getValue());
        }
    }

    protected void handleResult(Object m) {
        this.showResult(m);
    }

    protected void handleError(long id, Object code, Object msg) {
        this.showError(code, msg);
    }

    private void showError(Object code, Object msg) {
        String resultString = "Error executing transaction: " + code + " " + msg;
        log.info(resultString);
        Toast.display(this.parent, resultString, Toast.FAIL);
    }

    private void showResult(Object v) {
        String resultString = "Transaction executed successfully\nResult: " + Utils.toString(v);
        log.info(resultString);
        Toast.display(this.parent, resultString, Toast.SUCCESS);
    }
}

