/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AString;
import convex.core.data.Format;
import convex.core.data.StringShort;
import convex.core.data.StringTree;
import convex.core.exceptions.BadFormatException;
import java.nio.ByteBuffer;

public class Strings {
    public static final StringShort EMPTY = StringShort.create("");
    public static final StringShort NIL = StringShort.create("nil");
    public static final StringShort BAD_SIGNATURE = StringShort.create("Bad Signature!");

    public static AString read(ByteBuffer bb) throws BadFormatException {
        long length = Format.readVLCLong(bb);
        if (length == 0L) {
            return EMPTY;
        }
        if (length < 0L) {
            throw new BadFormatException("Negative string length!");
        }
        if (length > Integer.MAX_VALUE) {
            throw new BadFormatException("String length too long! " + length);
        }
        if (length <= 1024L) {
            return StringShort.read((int)length, bb);
        }
        return StringTree.read((int)length, bb);
    }

    public static AString create(String s) {
        int len = s.length();
        if (len == 0) {
            return EMPTY;
        }
        if (len <= 1024) {
            return StringShort.create(s);
        }
        return StringTree.create(s);
    }

    public static AString empty() {
        return EMPTY;
    }
}

