/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.client;

import convex.api.Convex;
import convex.cli.CLIError;
import convex.cli.client.AClientCommand;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.lang.Reader;
import convex.core.transactions.Invoke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="transact", mixinStandardHelpOptions=true, description={"Execute a user transaction on the Convex network."})
public class Transact
extends AClientCommand {
    protected static final Logger log = LoggerFactory.getLogger(Transact.class);
    @CommandLine.Parameters(paramLabel="transactionCommand", description={"Transaction Command"})
    private String transactionCode;

    @Override
    public void execute() throws InterruptedException {
        Address a = this.getUserAddress();
        if (a == null) {
            throw new CLIError(64, "You must specify a valid origin address for the transaction.");
        }
        Convex convex = this.connectTransact();
        Address address = convex.getAddress();
        log.trace("Executing transaction: '{}'\n", (Object)this.transactionCode);
        ACell message = Reader.read((String)this.transactionCode);
        Invoke transaction = Invoke.create((Address)address, (long)0L, (ACell)message);
        Result result = convex.transactSync((ACell)transaction);
        this.mainParent.printResult(result);
    }
}

