/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.ACommand;
import convex.cli.CLIError;
import convex.cli.ExitCodes;
import convex.cli.Helpers;
import convex.cli.account.Account;
import convex.cli.client.Query;
import convex.cli.client.Status;
import convex.cli.client.Transact;
import convex.cli.desktop.Desktop;
import convex.cli.etch.Etch;
import convex.cli.key.Key;
import convex.cli.local.Local;
import convex.cli.output.Coloured;
import convex.cli.peer.Peer;
import convex.core.util.FileUtils;
import convex.core.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import picocli.CommandLine;

@CommandLine.Command(name="convex", subcommands={Account.class, Key.class, Local.class, Peer.class, Query.class, Status.class, Desktop.class, Etch.class, Transact.class, CommandLine.HelpCommand.class}, usageHelpAutoWidth=true, sortOptions=true, mixinStandardHelpOptions=true, parameterListHeading="%nParameters:%n", optionListHeading="%nOptions:%n", commandListHeading="%nCommands:%n", versionProvider=VersionProvider.class, description={"Convex Command Line Interface"})
public class Main
extends ACommand {
    private static Logger log = LoggerFactory.getLogger(Main.class);
    public CommandLine commandLine = this.commandLine.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new ExceptionHandler());
    @CommandLine.Option(names={"-S", "--strict-security"}, defaultValue="false", scope=CommandLine.ScopeType.INHERIT, description={"Apply strict security. Will forbid actions with dubious security implications."})
    private boolean paranoid;
    @CommandLine.Option(names={"-n", "--noninteractive"}, scope=CommandLine.ScopeType.INHERIT, description={"Specify to disable interactive prompts. Useful for scripts."})
    boolean nonInteractive;
    @CommandLine.Option(names={"--no-color"}, scope=CommandLine.ScopeType.INHERIT, defaultValue="${env:NO_COLOR}", description={"Suppress ANSI colour output. Can also suppress with NO_COLOR environment variable."})
    private boolean noColour;
    @CommandLine.Option(names={"-v", "--verbose"}, scope=CommandLine.ScopeType.INHERIT, defaultValue="${env:CONVEX_VERBOSE_LEVEL:-2}", description={"Specify verbosity level. Use -v0 to suppress user output, -v5 for all log output. Default: ${DEFAULT-VALUE}"})
    private Integer verbose;

    @Override
    public void execute() {
        String art = Helpers.getConvexArt();
        if (this.isColoured()) {
            art = Coloured.blue(art);
        }
        this.inform(2, art);
        this.showUsage();
    }

    public static void main(String[] args) {
        Main mainApp = new Main();
        int result = mainApp.mainExecute(args);
        System.exit(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mainExecute(String[] args) {
        try {
            int result;
            try {
                this.commandLine.parseArgs(args);
            }
            catch (CommandLine.ParameterException t) {
                this.informError("ERROR: Unable to parse arguments: " + t.getMessage());
                this.informWarning("For more information on options and commands try 'convex help'.");
                int n = 1;
                this.commandLine.getOut().flush();
                this.commandLine.getErr().flush();
                return n;
            }
            if (this.commandLine.isUsageHelpRequested()) {
                this.showUsage();
                int t = 0;
                return t;
            }
            if (this.commandLine.isVersionHelpRequested()) {
                this.commandLine.printVersionHelp(this.commandLine.getOut());
                int t = 0;
                return t;
            }
            this.setupVerbosity();
            int n = result = this.commandLine.execute(args);
            return n;
        }
        finally {
            this.commandLine.getOut().flush();
            this.commandLine.getErr().flush();
        }
    }

    private void setupVerbosity() {
        Level[] verboseLevels = new Level[]{Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.TRACE};
        if (this.verbose == null) {
            this.verbose = 0;
        }
        if (this.verbose < 0 || this.verbose >= verboseLevels.length) {
            throw new CLIError(64, "Invalid verbosity level: " + this.verbose);
        }
    }

    @Override
    public boolean isParanoid() {
        return this.paranoid;
    }

    @Override
    public boolean isColoured() {
        return !this.noColour;
    }

    @Override
    public CommandLine commandLine() {
        return this.commandLine;
    }

    @Override
    public boolean isInteractive() {
        return !this.nonInteractive;
    }

    @Override
    protected int verbose() {
        if (this.verbose == null) {
            this.verbose = 2;
        }
        return this.verbose;
    }

    public void setOut(String outFile) {
        try {
            if (outFile == null || outFile.equals("-")) {
                log.debug("Setting output to STDOUT");
                this.commandLine.setOut(new PrintWriter(System.out));
            } else {
                File file = new File(outFile);
                file = FileUtils.ensureFilePath((File)file);
                log.debug("Setting output to " + String.valueOf(file));
                PrintWriter pw = new PrintWriter(file);
                this.commandLine.setOut(pw);
            }
        }
        catch (IOException e) {
            throw new CLIError("Unavble to open output file: " + outFile);
        }
    }

    @Override
    public Main cli() {
        return this;
    }

    private class ExceptionHandler
    implements CommandLine.IExecutionExceptionHandler {
        private ExceptionHandler() {
        }

        public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) throws Exception {
            PrintWriter err = commandLine.getErr();
            if (ex instanceof CLIError) {
                CLIError ce = (CLIError)ex;
                String msg = ce.getMessage();
                Main.this.informError(msg);
                Throwable cause = ce.getCause();
                if (Main.this.verbose >= 3 && cause != null) {
                    err.println("Underlying cause: ");
                    cause.printStackTrace(err);
                }
            } else if (ex.getClass().getSimpleName().equals("UserInterruptException")) {
                Main.this.informError("Operation cancelled by user");
                if (Main.this.verbose >= 3) {
                    ex.printStackTrace(err);
                }
            } else if (Main.this.verbose >= 1) {
                ex.printStackTrace(err);
            }
            return ExitCodes.getExitCode(ex);
        }
    }

    public static final class VersionProvider
    implements CommandLine.IVersionProvider {
        public String[] getVersion() throws Exception {
            String s = Utils.getVersion();
            return new String[]{"Convex version: " + s};
        }
    }
}

