/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.ASymbolic;
import convex.core.data.Format;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import java.nio.ByteBuffer;

public class Keyword
extends ASymbolic
implements Comparable<Keyword> {
    public static final int MAX_CHARS = 64;
    public static final int MIN_CHARS = 1;

    private Keyword(String name) {
        super(name);
    }

    @Override
    public AType getType() {
        return Types.KEYWORD;
    }

    public static Keyword create(String name) {
        if (!Keyword.validateName(name)) {
            return null;
        }
        return new Keyword(name);
    }

    public static Keyword create(AString name) {
        if (name == null) {
            return null;
        }
        return Keyword.create(name.toString());
    }

    public static Keyword createChecked(AString aString) {
        Keyword k = Keyword.create(aString);
        if (k == null) {
            throw new IllegalArgumentException("Invalid keyword name: " + aString);
        }
        return k;
    }

    public static Keyword createChecked(String aString) {
        Keyword k = Keyword.create(aString);
        if (k == null) {
            throw new IllegalArgumentException("Invalid keyword name: " + aString);
        }
        return k;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public static Keyword read(ByteBuffer bb) throws BadFormatException {
        String name = Format.readUTF8String(bb);
        Keyword kw = Keyword.create(name);
        if (kw == null) {
            throw new BadFormatException("Can't read symbol");
        }
        return kw;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 51;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return Format.writeRawUTF8String(bs, pos, this.name);
    }

    @Override
    public void print(StringBuilder sb) {
        sb.append(':');
        sb.append(this.name);
    }

    @Override
    public int estimatedEncodingSize() {
        return this.name.length() * 2 + 3;
    }

    @Override
    public boolean equals(ACell other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Keyword)) {
            return false;
        }
        return this.name.equals(((Keyword)other).name);
    }

    @Override
    public int compareTo(Keyword k) {
        return this.name.compareTo(k.name);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        super.validateCell();
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public byte getTag() {
        return 51;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }
}

