/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.AObject;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.IValidated;
import convex.core.data.IWriteable;
import convex.core.data.Ref;
import convex.core.data.RefDirect;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.TODOException;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.function.Consumer;

public abstract class ACell
extends AObject
implements IWriteable,
IValidated {
    public static final ACell[] EMPTY_ARRAY = new ACell[0];
    private long memorySize = -1L;
    protected Ref<ACell> cachedRef = null;

    @Override
    public void validate() throws InvalidDataException {
        this.validateCell();
    }

    public abstract void validateCell() throws InvalidDataException;

    public final Hash getHash() {
        return this.getEncoding().getContentHash();
    }

    public abstract byte getTag();

    protected final Hash cachedHash() {
        Hash h;
        if (this.cachedRef != null && (h = this.cachedRef.cachedHash()) != null) {
            return h;
        }
        if (this.encoding == null) {
            return null;
        }
        return this.encoding.contentHash;
    }

    public int hashCode() {
        return this.getHash().firstInt();
    }

    public final boolean equals(Object a) {
        if (!(a instanceof ACell)) {
            return false;
        }
        return this.equals((ACell)a);
    }

    @Override
    public final Blob getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.createEncoding();
        }
        return this.encoding;
    }

    public boolean equals(ACell a) {
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (a.getTag() != this.getTag()) {
            return false;
        }
        return this.getEncoding().equals(a.getEncoding());
    }

    @Override
    public final ByteBuffer write(ByteBuffer bb) {
        return this.getEncoding().writeToBuffer(bb);
    }

    @Override
    public abstract int encode(byte[] var1, int var2);

    public abstract int encodeRaw(byte[] var1, int var2);

    @Override
    public final Blob createEncoding() {
        int capacity = this.estimatedEncodingSize();
        byte[] bs = new byte[capacity];
        int pos = 0;
        boolean done = false;
        while (!done) {
            try {
                pos = this.encode(bs, pos);
                done = true;
            }
            catch (IndexOutOfBoundsException be) {
                capacity = capacity * 2 + 10;
                bs = new byte[capacity];
            }
        }
        return Blob.wrap(bs, 0, pos);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.print(sb);
        return sb.toString();
    }

    public ABlob cachedEncoding() {
        return this.encoding;
    }

    protected long calcMemorySize() {
        long result = 0L;
        int n = this.getRefCount();
        for (int i = 0; i < n; ++i) {
            Ref childRef = this.getRef(i);
            long childSize = childRef.getMemorySize();
            result += childSize;
        }
        if (!this.isEmbedded()) {
            result += this.getEncodingLength();
            result += 64L;
        }
        return result;
    }

    public long getEncodingLength() {
        return this.getEncoding().count();
    }

    public final long getMemorySize() {
        long ms = this.memorySize;
        if (ms >= 0L) {
            return ms;
        }
        this.memorySize = ms = this.calcMemorySize();
        return ms;
    }

    public boolean isEmbedded() {
        boolean embedded;
        if (this.cachedRef != null) {
            int flags = this.cachedRef.flags;
            if ((flags & 0x10) != 0) {
                return true;
            }
            if ((flags & 0x20) != 0) {
                return false;
            }
        }
        boolean bl = embedded = this.getEncodingLength() <= 140L;
        if (this.cachedRef != null) {
            this.cachedRef.flags = this.cachedRef.flags | (embedded ? 16 : 32);
        }
        return embedded;
    }

    public abstract boolean isCanonical();

    public abstract ACell toCanonical();

    public abstract boolean isCVMValue();

    public abstract int getRefCount();

    public final <R extends ACell> Ref<R> getRef() {
        if (this.cachedRef != null) {
            return this.cachedRef;
        }
        return this.createRef();
    }

    protected <R extends ACell> Ref<R> createRef() {
        RefDirect<ACell> newRef = RefDirect.create(this, this.cachedHash());
        this.cachedRef = newRef;
        return newRef;
    }

    public <R extends ACell> Ref<R> getRef(int i) {
        if (this.getRefCount() == 0) {
            throw new IndexOutOfBoundsException("No Refs to get in " + Utils.getClassName(this));
        }
        throw new TODOException(Utils.getClassName(this) + " does not yet implement getRef(i) for i = " + i);
    }

    public ACell updateRefs(IRefFunction func) {
        if (this.getRefCount() == 0) {
            return this;
        }
        throw new TODOException(Utils.getClassName(this) + " does not yet implement updateRefs(...)");
    }

    public <R extends ACell> Ref<R>[] getChildRefs() {
        int n = this.getRefCount();
        Ref[] refs = new Ref[n];
        for (int i = 0; i < n; ++i) {
            refs[i] = this.getRef(i);
        }
        return refs;
    }

    public AType getType() {
        return Types.ANY;
    }

    public void attachMemorySize(long memorySize) {
        if (this.memorySize < 0L) {
            this.memorySize = memorySize;
            assert (this.memorySize > 0L) : "Attempting to attach memory size " + memorySize + " to object of class " + Utils.getClassName(this);
        } else assert (this.memorySize == memorySize) : "Attempting to attach memory size " + memorySize + " to object of class " + Utils.getClassName(this) + " which already has memorySize " + this.memorySize;
    }

    public void attachRef(Ref<?> ref) {
        this.cachedRef = ref;
    }

    public static <T extends ACell> T createAnnounced(T value, Consumer<Ref<ACell>> noveltyHandler) {
        if (value == null) {
            return null;
        }
        return value.announce(noveltyHandler);
    }

    public <T extends ACell> T announce() {
        return this.announce(null);
    }

    public <T extends ACell> T announce(Consumer<Ref<ACell>> noveltyHandler) {
        Ref ref = this.getRef();
        AStore store = Stores.current();
        ref = store.storeTopRef(ref, 4, noveltyHandler);
        this.cachedRef = ref;
        return (T)this;
    }

    public static <T extends ACell> Ref<T> createPersisted(T value, Consumer<Ref<ACell>> noveltyHandler) {
        Ref<T> ref = Ref.get(value);
        if (ref.isPersisted()) {
            return ref;
        }
        AStore store = Stores.current();
        ref = store.storeTopRef(ref, 2, noveltyHandler);
        value.cachedRef = ref;
        return ref;
    }

    public static <T extends ACell> Ref<T> createPersisted(T value) {
        return ACell.createPersisted(value, null);
    }
}

