/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.Key;
import convex.cli.Main;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.Ed25519KeyPair;
import convex.core.crypto.PEMTools;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="import", aliases={"im"}, mixinStandardHelpOptions=true, description={"Import key pairs to the keystore."})
public class KeyImport
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(KeyImport.class);
    @CommandLine.ParentCommand
    protected Key keyParent;
    @CommandLine.Option(names={"-i", "--import-text"}, description={"Import format PEM text of the keypair."})
    private String importText;
    @CommandLine.Option(names={"-f", "--import-file"}, description={"Import file name of the keypair PEM file."})
    private String importFilename;
    @CommandLine.Option(names={"--import-password"}, description={"Password of the imported key."})
    private String importPassword;

    @Override
    public void run() {
        Main mainParent = this.keyParent.mainParent;
        if (this.importFilename != null && this.importFilename.length() > 0) {
            try {
                this.importText = Files.readString(Paths.get(this.importFilename, new String[0]), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                mainParent.showError(e);
                return;
            }
        }
        if (this.importText == null || this.importText.length() == 0) {
            log.warn("You need to provide an import text '--import' or import filename '--import-file' to import a private key");
            return;
        }
        if (this.importPassword == null || this.importPassword.length() == 0) {
            log.warn("You need to provide an import password '--import-password' of the imported encrypted PEM data");
        }
        try {
            PrivateKey privateKey = PEMTools.decryptPrivateKeyFromPEM(this.importText, this.importPassword.toCharArray());
            Ed25519KeyPair keyPair = Ed25519KeyPair.create(privateKey);
            mainParent.addKeyPairToStore(keyPair);
            mainParent.output.setField("public key", ((AKeyPair)keyPair).getAccountKey().toHexString());
        }
        catch (Error e) {
            mainParent.showError(e);
        }
    }
}

