/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.Blob;
import convex.core.data.BlobTree;
import convex.core.data.Format;
import convex.core.exceptions.BadFormatException;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.Random;

public class Blobs {
    static final int CHUNK_SHIFT = 12;
    public static final int MAX_ENCODING_LENGTH = Math.max(Blob.MAX_ENCODING_LENGTH, BlobTree.MAX_ENCODING_LENGTH);

    public static <T extends ABlob> T createRandom(long length) {
        return Blobs.createRandom(new Random(), length);
    }

    public static <T extends ABlob> T createRandom(Random r, long length) {
        if (length <= 4096L) {
            return (T)Blob.createRandom(r, length);
        }
        int numChunks = Utils.checkedInt((length - 1L >> 12) + 1L);
        Blob[] blobs = new Blob[numChunks];
        for (int i = 0; i < numChunks; ++i) {
            Blob b;
            blobs[i] = b = Blob.createRandom(r, Math.min(4096L, length - (long)(i * 4096)));
        }
        return (T)BlobTree.create(blobs);
    }

    public static ABlob toCanonical(ABlob a) {
        long length = a.count();
        if (length <= 4096L) {
            return a.toBlob();
        }
        return BlobTree.create(a);
    }

    public static ABlob fromHex(String a) {
        long slength = a.length();
        if ((slength & 1L) != 0L) {
            return null;
        }
        Blob fullBlob = Blob.fromHex(a);
        long length = slength / 2L;
        if (length <= 4096L) {
            return fullBlob;
        }
        return BlobTree.create((ABlob)fullBlob);
    }

    public static ABlob read(ByteBuffer bb) throws BadFormatException {
        long len = Format.readVLCLong(bb);
        if (len < 0L) {
            throw new BadFormatException("Negative blob length?");
        }
        if (len > 4096L) {
            return BlobTree.read(bb, len);
        }
        byte[] buff = new byte[Utils.checkedInt(len)];
        bb.get(buff);
        return Blob.wrap(buff);
    }

    public static <T extends ABlob> T readFromBlob(Blob source) throws BadFormatException {
        int sLen = source.length;
        if (sLen < 2) {
            throw new BadFormatException("Trying to read Blob from insufficient source of size " + sLen);
        }
        long len = Format.readVLCLong(source.store, source.offset + 1);
        ABlob result = null;
        if (len < 0L) {
            throw new BadFormatException("Negative blob length?");
        }
        result = len > 4096L ? BlobTree.read(source, len) : Blob.read(source, len);
        result.attachEncoding(source);
        return (T)result;
    }
}

