/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.RecordFormat;
import convex.core.util.Utils;

public abstract class ARecordGeneric
extends ARecord {
    protected AVector<ACell> values;

    protected ARecordGeneric(RecordFormat format, AVector<ACell> values) {
        super(format);
        if (values.count() != format.count()) {
            throw new IllegalArgumentException("Wrong number of field values for record: " + values.count());
        }
        this.values = values;
    }

    @Override
    public MapEntry<Keyword, ACell> entryAt(long i) {
        return MapEntry.create(this.format.getKey(Utils.checkedInt(i)), this.values.get(i));
    }

    @Override
    public ACell get(ACell key) {
        Long ix = this.format.indexFor(key);
        if (ix == null) {
            return null;
        }
        return this.values.get(ix);
    }

    @Override
    public abstract byte getTag();

    @Override
    public int getRefCount() {
        return this.values.getRefCount();
    }

    @Override
    public boolean equals(AMap<Keyword, ACell> a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (a.getTag() != this.getTag()) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Utils.equals(h, ha);
        }
        return this.values.equals(((ARecordGeneric)a).values);
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int index) {
        return this.values.getRef(index);
    }

    @Override
    public ARecord updateRefs(IRefFunction func) {
        ACell newValues = this.values.updateRefs(func);
        return this.withValues((AVector<ACell>)newValues);
    }

    @Override
    protected ARecord updateAll(ACell[] newVals) {
        int n = this.size();
        if (newVals.length != n) {
            throw new IllegalArgumentException("Wrong number of values: " + newVals.length);
        }
        boolean changed = false;
        for (int i = 0; i < n; ++i) {
            if (this.values.get(i) == newVals[i]) continue;
            changed = true;
            break;
        }
        if (!changed) {
            return this;
        }
        AVector<ACell> newVector = Vectors.create(newVals);
        return this.withValues(newVector);
    }

    @Override
    public AVector<ACell> values() {
        return this.values;
    }

    protected abstract ARecord withValues(AVector<ACell> var1);

    @Override
    public void validateCell() throws InvalidDataException {
        this.values.validateCell();
    }
}

