/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.output;

import convex.cli.output.OutputField;
import convex.core.Result;
import convex.core.data.ACell;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Output {
    protected List<OutputField> fieldList = new ArrayList<OutputField>();
    protected List<List<OutputField>> rowList = new ArrayList<List<OutputField>>();

    public OutputField setField(String name, long value) {
        return this.setField(name, String.valueOf(value));
    }

    public OutputField setField(String name, ACell value) {
        return this.setField(name, value.toString());
    }

    public OutputField setField(String name, String value) {
        OutputField field = OutputField.create(name, value);
        this.fieldList.add(field);
        return field;
    }

    public void setResult(Result result) {
        ACell value = result.getValue();
        this.setField("Result", value);
        if (result.isError()) {
            this.setField("Error code", result.getErrorCode());
            if (result.getTrace() != null) {
                this.setField("Trace", (ACell)result.getTrace());
            }
            return;
        }
        this.setField("Data type", value.getType().toString());
    }

    public void addRow() {
        this.rowList.add(this.fieldList);
        this.fieldList = new ArrayList<OutputField>();
    }

    public void writeToStream(PrintWriter out) {
        if (this.rowList.size() > 0) {
            List<OutputField> firstRow = this.rowList.get(0);
            out.println(firstRow.stream().map(OutputField::getDescription).collect(Collectors.joining(" ")));
            for (List<OutputField> fieldList : this.rowList) {
                out.println(fieldList.stream().map(OutputField::getValue).collect(Collectors.joining(" ")));
            }
        } else {
            for (OutputField field : this.fieldList) {
                out.println(String.format("%s: %s", field.getDescription(), field.getValue()));
            }
        }
    }
}

