/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.api.Convex;
import convex.cli.Helpers;
import convex.cli.Main;
import convex.cli.peer.SessionItem;
import convex.core.Result;
import convex.core.State;
import convex.core.data.ABlob;
import convex.core.data.AVector;
import convex.core.data.BlobMap;
import convex.core.data.Hash;
import convex.core.store.Stores;
import convex.core.util.Text;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="status", aliases={"st"}, mixinStandardHelpOptions=true, description={"Reports on the current status of the network."})
public class Status
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Status.class);
    @CommandLine.ParentCommand
    protected Main mainParent;
    @CommandLine.Option(names={"--port"}, description={"Port number to connect or create a peer."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname to connect to a peer. Default: ${DEFAULT-VALUE}"})
    private String hostname;
    @CommandLine.Option(names={"-t", "--timeout"}, description={"Timeout in miliseconds."})
    private long timeout = 5000L;

    @Override
    public void run() {
        if (this.port == 0) {
            try {
                SessionItem item = Helpers.getSessionItem(this.mainParent.getSessionFilename());
                this.port = item.getPort();
            }
            catch (IOException e) {
                log.warn("Cannot load the session control file");
            }
        }
        if (this.port == 0) {
            log.warn("Cannot find a local port or you have not set a valid port number");
            return;
        }
        Convex convex = null;
        try {
            convex = this.mainParent.connectAsPeer(0);
        }
        catch (Throwable t) {
            this.mainParent.showError(t);
            return;
        }
        try {
            Result result = (Result)convex.requestStatus().get(this.timeout, TimeUnit.MILLISECONDS);
            AVector resultVector = (AVector)result.getValue();
            ABlob stateHash = (ABlob)resultVector.get(1);
            Hash hash = Hash.wrap((byte[])stateHash.getBytes());
            AVector stateWrapper = (AVector)convex.acquire(hash, Stores.current()).get(3000L, TimeUnit.MILLISECONDS);
            State state = (State)stateWrapper.get(0);
            state.validate();
            AVector accountList = state.getAccounts();
            BlobMap peerList = state.getPeers();
            this.mainParent.output.setField("State hash", stateHash.toString());
            this.mainParent.output.setField("Timestamp", state.getTimeStamp().toString());
            this.mainParent.output.setField("Timestamp value", Text.dateFormat((long)state.getTimeStamp().longValue()));
            this.mainParent.output.setField("Global Fees", Text.toFriendlyBalance((long)state.getGlobalFees().longValue()));
            this.mainParent.output.setField("Juice Price", Text.toFriendlyBalance((long)state.getJuicePrice().longValue()));
            this.mainParent.output.setField("Total Funds", Text.toFriendlyBalance((long)state.computeTotalFunds()));
            this.mainParent.output.setField("Number of accounts", accountList.size());
            this.mainParent.output.setField("Number of peers", peerList.size());
        }
        catch (Throwable t) {
            this.mainParent.showError(t);
        }
    }
}

