/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.api.Convex;
import convex.cli.Main;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.lang.Reader;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="query", aliases={"qu"}, mixinStandardHelpOptions=true, description={"Execute a query on the current peer."})
public class Query
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    @CommandLine.ParentCommand
    protected Main mainParent;
    @CommandLine.Option(names={"--port"}, description={"Port number to connect to a peer."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname to connect to a peer. Default: ${DEFAULT-VALUE}"})
    private String hostname;
    @CommandLine.Option(names={"-t", "--timeout"}, description={"Timeout in miliseconds."})
    private long timeout = 5000L;
    @CommandLine.Option(names={"-a", "--address"}, description={"Address to make the query from. Default: First peer address."})
    private long address = 11L;
    @CommandLine.Parameters(paramLabel="queryCommand", description={"Query Command"})
    private String queryCommand;

    @Override
    public void run() {
        log.info("query command: {}", (Object)this.queryCommand);
        Convex convex = null;
        try {
            convex = this.mainParent.connectToSessionPeer(this.hostname, this.port, Address.create((long)this.address), null);
        }
        catch (Error e) {
            this.mainParent.showError(e);
            return;
        }
        try {
            log.info("Executing query: %s\n", (Object)this.queryCommand);
            ACell message = Reader.read((String)this.queryCommand);
            Result result = convex.querySync(message, this.timeout);
            this.mainParent.output.setResult(result);
        }
        catch (IOException | TimeoutException e) {
            this.mainParent.showError(e);
        }
    }
}

