/*
 * Decompiled with CFR 0.152.
 */
package com.github.robust.client;

import android.content.Context;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import com.github.robust.client.AppMetaData;
import com.github.robust.client.PatchInfo;
import com.github.robust.client.RobustSdkManager;
import com.github.robust.client.utils.DigestUtil;
import com.github.robust.client.utils.FileUtil;
import com.github.robust.client.utils.NetUtil;
import com.github.robust.client.utils.SignUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.meituan.robust.Patch;
import com.meituan.robust.PatchManipulate;
import com.meituan.robust.RobustApkHashUtils;
import com.meituan.robust.RobustCallBack;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class RobustManipulateSimpleImpl
extends PatchManipulate {
    private static final String TAG = "robust-Manipulate";
    private final AppMetaData appMetaData;
    private final RobustCallBack robustCallBack;
    private final String patchesInfoImplClassFullName;

    public RobustManipulateSimpleImpl(AppMetaData appMetaData, RobustCallBack robustCallBack, String fullName) {
        this.appMetaData = appMetaData;
        this.robustCallBack = robustCallBack;
        this.patchesInfoImplClassFullName = fullName;
    }

    protected List<Patch> fetchPatchList(Context context) {
        if (this.appMetaData == null) {
            return new ArrayList<Patch>();
        }
        if (this.appMetaData.getPrivateKey() == null || this.appMetaData.getPublicKey() == null) {
            return new ArrayList<Patch>();
        }
        String apkHash = RobustApkHashUtils.readRobustApkHash((Context)context);
        if (apkHash == null || apkHash.isEmpty()) {
            Log.e((String)TAG, (String)"\u65e0\u6cd5\u83b7\u53d6APK-HASH\uff0c\u53ef\u80fd\u662fRobust\u96c6\u6210\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5");
            return new ArrayList<Patch>();
        }
        Patch patch = null;
        Log.i((String)TAG, (String)("\u83b7\u53d6\u5230APK-HASH:" + apkHash));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(8);
        map.put("apkHash", apkHash);
        map.put("appId", this.appMetaData.getAppId());
        map.put("publicKey", Base64.encodeToString((byte[])this.appMetaData.getPublicKey().getEncoded(), (int)2));
        map.put("tx", System.currentTimeMillis());
        map.put("sign", SignUtil.getSign(this.appMetaData.getAccessKey(), map));
        Gson gson = new Gson();
        String doPost = null;
        int count = 0;
        Exception exception = null;
        do {
            ++count;
            try {
                doPost = NetUtil.doPost(this.appMetaData.getUrl(), gson.toJson(map));
            }
            catch (Exception e) {
                exception = e;
                try {
                    Thread.sleep(100 * count);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        } while (doPost == null && count < 2);
        if (doPost == null) {
            if (this.robustCallBack != null) {
                this.robustCallBack.exceptionNotify((Throwable)exception, "RobustManipulateSimpleImpl#fetchPatchList\uff0c\u83b7\u53d6\u8865\u4e01\u4fe1\u606f\u5931\u8d25,url:" + this.appMetaData.getUrl());
            }
            Log.e((String)TAG, (String)("\u65e0\u6cd5\u83b7\u53d6\u8865\u4e01\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bf7\u6c42\uff1a" + this.appMetaData.getUrl()), (Throwable)exception);
            return new ArrayList<Patch>();
        }
        try {
            Log.i((String)TAG, (String)("\u83b7\u53d6\u5230\u7684\u6570\u636e\u4e3a\uff1a" + doPost));
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = jsonParser.parse(doPost).getAsJsonObject();
            if (jsonObject.get("code").getAsInt() != 200) {
                Log.e((String)TAG, (String)("\u65e0\u6cd5\u89e3\u6790\u6570\u636e\uff1a" + doPost));
                return new ArrayList<Patch>();
            }
            JsonObject dataJson = jsonObject.get("data").getAsJsonObject();
            PatchInfo data = (PatchInfo)gson.fromJson(dataJson.toString(), PatchInfo.class);
            patch = new Patch();
            patch.setAppHash(apkHash);
            patch.setMd5(data.getMd5());
            patch.setName(data.getPatchId());
            patch.setUrl(data.getDownloadUrl());
            String path = Environment.getExternalStorageDirectory().getPath();
            patch.setPatchesInfoImplClassFullName(this.patchesInfoImplClassFullName);
            patch.setLocalPath(path + File.separator + "robust" + File.separator + "store" + File.separator + "patch");
            patch.setTempPath(path + File.separator + "robust" + File.separator + "tmp" + File.separator + "patch");
            RobustSdkManager.setPatchInfo(data);
        }
        catch (Exception e) {
            if (this.robustCallBack != null) {
                this.robustCallBack.exceptionNotify((Throwable)e, "fetchPatchList,\u89e3\u6790\u670d\u52a1\u5668\u6570\u636e\u5931\u8d25");
            }
            e.printStackTrace();
        }
        return patch == null ? new ArrayList() : Collections.singletonList(patch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifyPatch(Context context, Patch patch) {
        Log.i((String)TAG, (String)"\u5f00\u59cb\u5904\u7406\u6e90\u6587\u4ef6");
        PatchInfo pathInfo = RobustSdkManager.getPatchInfo();
        if (pathInfo == null) {
            return false;
        }
        File file = new File(patch.getLocalPath());
        if (file.exists() && file.isFile()) {
            Log.i((String)TAG, (String)"\u6e90\u6587\u4ef6\u5b58\u5728\uff0c\u5f00\u59cb\u89e3\u5bc6\u6e90\u6587\u4ef6");
            ByteArrayOutputStream byteArrayOutputStream = null;
            FileOutputStream fileOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                int len;
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] buff = new byte[4096];
                fileOutputStream = new FileOutputStream(new File(patch.getTempPath()));
                fileInputStream = new FileInputStream(file);
                byteArrayOutputStream = new ByteArrayOutputStream();
                while ((len = fileInputStream.read(buff)) > 0) {
                    byteArrayOutputStream.write(buff, 0, len);
                }
                byte[] bytes = byteArrayOutputStream.toByteArray();
                String secret = DigestUtil.rsaDecode(pathInfo.getSecret(), Base64.encodeToString((byte[])RobustSdkManager.getInstance().getAppMetaData().getPrivateKey().getEncoded(), (int)2));
                byte[] dec = DigestUtil.decode(bytes, pathInfo.getNorIV(), secret);
                if (Arrays.equals(new byte[0], dec)) {
                    throw new IllegalStateException("\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bc6\u94a5");
                }
                fileOutputStream.write(dec, 0, dec.length);
                digest.update(dec, 0, dec.length);
                String fileMd5 = Base64.encodeToString((byte[])digest.digest(), (int)2);
                boolean bl = fileMd5.equals(patch.getMd5());
                return bl;
            }
            catch (Exception e) {
                if (this.robustCallBack != null) {
                    this.robustCallBack.exceptionNotify((Throwable)e, "\u89e3\u5bc6\u9a8c\u8bc1\u8865\u4e01\u5305\u5931\u8d25");
                }
                try {
                    FileUtil.deleteFile(patch.getLocalPath());
                    FileUtil.deleteFile(patch.getTempPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    protected boolean ensurePatchExist(Patch patch) {
        boolean localPathCreated = FileUtil.createDir(patch.getLocalPath());
        if (!localPathCreated) {
            return false;
        }
        boolean tmpdirCreated = FileUtil.createDir(patch.getTempPath());
        if (!tmpdirCreated) {
            return false;
        }
        File file = new File(patch.getLocalPath());
        if (!file.exists()) {
            boolean download;
            int count = 0;
            String privateKey = Base64.encodeToString((byte[])RobustSdkManager.getInstance().getAppMetaData().getPrivateKey().getEncoded(), (int)2);
            String url = DigestUtil.rsaDecode(patch.getUrl(), privateKey);
            do {
                ++count;
                download = NetUtil.download(url, patch.getLocalPath(), this.robustCallBack);
                if (download) continue;
                try {
                    Thread.sleep(100 * count);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (!download && count < 3);
            if (!download) {
                try {
                    FileUtil.deleteFile(patch.getLocalPath());
                    FileUtil.deleteFile(patch.getTempPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return download;
        }
        return true;
    }
}

