/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;
import wf.bitcoin.javabitcoindrpcclient.GenericRpcException;

public class BitcoinRawTxBuilder {
    public final BitcoindRpcClient bitcoin;
    public Set<BitcoindRpcClient.TxInput> inputs = new LinkedHashSet<BitcoindRpcClient.TxInput>();
    public List<BitcoindRpcClient.TxOutput> outputs = new ArrayList<BitcoindRpcClient.TxOutput>();
    public List<String> privateKeys;
    private HashMap<String, BitcoindRpcClient.RawTransaction> txCache = new HashMap();

    public BitcoinRawTxBuilder(BitcoindRpcClient bitcoin) {
        this.bitcoin = bitcoin;
    }

    public BitcoinRawTxBuilder in(BitcoindRpcClient.TxInput in) {
        this.inputs.add(new Input(in.txid(), in.vout()));
        return this;
    }

    public BitcoinRawTxBuilder in(String txid, int vout) {
        this.in(new BitcoindRpcClient.BasicTxInput(txid, vout));
        return this;
    }

    public BitcoinRawTxBuilder out(String address, BigDecimal amount) {
        return this.out(address, amount, null);
    }

    public BitcoinRawTxBuilder out(String address, BigDecimal amount, byte[] data) {
        this.outputs.add(new BitcoindRpcClient.BasicTxOutput(address, amount, data));
        return this;
    }

    public BitcoinRawTxBuilder in(BigDecimal value) throws GenericRpcException {
        return this.in(value, 6);
    }

    public BitcoinRawTxBuilder in(BigDecimal value, int minConf) throws GenericRpcException {
        List<BitcoindRpcClient.Unspent> unspent = this.bitcoin.listUnspent(minConf);
        BigDecimal v = value;
        for (BitcoindRpcClient.Unspent o : unspent) {
            if (!this.inputs.contains(new Input(o))) {
                this.in(o);
                v = v.subtract(o.amount());
            }
            if (v.compareTo(BigDecimal.ZERO) >= 0) continue;
            break;
        }
        if (BigDecimal.ZERO.compareTo(v) < 0) {
            throw new GenericRpcException("Not enough bitcoins (" + v + "/" + value + ")");
        }
        return this;
    }

    private BitcoindRpcClient.RawTransaction tx(String txId) throws GenericRpcException {
        BitcoindRpcClient.RawTransaction tx = this.txCache.get(txId);
        if (tx != null) {
            return tx;
        }
        tx = this.bitcoin.getRawTransaction(txId);
        this.txCache.put(txId, tx);
        return tx;
    }

    public BitcoinRawTxBuilder outChange(String address) throws GenericRpcException {
        return this.outChange(address, BigDecimal.ZERO);
    }

    public BitcoinRawTxBuilder outChange(String address, BigDecimal fee) throws GenericRpcException {
        BigDecimal is = BigDecimal.ZERO;
        for (BitcoindRpcClient.TxInput i : this.inputs) {
            is = is.add(this.tx(i.txid()).vOut().get(i.vout()).value());
        }
        BigDecimal os = fee;
        for (BitcoindRpcClient.TxOutput o : this.outputs) {
            os = os.add(o.amount());
        }
        if (os.compareTo(is) < 0) {
            this.out(address, is.subtract(os));
        }
        return this;
    }

    public BitcoinRawTxBuilder addPrivateKey(String privateKey) {
        if (this.privateKeys == null) {
            this.privateKeys = new ArrayList<String>();
        }
        this.privateKeys.add(privateKey);
        return this;
    }

    public String create() throws GenericRpcException {
        return this.bitcoin.createRawTransaction(new ArrayList<BitcoindRpcClient.TxInput>(this.inputs), this.outputs);
    }

    @Deprecated
    public String sign() throws GenericRpcException {
        return this.bitcoin.signRawTransaction(this.create(), null, this.privateKeys);
    }

    @Deprecated
    public String send() throws GenericRpcException {
        return this.bitcoin.sendRawTransaction(this.sign());
    }

    private class Input
    extends BitcoindRpcClient.BasicTxInput {
        public Input(String txid, Integer vout) {
            super(txid, vout);
        }

        public Input(BitcoindRpcClient.TxInput copy) {
            this(copy.txid(), copy.vout());
        }

        public int hashCode() {
            return this.txid.hashCode() + this.vout;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BitcoindRpcClient.TxInput)) {
                return false;
            }
            BitcoindRpcClient.TxInput other = (BitcoindRpcClient.TxInput)obj;
            return this.vout == other.vout() && this.txid.equals(other.txid());
        }
    }
}

