/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient.examples;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import wf.bitcoin.javabitcoindrpcclient.BitcoinJSONRPCClient;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRawTxBuilder;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;
import wf.bitcoin.javabitcoindrpcclient.util.Chain;
import wf.bitcoin.javabitcoindrpcclient.util.Util;

public class RawTransactionsExample {
    static final Logger LOGGER = Logger.getLogger(RawTransactionsExample.class.getName());

    public static void main(String[] args) throws Exception {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] [%4$-7s] %5$s %n");
        BitcoinJSONRPCClient client = new BitcoinJSONRPCClient();
        Util.ensureRunningOnChain(Chain.REGTEST, client);
        RawTransactionsExample.signRawTransactionWithKeyTest_P2SH_MultiSig(client);
        RawTransactionsExample.signRawTransactionWithKeyTest_P2SH_P2WPKH(client);
    }

    static void signRawTransactionWithKeyTest_P2SH_MultiSig(BitcoindRpcClient client) {
        LOGGER.info("=== Testing scenario: signRawTransactionWithKey ( P2SH-multiSigAddr(2-of-2, [addr1, addr2]) -> addr4 )");
        LOGGER.info("Preparing tx1 (addr3 -> multisig)");
        String addr1 = client.getNewAddress();
        LOGGER.info("Created address addr1: " + addr1);
        String addr2 = client.getNewAddress();
        LOGGER.info("Created address addr2: " + addr2);
        BitcoindRpcClient.MultiSig p2shMultiSig = client.addMultiSigAddress(2, Arrays.asList(addr1, addr2));
        String p2shMultiSigAddr = p2shMultiSig.address();
        LOGGER.info("Created and added to wallet the P2SH-multiSigAddr(2-of-2, [addr1, addr2]) : " + p2shMultiSigAddr);
        String addr3 = client.getNewAddress();
        LOGGER.info("Created address addr3: " + addr3);
        List<String> generatedBlocksHashes = client.generateToAddress(110, addr3);
        LOGGER.info("Generated " + generatedBlocksHashes.size() + " blocks for addr3");
        List<BitcoindRpcClient.Unspent> availableUtxosForTx1 = client.listUnspent(0, Integer.MAX_VALUE, addr3);
        LOGGER.info("Found " + availableUtxosForTx1.size() + " UTXOs (unspent transaction outputs) belonging to addr3");
        BitcoindRpcClient.TxInput selectedUtxoForTx1 = availableUtxosForTx1.get(0);
        LOGGER.info("Selected UTXO which will be used in tx1 (addr3 -> P2SH-multiSigAddr) : " + selectedUtxoForTx1);
        String tx1ID = client.sendToAddress(p2shMultiSigAddr, selectedUtxoForTx1.amount());
        LOGGER.info("UTXO sent to P2SH-multiSigAddr, tx1 ID: " + tx1ID);
        LOGGER.info("Preparing tx2 (multisig -> addr4)");
        String addr4 = client.getNewAddress();
        LOGGER.info("Created address addr4: " + addr4);
        List<BitcoindRpcClient.Unspent> availableUtxosForTx2 = client.listUnspent(0, 999, p2shMultiSigAddr);
        LOGGER.info("Found " + availableUtxosForTx2.size() + " UTXOs (unspent transaction outputs) belonging to P2SH-multiSigAddr");
        BitcoindRpcClient.Unspent selectedUtxoForTx2 = availableUtxosForTx2.get(0);
        LOGGER.info("Selected UTXO which will be used in tx2 (P2SH-multiSigAddr -> addr4) : " + selectedUtxoForTx2);
        BitcoindRpcClient.ExtendedTxInput inputP2SH = new BitcoindRpcClient.ExtendedTxInput(selectedUtxoForTx2.txid(), selectedUtxoForTx2.vout(), selectedUtxoForTx2.scriptPubKey(), selectedUtxoForTx2.amount(), selectedUtxoForTx2.redeemScript(), selectedUtxoForTx2.witnessScript());
        LOGGER.info("inputP2SH txid: " + inputP2SH.txid());
        LOGGER.info("inputP2SH vout: " + inputP2SH.vout());
        LOGGER.info("inputP2SH scriptPubKey: " + inputP2SH.scriptPubKey());
        LOGGER.info("inputP2SH amount: " + inputP2SH.amount());
        BitcoinRawTxBuilder rawTxBuilder = new BitcoinRawTxBuilder(client);
        rawTxBuilder.in(inputP2SH);
        BigDecimal estimatedFee = BigDecimal.valueOf(2.0E-6);
        BigDecimal txToAddr4Amount = selectedUtxoForTx2.amount().subtract(estimatedFee);
        rawTxBuilder.out(addr4, txToAddr4Amount);
        String unsignedRawMultiSigToAddr4TxHex = rawTxBuilder.create();
        LOGGER.info("Created unsignedRawTx from P2SH-multiSigAddr(2-of-2, [addr1, addr2]) to addr4: " + unsignedRawMultiSigToAddr4TxHex);
        BitcoindRpcClient.SignedRawTransaction srTx = client.signRawTransactionWithKey(unsignedRawMultiSigToAddr4TxHex, Arrays.asList(client.dumpPrivKey(addr1), client.dumpPrivKey(addr2)), Arrays.asList(inputP2SH), null);
        LOGGER.info("signedRawTx hex: " + srTx.hex());
        LOGGER.info("signedRawTx complete: " + srTx.complete());
        List<BitcoindRpcClient.RawTransactionSigningOrVerificationError> errors = srTx.errors();
        if (errors != null) {
            LOGGER.severe("Found errors when signing");
            for (BitcoindRpcClient.RawTransactionSigningOrVerificationError error : errors) {
                LOGGER.severe("Error: " + error);
            }
        }
        String sentRawTransactionID = client.sendRawTransaction(srTx.hex());
        LOGGER.info("Sent signedRawTx (txID): " + sentRawTransactionID);
    }

    static void signRawTransactionWithKeyTest_P2SH_P2WPKH(BitcoindRpcClient client) {
        LOGGER.info("=== Testing scenario: signRawTransactionWithKey (addr1 -> addr2)");
        String addr1 = client.getNewAddress();
        LOGGER.info("Created address addr1: " + addr1);
        String addr2 = client.getNewAddress();
        LOGGER.info("Created address addr2: " + addr2);
        List<String> generatedBlocksHashes = client.generateToAddress(110, addr1);
        LOGGER.info("Generated " + generatedBlocksHashes.size() + " blocks for addr1");
        List<BitcoindRpcClient.Unspent> utxos = client.listUnspent(0, Integer.MAX_VALUE, addr1);
        LOGGER.info("Found " + utxos.size() + " UTXOs (unspent transaction outputs) belonging to addr1");
        BitcoindRpcClient.Unspent selectedUtxo = utxos.get(0);
        LOGGER.info("Selected UTXO which will be sent from addr1 to addr2: " + selectedUtxo);
        BitcoindRpcClient.ExtendedTxInput inputP2SH_P2WPKH = new BitcoindRpcClient.ExtendedTxInput(selectedUtxo.txid(), selectedUtxo.vout(), selectedUtxo.scriptPubKey(), selectedUtxo.amount(), selectedUtxo.redeemScript(), selectedUtxo.witnessScript());
        LOGGER.info("inputP2SH_P2WPKH txid: " + inputP2SH_P2WPKH.txid());
        LOGGER.info("inputP2SH_P2WPKH vout: " + inputP2SH_P2WPKH.vout());
        LOGGER.info("inputP2SH_P2WPKH scriptPubKey: " + inputP2SH_P2WPKH.scriptPubKey());
        LOGGER.info("inputP2SH_P2WPKH redeemScript: " + inputP2SH_P2WPKH.redeemScript());
        LOGGER.info("inputP2SH_P2WPKH witnessScript: " + inputP2SH_P2WPKH.witnessScript());
        LOGGER.info("inputP2SH_P2WPKH amount: " + inputP2SH_P2WPKH.amount());
        BitcoinRawTxBuilder rawTxBuilder = new BitcoinRawTxBuilder(client);
        rawTxBuilder.in(inputP2SH_P2WPKH);
        BigDecimal estimatedFee = BigDecimal.valueOf(2.0E-6);
        BigDecimal txToAddr2Amount = selectedUtxo.amount().subtract(estimatedFee);
        rawTxBuilder.out(addr2, txToAddr2Amount);
        LOGGER.info("unsignedRawTx in amount: " + selectedUtxo.amount());
        LOGGER.info("unsignedRawTx out amount: " + txToAddr2Amount);
        String unsignedRawTxHex = rawTxBuilder.create();
        LOGGER.info("Created unsignedRawTx from addr1 to addr2: " + unsignedRawTxHex);
        BitcoindRpcClient.SignedRawTransaction srTx = client.signRawTransactionWithKey(unsignedRawTxHex, Arrays.asList(client.dumpPrivKey(addr1)), Arrays.asList(inputP2SH_P2WPKH), null);
        LOGGER.info("signedRawTx hex: " + srTx.hex());
        LOGGER.info("signedRawTx complete: " + srTx.complete());
        List<BitcoindRpcClient.RawTransactionSigningOrVerificationError> errors = srTx.errors();
        if (errors != null) {
            LOGGER.severe("Found errors when signing");
            for (BitcoindRpcClient.RawTransactionSigningOrVerificationError error : errors) {
                LOGGER.severe("Error: " + error);
            }
        }
        String sentRawTransactionID = client.sendRawTransaction(srTx.hex());
        LOGGER.info("Sent signedRawTx (txID): " + sentRawTransactionID);
    }
}

