/*
 * Decompiled with CFR 0.152.
 */
package website.magyar.mitm.proxy.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.proxy.jetty.http.HttpFields;
import net.lightbody.bmp.proxy.jetty.http.HttpOutputStream;
import net.lightbody.bmp.proxy.jetty.util.URI;
import net.lightbody.bmp.proxy.util.ClonedOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.magyar.mitm.proxy.header.HttpHeaderChange;
import website.magyar.mitm.proxy.header.HttpHeaderToBeAdded;
import website.magyar.mitm.proxy.header.HttpHeaderToBeRemoved;
import website.magyar.mitm.proxy.header.HttpHeaderToBeUpdated;

public class MitmJavaProxyHttpResponse {
    private final Logger logger = LoggerFactory.getLogger(MitmJavaProxyHttpResponse.class);
    private final boolean responseVolatile;
    private final HarEntry entry;
    private final HttpRequestBase method;
    private final URI proxyRequestURI;
    private final HttpResponse response;
    private final String errorMessage;
    private final String body;
    private final String contentType;
    private final String charSet;
    private int status;
    private String reasonPhrase;
    private final OutputStream os;
    private final Map<String, HttpHeaderChange> headerChanges = new HashMap<String, HttpHeaderChange>();
    private ByteArrayOutputStream bos;

    public MitmJavaProxyHttpResponse(int status, HarEntry entry, HttpRequestBase method, URI proxyRequestURI, HttpResponse response, String errorMessage, String body, String contentType, String charSet, ByteArrayOutputStream bos, OutputStream os, boolean responseVolatile) {
        this.entry = entry;
        this.method = method;
        this.proxyRequestURI = proxyRequestURI;
        this.response = response;
        this.errorMessage = errorMessage;
        this.body = body;
        this.contentType = contentType;
        this.charSet = charSet;
        this.status = status;
        this.bos = bos;
        this.os = os;
        this.responseVolatile = responseVolatile;
        this.reasonPhrase = null;
    }

    public String getBodyString() {
        return this.body;
    }

    public byte[] getBodyBytes() {
        byte[] result = null;
        ByteArrayOutputStream copy = null;
        boolean enableWorkWithCopy = false;
        if (!this.responseVolatile && this.os != null && this.os instanceof ClonedOutputStream) {
            copy = ((ClonedOutputStream)this.os).getOutput();
            enableWorkWithCopy = true;
        }
        if (this.responseVolatile && this.bos != null) {
            enableWorkWithCopy = true;
            copy = this.bos;
        }
        if (enableWorkWithCopy) {
            result = copy.toByteArray();
        }
        return result;
    }

    public void setBody(byte[] newBody) throws IOException {
        if (newBody != null && this.responseVolatile && this.bos != null) {
            String length = Integer.toString(newBody.length);
            IOUtils.closeQuietly((OutputStream)this.bos);
            this.bos = new ByteArrayOutputStream(newBody.length);
            IOUtils.write((byte[])newBody, (OutputStream)this.bos);
            this.getRawResponse().setEntity((HttpEntity)new ByteArrayEntity(newBody));
            Header header = this.getRawResponse().getFirstHeader("Content-Length");
            if (header != null) {
                this.getRawResponse().removeHeader(header);
                this.updateHeader(header, length);
            }
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        Header header = this.findHeader(this.getRawResponse().getAllHeaders(), "Content-Type");
        if (header != null) {
            this.updateHeader(header, contentType);
        } else {
            this.addHeader((Header)new BasicHeader("Content-Type", contentType));
        }
    }

    public Header findHeader(Header[] headers, String key) {
        Header header = null;
        for (Header h : headers) {
            if (!h.getName().equals(key)) continue;
            header = h;
            break;
        }
        return header;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getHeader(String name) {
        Header header = this.response.getFirstHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public Header[] getHeaders() {
        return this.response.getAllHeaders();
    }

    public Header[] getRequestHeaders() {
        return this.method.getAllHeaders();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int newStatus) {
        this.response.setStatusCode(newStatus);
        this.status = newStatus;
    }

    public void setReasonPhrase(String newReasonPhrase) {
        this.reasonPhrase = newReasonPhrase;
    }

    public HttpResponse getRawResponse() {
        return this.response;
    }

    public HarEntry getEntry() {
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAnswer(net.lightbody.bmp.proxy.jetty.http.HttpResponse response) {
        if (this.responseVolatile && !this.headerChanges.isEmpty()) {
            HttpFields httpFields = response.getHeader();
            for (Map.Entry<String, HttpHeaderChange> headerChangeEntry : this.headerChanges.entrySet()) {
                String key = headerChangeEntry.getKey();
                HttpHeaderChange httpHeaderChange = headerChangeEntry.getValue();
                String value = httpHeaderChange.getHeader().getValue();
                if (httpHeaderChange instanceof HttpHeaderToBeUpdated) {
                    value = ((HttpHeaderToBeUpdated)httpHeaderChange).getNewValue();
                    httpFields.put(key, value);
                }
                if (httpHeaderChange instanceof HttpHeaderToBeAdded) {
                    httpFields.add(key, value);
                }
                if (!(httpHeaderChange instanceof HttpHeaderToBeRemoved)) continue;
                httpFields.remove(key);
            }
        }
        if (this.responseVolatile && this.status != response.getStatus() && this.status != -998) {
            response.setStatus(this.status);
            this.entry.getResponse().setStatus(this.status);
        }
        if (this.responseVolatile && this.reasonPhrase != null) {
            this.entry.getResponse().setStatusText(this.reasonPhrase);
            response.setStatus(this.status, this.reasonPhrase);
        }
        if (!this.responseVolatile || this.bos == null || this.os == null) {
            return;
        }
        byte[] answer = this.bos.toByteArray();
        try {
            ((HttpOutputStream)this.os).setContentLength(answer.length);
            response.setIntField("Content-Length", answer.length);
            this.os.write(answer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.bos);
            IOUtils.closeQuietly((OutputStream)this.os);
        }
    }

    public boolean isResponseVolatile() {
        return this.responseVolatile;
    }

    public HttpRequestBase getMethod() {
        return this.method;
    }

    public URI getProxyRequestURI() {
        return this.proxyRequestURI;
    }

    public void removeHeader(Header header) {
        boolean found = false;
        if (header != null) {
            Header[] headers;
            String key = header.getName();
            for (Header h : headers = this.getHeaders()) {
                if (!header.getName().equals(h.getName()) || !header.getValue().equals(h.getValue())) continue;
                found = true;
                this.getRawResponse().removeHeader(h);
                HttpHeaderToBeRemoved headerToBeRemoved = new HttpHeaderToBeRemoved(header);
                this.headerChanges.put(key, headerToBeRemoved);
            }
            if (!found) {
                this.logger.warn("Header with key: {} not found, remove header skipped.", (Object)key);
            }
        } else {
            this.logger.warn("removeHeader called with null");
        }
    }

    public void addHeader(Header header) {
        if (header != null) {
            HttpResponse httpResponse = this.getRawResponse();
            if (httpResponse != null) {
                httpResponse.addHeader(header);
                HttpHeaderToBeAdded httpHeaderToBeAdded = new HttpHeaderToBeAdded(header);
                this.headerChanges.put(header.getName(), httpHeaderToBeAdded);
            } else {
                this.logger.warn("addHeader called without accessible response");
            }
        } else {
            this.logger.warn("addHeader called with null");
        }
    }

    public void updateHeader(Header header, String newValue) {
        boolean found = false;
        if (header != null && newValue != null) {
            Header[] headers;
            String key = header.getName();
            for (Header h : headers = this.getHeaders()) {
                if (!header.getName().equals(h.getName()) || !header.getValue().equals(h.getValue())) continue;
                found = true;
                this.getRawResponse().removeHeader(h);
                this.getRawResponse().addHeader(key, newValue);
                HttpHeaderToBeUpdated httpHeaderToBeUpdated = new HttpHeaderToBeUpdated(header, newValue);
                this.headerChanges.put(key, httpHeaderToBeUpdated);
            }
            if (!found) {
                BasicHeader h = new BasicHeader(header.getName(), newValue);
                this.addHeader((Header)h);
            }
        } else {
            this.logger.warn("updateHeader called with null");
        }
    }
}

