/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.util;

public class ByteArrayPool {
    public static final int __POOL_SIZE = Integer.getInteger("net.lightbody.bmp.proxy.jetty.util.ByteArrayPool.pool_size", 8);
    public static final ThreadLocal __pools = new BAThreadLocal();
    public static int __slot;

    public static byte[] getByteArray(int size) {
        byte[][] pool = (byte[][])__pools.get();
        boolean full = true;
        int i = pool.length;
        while (i-- > 0) {
            if (pool[i] != null && pool[i].length == size) {
                byte[] b = pool[i];
                pool[i] = null;
                return b;
            }
            full = false;
        }
        if (full) {
            i = pool.length;
            while (i-- > 0) {
                pool[i] = null;
            }
        }
        return new byte[size];
    }

    public static byte[] getByteArrayAtLeast(int minSize) {
        byte[][] pool = (byte[][])__pools.get();
        int i = pool.length;
        while (i-- > 0) {
            if (pool[i] == null || pool[i].length < minSize) continue;
            byte[] b = pool[i];
            pool[i] = null;
            return b;
        }
        return new byte[minSize];
    }

    public static void returnByteArray(byte[] b) {
        int s;
        if (b == null) {
            return;
        }
        byte[][] pool = (byte[][])__pools.get();
        int i = pool.length;
        while (i-- > 0) {
            if (pool[i] != null) continue;
            pool[i] = b;
            return;
        }
        if ((s = __slot++) < 0) {
            s = -s;
        }
        pool[s % pool.length] = b;
    }

    private static final class BAThreadLocal
    extends ThreadLocal {
        private BAThreadLocal() {
        }

        protected Object initialValue() {
            return new byte[__POOL_SIZE][];
        }
    }
}

