/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.selenium;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;

public class CertificateCreatorObsolete {
    public static final String KEYGEN_ALGO = "RSA";
    public static final String SIGN_ALGO = "SHA1withRSA";
    public static final String OID_SUBJECT_KEY_IDENTIFIER = "2.5.29.14";
    public static final String OID_AUTHORITY_KEY_IDENTIFIER = "2.5.29.35";
    public static final String OID_ISSUER_ALTERNATIVE_NAME = "2.5.29.8";
    public static final String OID_ISSUER_ALTERNATIVE_NAME_2 = "2.5.29.18";
    public static final String OID_CRL_DISTRIBUTION_POINT = "2.5.28.31";
    public static final String OID_AUTHORITY_INFO_ACCESS = "1.3.6.1.5.5.7.1.1";
    public static final String OID_ID_AD_CAISSUERS = "1.3.6.1.5.5.7.48.2";
    private static final HashSet<String> clientCertOidsNeverToCopy = new HashSet();
    private static final HashSet<String> clientCertDefaultOidsNotToCopy = new HashSet();

    public static X509Certificate mitmDuplicateCertificate(X509Certificate originalCert, PublicKey newPubKey, X509Certificate caCert, PrivateKey caPrivateKey, Set<String> extensionOidsNotToCopy) throws SignatureException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, CertIOException, OperatorCreationException {
        if (extensionOidsNotToCopy == null) {
            extensionOidsNotToCopy = new HashSet<String>();
        }
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        v3CertGen.setSubjectDN(originalCert.getSubjectX500Principal());
        v3CertGen.setSignatureAlgorithm(SIGN_ALGO);
        v3CertGen.setPublicKey(newPubKey);
        v3CertGen.setNotAfter(originalCert.getNotAfter());
        v3CertGen.setNotBefore(originalCert.getNotBefore());
        v3CertGen.setIssuerDN(caCert.getSubjectX500Principal());
        v3CertGen.setSerialNumber(originalCert.getSerialNumber());
        Set<String> critExts = originalCert.getCriticalExtensionOIDs();
        if (critExts != null) {
            throw new RuntimeException("Ups has critical extensions...");
        }
        Set<String> nonCritExs = originalCert.getNonCriticalExtensionOIDs();
        if (nonCritExs != null) {
            throw new RuntimeException("Ups has non-critical extensions...");
        }
        v3CertGen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(caCert.getPublicKey()));
        X509Certificate cert = v3CertGen.generate(caPrivateKey, "BC");
        JcaX509v3CertificateBuilder x509v3CertificateBuilder = new JcaX509v3CertificateBuilder(caCert.getSubjectX500Principal(), originalCert.getSerialNumber(), originalCert.getNotBefore(), originalCert.getNotAfter(), originalCert.getSubjectX500Principal(), newPubKey);
        x509v3CertificateBuilder.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(caCert.getPublicKey()));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(caPrivateKey);
        X509CertificateHolder certHolder = x509v3CertificateBuilder.build(signer);
        cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
        cert.verify(newPubKey);
        return cert;
    }

    public static X509Certificate mitmDuplicateCertificate(X509Certificate originalCert, PublicKey newPubKey, X509Certificate caCert, PrivateKey caPrivateKey) throws SignatureException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, CertIOException, OperatorCreationException {
        return CertificateCreatorObsolete.mitmDuplicateCertificate(originalCert, newPubKey, caCert, caPrivateKey, clientCertDefaultOidsNotToCopy);
    }

    public static X509Certificate generateStdSSLServerCertificate(PublicKey newPubKey, X509Certificate caCert, PrivateKey caPrivateKey, String subject) throws SignatureException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, CertIOException, OperatorCreationException {
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        JcaX509v3CertificateBuilder x509v3CertificateBuilder = new JcaX509v3CertificateBuilder(caCert.getIssuerX500Principal(), new BigInteger(Long.toString(System.currentTimeMillis())), new Date(System.currentTimeMillis() - 31104000000L), new Date(System.currentTimeMillis() + 933120000L), new X500Principal(subject), newPubKey);
        x509v3CertificateBuilder.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        x509v3CertificateBuilder.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(caCert.getPublicKey()));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(caPrivateKey);
        X509CertificateHolder certHolder = x509v3CertificateBuilder.build(signer);
        X509Certificate newCert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
        v3CertGen.setSubjectDN(new X500Principal(subject));
        v3CertGen.setSignatureAlgorithm(SIGN_ALGO);
        v3CertGen.setPublicKey(newPubKey);
        v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 933120000L));
        v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 31104000000L));
        v3CertGen.setIssuerDN(caCert.getSubjectX500Principal());
        v3CertGen.setSerialNumber(new BigInteger(Long.toString(System.currentTimeMillis())));
        v3CertGen.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        v3CertGen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(caCert.getPublicKey()));
        X509Certificate cert = v3CertGen.generate(caPrivateKey, "BC");
        return newCert;
    }

    static {
        clientCertOidsNeverToCopy.add(OID_SUBJECT_KEY_IDENTIFIER);
        clientCertOidsNeverToCopy.add(OID_AUTHORITY_KEY_IDENTIFIER);
        clientCertDefaultOidsNotToCopy.add(OID_ISSUER_ALTERNATIVE_NAME);
        clientCertDefaultOidsNotToCopy.add(OID_ISSUER_ALTERNATIVE_NAME_2);
        clientCertDefaultOidsNotToCopy.add(OID_CRL_DISTRIBUTION_POINT);
        clientCertDefaultOidsNotToCopy.add(OID_AUTHORITY_INFO_ACCESS);
    }
}

