/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http.handler;

import java.io.IOException;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.handler.AbstractHttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotFoundHandler
extends AbstractHttpHandler {
    private final Logger log = LoggerFactory.getLogger(NotFoundHandler.class);

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws IOException {
        String method;
        this.log.debug("Not Found");
        switch (method = request.getMethod()) {
            case "GET": 
            case "HEAD": 
            case "POST": 
            case "PUT": 
            case "DELETE": 
            case "MOVE": {
                response.sendError(404, request.getPath() + " Not Found");
                break;
            }
            case "OPTIONS": {
                if ("*".equals(request.getPath())) {
                    response.setIntField("Content-Length", 0);
                    response.setField("Allow", "GET, HEAD, POST, PUT, DELETE, MOVE, OPTIONS, TRACE");
                    response.commit();
                    break;
                }
                response.sendError(404);
                break;
            }
            case "TRACE": {
                this.handleTrace(request, response);
                break;
            }
            default: {
                response.setField("Allow", "GET, HEAD, POST, PUT, DELETE, MOVE, OPTIONS, TRACE");
                response.sendError(405);
            }
        }
    }
}

