/*
 * Decompiled with CFR 0.152.
 */
package website.magyar.mitm.idgenerator;

import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicInteger;
import website.magyar.mitm.idgenerator.CurrentDateProvider;

public class TimeStampBasedIdGenerator {
    private static final int NO_DIGITS = 4;
    private final AtomicInteger currentNumber = new AtomicInteger();
    private final CurrentDateProvider currentDateProvider = new CurrentDateProvider();
    private final SimpleDateFormat fileSimpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private String previousSimpleDate;

    public synchronized String nextIdentifier() {
        String currentSimpleDate = this.getCurrentDateFormattedForFiles();
        this.checkPreviousDate(currentSimpleDate);
        return currentSimpleDate + "." + this.fourDigitString();
    }

    private String getCurrentDateFormattedForFiles() {
        return this.fileSimpleDateFormat.format(this.currentDateProvider.getCurrentDate());
    }

    private void checkPreviousDate(String currentSimpleDate) {
        if (!currentSimpleDate.equals(this.previousSimpleDate)) {
            this.previousSimpleDate = currentSimpleDate;
            this.currentNumber.set(0);
        }
    }

    private String fourDigitString() {
        String convertedNumber = String.valueOf(this.currentNumber.getAndIncrement());
        String zeros = this.createZeros(convertedNumber);
        return zeros + convertedNumber;
    }

    private String createZeros(String convertedNumber) {
        int size = 4 - convertedNumber.length();
        if (size <= 0) {
            return "";
        }
        StringBuilder outputBuffer = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            outputBuffer.append("0");
        }
        return outputBuffer.toString();
    }
}

