/*
 * Decompiled with CFR 0.152.
 */
package com.whl.quickjs.wrapper;

import com.whl.quickjs.wrapper.JSArray;
import com.whl.quickjs.wrapper.JSObject;
import com.whl.quickjs.wrapper.NativeCleaner;

public class QuickJSContext {
    private static final String UNDEFINED = "undefined.js";
    private final long context;
    private final NativeCleaner<JSObject> nativeCleaner = new NativeCleaner<JSObject>(){

        @Override
        public void onRemove(long pointer) {
            QuickJSContext.this.freeDupValue(QuickJSContext.this.context, pointer);
        }
    };

    public static QuickJSContext create() {
        return new QuickJSContext();
    }

    private QuickJSContext() {
        this.context = this.createContext();
    }

    public Object evaluate(String script) {
        return this.evaluate(script, UNDEFINED);
    }

    public Object evaluate(String script, String fileName) {
        return this.evaluate(this.context, script, fileName);
    }

    public JSObject getGlobalObject() {
        return this.getGlobalObject(this.context);
    }

    public void destroyContext() {
        this.nativeCleaner.forceClean();
        this.destroyContext(this.context);
    }

    public String stringify(JSObject jsObj) {
        return this.stringify(this.context, jsObj.getPointer());
    }

    public Object getProperty(JSObject jsObj, String name) {
        return this.getProperty(this.context, jsObj.getPointer(), name);
    }

    public void setProperty(JSObject jsObj, String name, Object value) {
        this.setProperty(this.context, jsObj.getPointer(), name, value);
    }

    public void freeValue(JSObject jsObj) {
        this.freeValue(this.context, jsObj.getPointer());
    }

    public void dupValue(JSObject jsObj) {
        this.dupValue(this.context, jsObj.getPointer());
    }

    public void freeDupValue(JSObject jsObj) {
        this.freeDupValue(this.context, jsObj.getPointer());
    }

    public int length(JSArray jsArray) {
        return this.length(this.context, jsArray.getPointer());
    }

    public Object get(JSArray jsArray, int index) {
        return this.get(this.context, jsArray.getPointer(), index);
    }

    public Object call(JSObject func, JSObject thisObj, Object ... args) {
        return this.call(this.context, func.getPointer(), thisObj.getPointer(), args);
    }

    public void hold(JSObject jsObj) {
        jsObj.dupValue();
        this.nativeCleaner.register(jsObj, jsObj.getPointer());
    }

    public JSObject parseJSON(String json) {
        return this.parseJSON(this.context, json);
    }

    public byte[] compile(String sourceCode) {
        return this.compile(this.context, sourceCode);
    }

    public Object execute(byte[] code) {
        return this.execute(this.context, code);
    }

    private native long createContext();

    private native void destroyContext(long var1);

    private native Object evaluate(long var1, String var3, String var4);

    private native JSObject getGlobalObject(long var1);

    private native Object call(long var1, long var3, long var5, Object[] var7);

    private native Object getProperty(long var1, long var3, String var5);

    private native void setProperty(long var1, long var3, String var5, Object var6);

    private native String stringify(long var1, long var3);

    private native int length(long var1, long var3);

    private native Object get(long var1, long var3, int var5);

    private native void freeValue(long var1, long var3);

    private native void dupValue(long var1, long var3);

    private native void freeDupValue(long var1, long var3);

    private native JSObject parseJSON(long var1, String var3);

    private native byte[] compile(long var1, String var3);

    private native Object execute(long var1, byte[] var3);

    static {
        System.loadLibrary("quickjs-android-wrapper");
    }
}

