/*
 * Decompiled with CFR 0.152.
 */
package vn.tiki.noadapter.databinding;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import vn.tiki.noadapter.AbsViewHolder;
import vn.tiki.noadapter.ViewHolderSelector;
import vn.tiki.noadapter.databinding.ExtraBinding;
import vn.tiki.noadapter.databinding.LayoutSelector;
import vn.tiki.noadapter.databinding.OnlyViewHolder;

public class BindingViewHolderSelector
implements ViewHolderSelector {
    private LayoutSelector layoutSelector;
    private ExtraBinding extraBinding;

    private BindingViewHolderSelector(LayoutSelector layoutSelector, ExtraBinding extraBinding) {
        this.layoutSelector = layoutSelector;
        this.extraBinding = extraBinding;
    }

    public AbsViewHolder viewHolderForType(ViewGroup parent, int type) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        int layoutId = this.layoutSelector.layoutForType(type);
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)inflater, (int)layoutId, (ViewGroup)parent, (boolean)false);
        return new OnlyViewHolder(binding, this.extraBinding);
    }

    public static class Builder {
        private LayoutSelector layoutSelector;
        private ExtraBinding extraBinding;

        public Builder layoutSelector(LayoutSelector layoutSelector) {
            this.layoutSelector = layoutSelector;
            return this;
        }

        public Builder extraBinding(ExtraBinding extraBinding) {
            this.extraBinding = extraBinding;
            return this;
        }

        public BindingViewHolderSelector build() {
            return new BindingViewHolderSelector(this.layoutSelector, this.extraBinding);
        }
    }
}

