/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.provider.ContactsContract;
import androidx.core.content.ContextCompat;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.lite.entity.ui.contact.LocalContactInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0001H\u0002\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u0001\u001a\u001e\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\n*\u00020\u000b\u001a@\u0010\f\u001a8\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b\u0018\u00010\rj \u0012\u0004\u0012\u00020\u0001\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00010\bj\b\u0012\u0004\u0012\u00020\u0001`\n\u0018\u0001`\u000e*\u00020\u000b\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"PHONE_REGEX_GLOBAL", "", "PHONE_REGEX_GLOBAL_FULL", "PHONE_REGEX_NORMAL", "checkPhone", "", "convertPhoneNumber", "getContactName", "Ljava/util/ArrayList;", "Lcom/netacom/lite/entity/ui/contact/LocalContactInfo;", "Lkotlin/collections/ArrayList;", "Landroid/content/Context;", "getContactNumbers", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "standardizedPhoneNumber", "netacom-sdk-lite_NetAloProdRelease"})
public final class ContactUtilKt {
    @NotNull
    public static final String PHONE_REGEX_NORMAL = "^[0-9]{10}$";
    @NotNull
    public static final String PHONE_REGEX_GLOBAL_FULL = "^([\\+]?84)?[0-9]{9}$";
    @NotNull
    public static final String PHONE_REGEX_GLOBAL = "^([8]4)?[0-9]{9}$";

    @Nullable
    public static final String convertPhoneNumber(@NotNull String $this$convertPhoneNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$convertPhoneNumber, (String)"$this$convertPhoneNumber");
        CharSequence charSequence = $this$convertPhoneNumber;
        boolean bl = false;
        if (charSequence.length() > 0) {
            String string2;
            String string3 = $this$convertPhoneNumber;
            int n = 0;
            int n2 = 1;
            boolean bl2 = false;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String first = string4;
            if (ContactUtilKt.checkPhone($this$convertPhoneNumber) && $this$convertPhoneNumber.length() >= 10) {
                switch (first) {
                    case "0": {
                        String stringSplit = StringsKt.substringAfter$default((String)$this$convertPhoneNumber, (String)"0", null, (int)2, null);
                        string2 = "+84" + stringSplit;
                        break;
                    }
                    case "8": {
                        string2 = '+' + $this$convertPhoneNumber;
                        break;
                    }
                    default: {
                        string2 = $this$convertPhoneNumber;
                        break;
                    }
                }
            } else {
                return null;
            }
            return string2;
        }
        return null;
    }

    private static final boolean checkPhone(String $this$checkPhone) {
        boolean bl;
        CharSequence charSequence = $this$checkPhone;
        int n = 0;
        if (charSequence.length() == 0) {
            return false;
        }
        charSequence = $this$checkPhone;
        n = 0;
        int n2 = 1;
        boolean bl2 = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)charSequence2).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        switch (string2) {
            case "0": {
                Pattern pattern = Pattern.compile(PHONE_REGEX_NORMAL);
                bl = pattern.matcher($this$checkPhone).matches();
                break;
            }
            case "+": {
                Pattern pattern = Pattern.compile(PHONE_REGEX_GLOBAL_FULL);
                bl = pattern.matcher($this$checkPhone).matches();
                break;
            }
            case "8": {
                Pattern pattern = Pattern.compile(PHONE_REGEX_GLOBAL);
                bl = pattern.matcher($this$checkPhone).matches();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final ArrayList<LocalContactInfo> getContactName(@NotNull Context $this$getContactName) {
        ArrayList<LocalContactInfo> contactsList;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$getContactName, (String)"$this$getContactName");
            contactsList = null;
            try {
                Cursor contactsCursor;
                if (ContextCompat.checkSelfPermission((Context)$this$getContactName, (String)"android.permission.READ_CONTACTS") != 0) break block3;
                long startTime = System.currentTimeMillis();
                contactsList = new ArrayList<LocalContactInfo>();
                ContentResolver contentResolver = $this$getContactName.getContentResolver();
                Cursor cursor = contactsCursor = contentResolver != null ? contentResolver.query(ContactsContract.Contacts.CONTENT_URI, null, null, null, "display_name ASC") : null;
                if (contactsCursor == null || contactsCursor.getCount() <= 0) break block3;
                while (contactsCursor.moveToNext()) {
                    String string2;
                    String string3;
                    Intrinsics.checkNotNullExpressionValue((Object)contactsCursor.getString(contactsCursor.getColumnIndex("has_phone_number")), (String)"contactsCursor.getString\u2026                        )");
                    boolean bl = false;
                    int hasPhoneNumber = Integer.parseInt(string3);
                    if (hasPhoneNumber <= 0) continue;
                    int idIndex = contactsCursor.getColumnIndex("_id");
                    int nameIndex = contactsCursor.getColumnIndex("display_name");
                    String id = contactsCursor.getString(idIndex);
                    String name = contactsCursor.getString(nameIndex);
                    if (name == null) continue;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String it = string2;
                    boolean bl4 = false;
                    contactsList.add(new LocalContactInfo(id, it, null, null, 12, null));
                }
                contactsCursor.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            }
        }
        return contactsList;
    }

    @Nullable
    public static final HashMap<String, ArrayList<String>> getContactNumbers(@NotNull Context $this$getContactNumbers) {
        Intrinsics.checkNotNullParameter((Object)$this$getContactNumbers, (String)"$this$getContactNumbers");
        HashMap contactNumbers = null;
        try {
            if (ContextCompat.checkSelfPermission((Context)$this$getContactNumbers, (String)"android.permission.READ_CONTACTS") == 0) {
                long startTime = System.currentTimeMillis();
                contactNumbers = new HashMap();
                Cursor phoneCursor = $this$getContactNumbers.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, null, null, null);
                if (phoneCursor != null && phoneCursor.getCount() > 0) {
                    int contactIdIndex = phoneCursor.getColumnIndex("contact_id");
                    int numberIndex = phoneCursor.getColumnIndex("data1");
                    while (phoneCursor.moveToNext()) {
                        String number;
                        String contactId = phoneCursor.getString(contactIdIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)phoneCursor.getString(numberIndex), (String)"phoneCursor.getString(numberIndex)");
                        if (contactNumbers.containsKey(contactId)) {
                            ArrayList arrayList = (ArrayList)contactNumbers.get(contactId);
                            if (arrayList != null) {
                                arrayList.add(number);
                            }
                            continue;
                        }
                        Map map2 = contactNumbers;
                        String string2 = contactId;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contactId");
                        map2.put(string2, CollectionsKt.arrayListOf((Object[])new String[]{number}));
                    }
                    phoneCursor.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
        }
        return contactNumbers;
    }

    @NotNull
    public static final String standardizedPhoneNumber(@NotNull String $this$standardizedPhoneNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$standardizedPhoneNumber, (String)"$this$standardizedPhoneNumber");
        return StringsKt.contains$default((CharSequence)$this$standardizedPhoneNumber, (CharSequence)"+84", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)$this$standardizedPhoneNumber, (String)"+84", (String)"0", (boolean)false, (int)4, null) : $this$standardizedPhoneNumber;
    }
}

