/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.util;

import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.android_utils.FileIOUtils;
import com.netacom.base.chat.android_utils.UriUtils;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.imageloader.ImageUtilsKt;
import com.netacom.base.chat.logger.Logger;
import com.netacom.base.chat.util.ConvertUtil;
import com.netacom.base.chat.util.CoreUtilsKt;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.lite.R;
import com.netacom.lite.define.MediaType;
import com.netacom.lite.entity.ui.local.LocalFileModel;
import com.netacom.lite.repository.secretChat.ChatSecretUtils;
import com.netacom.lite.util.AppUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001UB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015JD\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0004J0\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u00040 j\b\u0012\u0004\u0012\u00020\u0004`!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001dH\u0002J0\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u00040 j\b\u0012\u0004\u0012\u00020\u0004`!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001dH\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0004J$\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001dJ$\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001dJ\u001a\u0010-\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020\u00042\b\u0010\"\u001a\u0004\u0018\u00010#J;\u0010/\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020#2\b\u00100\u001a\u0004\u0018\u00010\u00132\b\u00101\u001a\u0004\u0018\u00010\u00042\u000e\u00102\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u000103H\u0002\u00a2\u0006\u0002\u00104J\u000e\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0004J\u001a\u0010;\u001a\u0004\u0018\u00010\u00132\u0006\u0010\"\u001a\u00020#2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J \u0010<\u001a\u00020+2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020=2\b\b\u0002\u0010>\u001a\u00020\u001aJ\u001a\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0004J\u0010\u0010A\u001a\u0004\u0018\u00010\u00042\u0006\u00106\u001a\u000207J\u0018\u0010B\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u00100\u001a\u00020\u0013J\u0016\u0010C\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u001aJ$\u0010E\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0004J\u000e\u0010F\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010G\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0013H\u0002J\u0010\u0010H\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0013H\u0002J\u000e\u0010I\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u0004J\u0010\u0010J\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0013H\u0002J\u0010\u0010K\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0013H\u0002J$\u0010L\u001a\u00020M2\u0006\u0010\"\u001a\u00020#2\u0006\u00106\u001a\u0002072\f\u0010N\u001a\b\u0012\u0004\u0012\u00020M0OJ\u0012\u0010P\u001a\u0004\u0018\u0001072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001e\u0010Q\u001a\u00020\u00042\u0006\u0010R\u001a\u00020S2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004JF\u0010T\u001a\u00020\u00042\b\u0010R\u001a\u0004\u0018\u00010S2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/netacom/lite/util/FileUtils;", "", "()V", "downloadFolderPath", "", "getDownloadFolderPath", "()Ljava/lang/String;", "secretFolderPath", "getSecretFolderPath", "stickerFolder", "getStickerFolder", "supportExtension", "", "getSupportExtension", "()Ljava/util/List;", "tempFolder", "getTempFolder", "videoThumbnailPath", "convertBitmapToUriTemp", "Landroid/net/Uri;", "bitmap", "Landroid/graphics/Bitmap;", "copyFileToLocal", "copyFilePath", "fileName", "isTemp", "", "isSaveDocument", "type", "", "extension", "findAllDocumentPath", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "context", "Landroid/content/Context;", "position", "pagingSize", "findAllMediaTypePath", "folderIsEmptyOrNull", "Lcom/netacom/lite/util/FileUtils$FolderStatus;", "folderPath", "getAllLocalDocumentFiles", "Lcom/netacom/lite/entity/ui/local/LocalFileModel;", "getAllLocalMediaFiles", "getBitmapFromLocalPath", "localPath", "getDataColumn", "uri", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getDocumentMimeType", "file", "Ljava/io/File;", "getDurationOfMediaByPath", "", "path", "getImageUriShare", "getLocalFileByPath", "Lcom/netacom/lite/define/MediaType;", "isLocal", "getMediaType", "fileType", "getMimeType", "getRealPathFromURI", "getWidthOrHeightOfMediaByPath", "isWidth", "isCacheFileDownloaded", "isContainsExtensionFromName", "isDownloadsDocument", "isExternalStorageDocument", "isFolderEmpty", "isGooglePhotosUri", "isMediaDocument", "openFile", "", "callback", "Lkotlin/Function0;", "saveBitmapToFile", "saveEncryptedFileToLocal", "body", "Lokhttp3/ResponseBody;", "saveFileToLocal", "FolderStatus", "netacom-sdk-lite_NetAloDevRelease"})
@ExperimentalCoroutinesApi
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    private static final String videoThumbnailPath = Intrinsics.stringPlus((String)Utils.getApp().getFilesDir().getPath(), (Object)"/download_file/video_thumbnail/");
    @NotNull
    private static final String downloadFolderPath = Intrinsics.stringPlus((String)Utils.getApp().getFilesDir().getPath(), (Object)"/download_file");
    @NotNull
    private static final String secretFolderPath = Intrinsics.stringPlus((String)Utils.getApp().getFilesDir().getPath(), (Object)"/download_file/secret");
    @NotNull
    private static final String stickerFolder = Intrinsics.stringPlus((String)Utils.getApp().getFilesDir().getPath(), (Object)"/Stickers");
    @NotNull
    private static final String tempFolder = Intrinsics.stringPlus((String)Utils.getApp().getFilesDir().getPath(), (Object)"/temp_file");
    @NotNull
    private static final List<String> supportExtension;

    private FileUtils() {
    }

    @NotNull
    public final String getDownloadFolderPath() {
        return downloadFolderPath;
    }

    @NotNull
    public final String getSecretFolderPath() {
        return secretFolderPath;
    }

    @NotNull
    public final String getStickerFolder() {
        return stickerFolder;
    }

    @NotNull
    public final String getTempFolder() {
        return tempFolder;
    }

    @NotNull
    public final List<String> getSupportExtension() {
        return supportExtension;
    }

    @Nullable
    public final String getMimeType(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            String extension = FilesKt.getExtension((File)file);
            CharSequence charSequence = extension;
            int n = 0;
            if (charSequence.length() > 0) {
                MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
                charSequence = extension;
                n = 1;
                boolean bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence2).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                return mimeTypeMap.getMimeTypeFromExtension(string2);
            }
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
        }
        return "application/octet-stream";
    }

    @Nullable
    public final Uri convertBitmapToUriTemp(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        File tempDir = new File(Utils.getApp().getCacheDir().getAbsolutePath());
        File tempFile = File.createTempFile(Intrinsics.stringPlus((String)"cache", (Object)UUID.randomUUID()), ".jpg", tempDir);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            byte[] bitmapData = bos.toByteArray();
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write(bitmapData);
            fos.flush();
            fos.close();
            Logger.INSTANCE.d(Intrinsics.stringPlus((String)"___FileUtils = ", (Object)Uri.fromFile((File)tempFile)), new Object[0]);
            return Uri.fromFile((File)tempFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            Uri uri = Uri.fromFile((File)tempFile);
            return uri;
        }
    }

    @Nullable
    public final File saveBitmapToFile(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        File videoThumbLocalFile = new File(Intrinsics.stringPlus((String)videoThumbnailPath, (Object)AppUtils.createFileNamePNG$default(AppUtils.INSTANCE, null, 1, null)));
        com.netacom.base.chat.android_utils.FileUtils.createOrExistsFile((File)videoThumbLocalFile);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
            byte[] bitmapData = bos.toByteArray();
            FileOutputStream fos = new FileOutputStream(videoThumbLocalFile);
            fos.write(bitmapData);
            fos.flush();
            fos.close();
            Logger.INSTANCE.d(Intrinsics.stringPlus((String)"___FileUtils = ", (Object)Uri.parse((String)videoThumbLocalFile.getPath())), new Object[0]);
            return videoThumbLocalFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            File file = videoThumbLocalFile;
            return file;
        }
    }

    @Nullable
    public final Uri getImageUriShare(@NotNull Context context, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bytes);
        String bitmapUri = MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (Bitmap)bitmap, (String)context.getString(R.string.app_name), null);
        return Uri.parse((String)bitmapUri);
    }

    @Nullable
    public final String getRealPathFromURI(@NotNull Context context, @NotNull Uri uri) {
        block22: {
            block20: {
                block21: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                    if (!DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) break block20;
                    if (!this.isExternalStorageDocument(uri)) break block21;
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                    String[] stringArray = new String[]{":"};
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)docId, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                    if (stringArray2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] split = stringArray2;
                    String type = split[0];
                    if (StringsKt.equals((String)"primary", (String)type, (boolean)true)) {
                        return Environment.getExternalStorageDirectory().toString() + '/' + split[1];
                    }
                    break block22;
                }
                if (this.isDownloadsDocument(uri)) {
                    String id;
                    String split = id = DocumentsContract.getDocumentId((Uri)uri);
                    Intrinsics.checkNotNullExpressionValue((Object)split, (String)"id");
                    CharSequence $this$isDigitsOnly$iv = split;
                    boolean $i$f$isDigitsOnly22 = false;
                    if (!TextUtils.isDigitsOnly((CharSequence)$this$isDigitsOnly$iv) && Intrinsics.areEqual((Object)(id = CoreUtilsKt.getOnlyDigits((String)id)), (Object)"")) {
                        id = "0";
                    }
                    Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
                    Long $i$f$toTypedArray = Long.valueOf(id);
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$toTypedArray, (String)"valueOf(id)");
                    Uri $i$f$isDigitsOnly22 = ContentUris.withAppendedId((Uri)uri2, (long)((Number)$i$f$toTypedArray).longValue());
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$isDigitsOnly22, (String)"withAppendedId(\n        \u2026eOf(id)\n                )");
                    Uri contentUri = $i$f$isDigitsOnly22;
                    return this.getDataColumn(context, contentUri, null, null);
                }
                if (!this.isMediaDocument(uri)) break block22;
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                String[] $i$f$isDigitsOnly22 = new String[]{":"};
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)docId, (String[])$i$f$isDigitsOnly22, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Object thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                Uri contentUri = null;
                switch (type) {
                    case "image": {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        break;
                    }
                    case "video": {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        break;
                    }
                    case "audio": {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                }
                String selection = "_id=?";
                String[] stringArray3 = new String[]{split[1]};
                String[] selectionArgs = stringArray3;
                return this.getDataColumn(context, contentUri, selection, selectionArgs);
            }
            if (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true)) {
                return this.isGooglePhotosUri(uri) ? uri.getLastPathSegment() : this.getDataColumn(context, uri, null, null);
            }
            if (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true)) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Uri uri2;
        Cursor cursor;
        block6: {
            Cursor cursor2;
            Object object;
            cursor = null;
            String column = "_data";
            uri2 = new Uri[]{column};
            Uri projection = uri2;
            try {
                Cursor cursor3;
                uri2 = uri;
                if (uri2 == null) {
                    cursor3 = null;
                } else {
                    object = uri2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Uri it = object;
                    boolean bl3 = false;
                    cursor3 = context.getContentResolver().query(it, (String[])projection, selection, selectionArgs, null);
                }
                cursor = cursor3;
                if (cursor == null || !cursor.moveToFirst()) break block6;
                int index = cursor.getColumnIndexOrThrow(column);
                object = cursor.getString(index);
                cursor2 = cursor;
            }
            catch (Throwable throwable) {
                Cursor cursor4 = cursor;
                if (cursor4 != null) {
                    cursor4.close();
                }
                throw throwable;
            }
            cursor2.close();
            return object;
        }
        uri2 = cursor;
        if (uri2 != null) {
            uri2.close();
        }
        return null;
    }

    private final boolean isExternalStorageDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    private final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    private final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    private final boolean isGooglePhotosUri(Uri uri) {
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.content", (Object)uri.getAuthority());
    }

    private final ArrayList<String> findAllMediaTypePath(Context context, int position, int pagingSize) {
        ArrayList<String> allMediaPath = new ArrayList<String>();
        try {
            String[] stringArray = new String[]{"_id", "_data", "date_added", "media_type", "mime_type", "title"};
            String[] projection = stringArray;
            String selection = "media_type=1 OR media_type=3";
            String orderBy = "date_added";
            Cursor allMediaFilesCursor = context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, selection, null, Intrinsics.stringPlus((String)orderBy, (Object)" DESC"));
            int columnIndexData = 0;
            Cursor cursor = allMediaFilesCursor;
            if (cursor != null) {
                Cursor cursor2 = cursor;
                boolean bl = false;
                boolean bl2 = false;
                Cursor it = cursor2;
                boolean bl3 = false;
                it.moveToPosition(position - 1);
                int size = position - 1 + pagingSize;
                columnIndexData = it.getColumnIndexOrThrow("_data");
                while (it.getPosition() < size && it.moveToNext()) {
                    allMediaPath.add(it.getString(columnIndexData));
                }
            }
            cursor = allMediaFilesCursor;
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
        }
        return allMediaPath;
    }

    private final ArrayList<String> findAllDocumentPath(Context context, int position, int pagingSize) {
        ArrayList<String> allDocPath = new ArrayList<String>();
        try {
            String[] stringArray = new String[]{"_id", "_data", "mime_type", "date_added", "date_modified", "_display_name", "title", "_size"};
            String[] projection = stringArray;
            boolean bl = false;
            List mimeTypes = new ArrayList();
            Object[] objectArray = new String[]{"pdf", "doc", "docx", "csv", "xls", "xlsx", "ppt", "pptx", "zip", "txt"};
            List extensions = CollectionsKt.mutableListOf((Object[])objectArray);
            Iterable $this$forEach$iv = extensions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String mimeType = (String)element$iv;
                boolean bl2 = false;
                String string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(mimeType);
                if (string2 == null) continue;
                String string3 = string2;
                boolean bl3 = false;
                boolean bl4 = false;
                String it = string3;
                boolean bl5 = false;
                mimeTypes.add('\'' + it + '\'');
            }
            String selectionMimeType = "mime_type IN (" + CollectionsKt.joinToString$default((Iterable)mimeTypes, null, null, null, (int)0, null, null, (int)63, null) + ')';
            Cursor allDocumentFilesCursor = context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, selectionMimeType, null, "date_added");
            int columnIndexData = 0;
            Cursor cursor = allDocumentFilesCursor;
            if (cursor != null) {
                Cursor cursor2 = cursor;
                boolean bl6 = false;
                boolean bl7 = false;
                Cursor cursor3 = cursor2;
                boolean bl8 = false;
                cursor3.moveToPosition(position - 1);
                int size = position - 1 + pagingSize;
                columnIndexData = cursor3.getColumnIndexOrThrow("_data");
                while (cursor3.getPosition() < size && cursor3.moveToNext()) {
                    allDocPath.add(cursor3.getString(columnIndexData));
                }
            }
            cursor = allDocumentFilesCursor;
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
        }
        Logger.INSTANCE.d(Intrinsics.stringPlus((String)"2515: allDocPath = ", allDocPath), new Object[0]);
        return allDocPath;
    }

    public final long getDurationOfMediaByPath(@NotNull String path) {
        long l;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Long l2;
            String time;
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            try {
                retriever.setDataSource(path);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
            String string2 = time = retriever.extractMetadata(9);
            long duration = string2 == null ? 0L : ((l2 = StringsKt.toLongOrNull((String)string2)) == null ? 0L : l2);
            retriever.release();
            l = duration > 1000L ? duration / (long)1000 : 0L;
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
            Logger.INSTANCE.e(e.getMessage(), new Object[0]);
            l = 0L;
        }
        return l;
    }

    public final int getWidthOrHeightOfMediaByPath(@NotNull String path, boolean isWidth) {
        int n;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Integer n2;
            String metadata;
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            try {
                retriever.setDataSource(path);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
            int dataType = isWidth ? 18 : 19;
            String string2 = metadata = retriever.extractMetadata(dataType);
            int distance = string2 == null ? 0 : ((n2 = StringsKt.toIntOrNull((String)string2)) == null ? 0 : n2);
            retriever.release();
            n = distance;
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
            n = 0;
        }
        return n;
    }

    @Nullable
    public final Bitmap getBitmapFromLocalPath(@NotNull String localPath, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Ref.ObjectRef bitmap = new Ref.ObjectRef();
        Context context2 = context;
        if (context2 != null) {
            Context context3 = context2;
            boolean bl = false;
            boolean bl2 = false;
            Context it = context3;
            boolean bl3 = false;
            ImageUtilsKt.loadBitmapSync$default((Context)context, (Object)localPath, (Function1)((Function1)new Function1<Bitmap, Unit>((Ref.ObjectRef<Bitmap>)bitmap){
                final /* synthetic */ Ref.ObjectRef<Bitmap> $bitmap;
                {
                    this.$bitmap = $bitmap;
                    super(1);
                }

                public final void invoke(@Nullable Bitmap it) {
                    this.$bitmap.element = it;
                }
            }), (int)0, (int)8, null);
        }
        return (Bitmap)bitmap.element;
    }

    /*
     * Unable to fully structure code
     */
    public final void openFile(@NotNull Context context, @NotNull File file, @NotNull Function0<Unit> callback) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            try {
                block5: {
                    block8: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                block16: {
                                                    block15: {
                                                        block14: {
                                                            block13: {
                                                                block12: {
                                                                    block11: {
                                                                        block10: {
                                                                            block9: {
                                                                                block7: {
                                                                                    block6: {
                                                                                        v0 = uri = Build.VERSION.SDK_INT >= 24 ? UriUtils.file2Uri((File)file) : Uri.fromFile((File)file);
                                                                                        if (!ExtensionsUtilsKt.isNotNull((Object)uri)) break block5;
                                                                                        intent = new Intent("android.intent.action.VIEW");
                                                                                        var6_7 = file.toString();
                                                                                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                                                        if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".doc", (boolean)false, (int)2, null)) break block6;
                                                                                        var6_7 = file.toString();
                                                                                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                                                        if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".docx", (boolean)false, (int)2, null)) break block7;
                                                                                    }
                                                                                    intent.setDataAndType(uri, "application/msword");
                                                                                    break block8;
                                                                                }
                                                                                var6_7 = file.toString();
                                                                                Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                                                if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".pdf", (boolean)false, (int)2, null)) break block9;
                                                                                intent.setDataAndType(uri, "application/pdf");
                                                                                break block8;
                                                                            }
                                                                            var6_7 = file.toString();
                                                                            Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                                            if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".ppt", (boolean)false, (int)2, null)) break block10;
                                                                            var6_7 = file.toString();
                                                                            Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                                            if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".pptx", (boolean)false, (int)2, null)) break block11;
                                                                        }
                                                                        intent.setDataAndType(uri, "application/vnd.ms-powerpoint");
                                                                        break block8;
                                                                    }
                                                                    var6_7 = file.toString();
                                                                    Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                                    if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".xls", (boolean)false, (int)2, null)) break block12;
                                                                    var6_7 = file.toString();
                                                                    Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                                    if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".xlsx", (boolean)false, (int)2, null)) break block13;
                                                                }
                                                                intent.setDataAndType(uri, "application/vnd.ms-excel");
                                                                break block8;
                                                            }
                                                            var6_7 = file.toString();
                                                            Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                            if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".zip", (boolean)false, (int)2, null)) break block14;
                                                            intent.setDataAndType(uri, "application/zip");
                                                            break block8;
                                                        }
                                                        var6_7 = file.toString();
                                                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                        if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".rar", (boolean)false, (int)2, null)) break block15;
                                                        intent.setDataAndType(uri, "application/x-rar-compressed");
                                                        break block8;
                                                    }
                                                    var6_7 = file.toString();
                                                    Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                    if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".rtf", (boolean)false, (int)2, null)) break block16;
                                                    intent.setDataAndType(uri, "application/rtf");
                                                    break block8;
                                                }
                                                var6_7 = file.toString();
                                                Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".wav", (boolean)false, (int)2, null)) break block17;
                                                var6_7 = file.toString();
                                                Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                                if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".mp3", (boolean)false, (int)2, null)) break block18;
                                            }
                                            intent.setDataAndType(uri, "audio/x-wav");
                                            break block8;
                                        }
                                        var6_7 = file.toString();
                                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                        if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".gif", (boolean)false, (int)2, null)) break block19;
                                        intent.setDataAndType(uri, "image/gif");
                                        break block8;
                                    }
                                    var6_7 = file.toString();
                                    Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                    if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".jpg", (boolean)false, (int)2, null)) break block20;
                                    var6_7 = file.toString();
                                    Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                    if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".jpeg", (boolean)false, (int)2, null)) break block20;
                                    var6_7 = file.toString();
                                    Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                                    if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".png", (boolean)false, (int)2, null)) break block21;
                                }
                                intent.setDataAndType(uri, "image/jpeg");
                                break block8;
                            }
                            var6_7 = file.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                            if (!StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".txt", (boolean)false, (int)2, null)) break block22;
                            intent.setDataAndType(uri, "text/plain");
                            break block8;
                        }
                        var6_7 = file.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                        if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".3gp", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                        var6_7 = file.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                        if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".mpg", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                        var6_7 = file.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                        if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".mpeg", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                        var6_7 = file.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                        if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".mpe", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                        var6_7 = file.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                        if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".mp4", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                        var6_7 = file.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"file.toString()");
                        if (StringsKt.contains$default((CharSequence)var6_7, (CharSequence)".avi", (boolean)false, (int)2, null)) lbl-1000:
                        // 6 sources

                        {
                            intent.setDataAndType(uri, "video/*");
                        } else {
                            intent.setDataAndType(uri, "*/*");
                        }
                    }
                    intent.addFlags(1);
                    intent.addFlags(0x10000000);
                    context.startActivity(intent);
                    break block4;
                }
                Toast.makeText((Context)context, (CharSequence)"Error open this file.", (int)0).show();
            }
            catch (ActivityNotFoundException e) {
                FirebaseCrashlytics.getInstance().recordException((Throwable)e);
                Toast.makeText((Context)context, (CharSequence)"No application found which can open the file", (int)0).show();
            }
        }
    }

    @NotNull
    public final String copyFileToLocal(@NotNull String copyFilePath, @Nullable String fileName, boolean isTemp, boolean isSaveDocument, int type, @Nullable String extension) {
        String string2;
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)copyFilePath, (String)"copyFilePath");
        String fileFormat = this.getMediaType(type, extension);
        if (isTemp) {
            File tempDir = new File(tempFolder);
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            String cacheFileName = Intrinsics.stringPlus((String)"temp_file_", (Object)fileName);
            file2 = File.createTempFile(cacheFileName, fileFormat, tempDir);
        } else {
            File dir;
            File file3;
            if (isSaveDocument) {
                String string3;
                int n = type;
                switch (n) {
                    case 2: {
                        string3 = Environment.DIRECTORY_PICTURES;
                        break;
                    }
                    case 3: {
                        string3 = Environment.DIRECTORY_MUSIC;
                        break;
                    }
                    case 4: {
                        string3 = Environment.DIRECTORY_MOVIES;
                        break;
                    }
                    case 12: {
                        string3 = Environment.DIRECTORY_DOCUMENTS;
                        break;
                    }
                    default: {
                        string3 = Environment.DIRECTORY_DOWNLOADS;
                    }
                }
                file3 = Environment.getExternalStoragePublicDirectory((String)string3);
            } else {
                file3 = dir = new File(Intrinsics.stringPlus((String)Environment.getExternalStorageDirectory().getPath(), (Object)"/download_file"));
            }
            if (!dir.exists()) {
                dir.mkdirs();
            }
            file2 = file = new File(dir, AppUtils.INSTANCE.createDownloadFile(fileName, type, extension));
        }
        if (com.netacom.base.chat.android_utils.FileUtils.copy((File)com.netacom.base.chat.android_utils.FileUtils.getFileByPath((String)copyFilePath), (File)file)) {
            com.netacom.base.chat.android_utils.FileUtils.notifySystemToScan((File)file);
            String string4 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n            FileUtils.\u2026le.absolutePath\n        }");
            string2 = string4;
        } else {
            string2 = "";
        }
        return string2;
    }

    public static /* synthetic */ String copyFileToLocal$default(FileUtils fileUtils, String string2, String string3, boolean bl, boolean bl2, int n, String string4, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string3 = null;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            n = 12;
        }
        if ((n2 & 0x20) != 0) {
            string4 = null;
        }
        return fileUtils.copyFileToLocal(string2, string3, bl, bl2, n, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String saveFileToLocal(@Nullable ResponseBody body, @Nullable String fileName, boolean isTemp, boolean isSaveDocument, int type, @Nullable String extension) {
        File file;
        if (body == null) {
            return "";
        }
        String fileFormat = this.getMediaType(type, extension);
        Logger.INSTANCE.d(Intrinsics.stringPlus((String)"AAA isTempFile in saveFileToLocal = ", (Object)isTemp), new Object[0]);
        if (isTemp) {
            File tempDir = new File(tempFolder);
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            String cacheFileName = Intrinsics.stringPlus((String)"temp_file_", (Object)fileName);
            file = File.createTempFile(cacheFileName, fileFormat, tempDir);
        } else {
            File dir;
            File file2;
            if (isSaveDocument) {
                String string2;
                int cacheFileName = type;
                switch (cacheFileName) {
                    case 2: {
                        string2 = Environment.DIRECTORY_PICTURES;
                        break;
                    }
                    case 3: {
                        string2 = Environment.DIRECTORY_MUSIC;
                        break;
                    }
                    case 4: {
                        string2 = Environment.DIRECTORY_MOVIES;
                        break;
                    }
                    case 12: {
                        string2 = Environment.DIRECTORY_DOCUMENTS;
                        break;
                    }
                    default: {
                        string2 = Environment.DIRECTORY_DOWNLOADS;
                    }
                }
                file2 = Environment.getExternalStoragePublicDirectory((String)string2);
            } else {
                file2 = dir = com.netacom.base.chat.android_utils.FileUtils.getFileByPath((String)Intrinsics.stringPlus((String)Environment.getExternalStorageDirectory().getPath(), (Object)"/download_file"));
            }
            if (Build.VERSION.SDK_INT >= 30) {
                file = new File(dir, AppUtils.INSTANCE.createDownloadFile(fileName, type, extension));
            } else {
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                file = new File(dir, AppUtils.INSTANCE.createDownloadFile(fileName, type, extension));
            }
        }
        File file3 = file;
        InputStream inputStream = body.byteStream();
        try {
            boolean isWriteFile = FileIOUtils.writeFileFromIS((File)file3, (InputStream)inputStream);
            com.netacom.base.chat.android_utils.FileUtils.notifySystemToScan((File)file3);
            Logger.INSTANCE.d(Intrinsics.stringPlus((String)"isWriteFile = ", (Object)isWriteFile), new Object[0]);
            String string3 = file3.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.absolutePath");
            return string3;
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
        }
        finally {
            body.close();
            inputStream.close();
        }
        return "";
    }

    public static /* synthetic */ String saveFileToLocal$default(FileUtils fileUtils, ResponseBody responseBody2, String string2, boolean bl, boolean bl2, int n, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            n = 12;
        }
        if ((n2 & 0x20) != 0) {
            string3 = null;
        }
        return fileUtils.saveFileToLocal(responseBody2, string2, bl, bl2, n, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String saveEncryptedFileToLocal(@NotNull ResponseBody body, @NotNull String path, @NotNull String fileName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File dir = new File(path);
        com.netacom.base.chat.android_utils.FileUtils.createOrExistsDir((File)dir);
        File file = new File(dir, fileName);
        InputStream inputStream = body.byteStream();
        try {
            FileIOUtils.writeFileFromBytesByStream((File)file, (byte[])ChatSecretUtils.INSTANCE.decryptFileInput(ByteStreamsKt.readBytes((InputStream)inputStream)));
            string2 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            FileIOUtil\u2026le.absolutePath\n        }");
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
            String string3 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            FirebaseCr\u2026le.absolutePath\n        }");
            string2 = string3;
        }
        finally {
            body.close();
            inputStream.close();
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalFileModel> getAllLocalMediaFiles(@NotNull Context context, int position, int pagingSize) {
        boolean hasPermissionStore;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean bl = false;
        List allMediaFile = new ArrayList();
        boolean bl2 = hasPermissionStore = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
        if (hasPermissionStore) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.findAllMediaTypePath(context, position, pagingSize);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                MediaType mediaType;
                void path;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                File file = com.netacom.base.chat.android_utils.FileUtils.getFileByPath((String)path);
                LocalFileModel localFileModel = new LocalFileModel((String)path, null, null, 0L, 0L, null, 0L, null, null, null, null, null, 0, 0L, null, false, null, 131070, null);
                boolean bl4 = false;
                boolean bl5 = false;
                LocalFileModel $this$getAllLocalMediaFiles_u24lambda_u2d7_u24lambda_u2d6 = localFileModel;
                boolean bl6 = false;
                if (StringsKt.endsWith$default((String)path, (String)".mp4", (boolean)false, (int)2, null)) {
                    $this$getAllLocalMediaFiles_u24lambda_u2d7_u24lambda_u2d6.setFileDuration(INSTANCE.getDurationOfMediaByPath((String)path));
                    mediaType = MediaType.VIDEO;
                } else {
                    mediaType = MediaType.PHOTO;
                }
                $this$getAllLocalMediaFiles_u24lambda_u2d7_u24lambda_u2d6.setFileType(mediaType);
                $this$getAllLocalMediaFiles_u24lambda_u2d7_u24lambda_u2d6.setFileSize(com.netacom.base.chat.android_utils.FileUtils.getFileLength((String)path));
                $this$getAllLocalMediaFiles_u24lambda_u2d7_u24lambda_u2d6.setFileSizeText(ConvertUtil.INSTANCE.convertSize($this$getAllLocalMediaFiles_u24lambda_u2d7_u24lambda_u2d6.getFileSize()));
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                $this$getAllLocalMediaFiles_u24lambda_u2d7_u24lambda_u2d6.setFileExtension(FilesKt.getExtension((File)file));
                $this$getAllLocalMediaFiles_u24lambda_u2d7_u24lambda_u2d6.setDateAdded(file.lastModified());
                $this$getAllLocalMediaFiles_u24lambda_u2d7_u24lambda_u2d6.setFileName(FilesKt.getNameWithoutExtension((File)file));
                LocalFileModel localMedia = localFileModel;
                Boolean bl7 = allMediaFile.add(localMedia);
                collection.add(bl7);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        return allMediaFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalFileModel> getAllLocalDocumentFiles(@NotNull Context context, int position, int pagingSize) {
        boolean hasPermissionStore;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean bl = false;
        List allMediaFile = new ArrayList();
        boolean bl2 = hasPermissionStore = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
        if (hasPermissionStore) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.findAllDocumentPath(context, position, pagingSize);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                File file = com.netacom.base.chat.android_utils.FileUtils.getFileByPath((String)path);
                LocalFileModel localFileModel = new LocalFileModel((String)path, null, null, 0L, 0L, null, 0L, null, null, null, null, null, 0, 0L, null, false, null, 131070, null);
                boolean bl4 = false;
                boolean bl5 = false;
                LocalFileModel $this$getAllLocalDocumentFiles_u24lambda_u2d9_u24lambda_u2d8 = localFileModel;
                boolean bl6 = false;
                $this$getAllLocalDocumentFiles_u24lambda_u2d9_u24lambda_u2d8.setFileType(MediaType.FILE);
                $this$getAllLocalDocumentFiles_u24lambda_u2d9_u24lambda_u2d8.setFileSize(com.netacom.base.chat.android_utils.FileUtils.getFileLength((String)path));
                $this$getAllLocalDocumentFiles_u24lambda_u2d9_u24lambda_u2d8.setFileSizeText(ConvertUtil.INSTANCE.convertSize($this$getAllLocalDocumentFiles_u24lambda_u2d9_u24lambda_u2d8.getFileSize()));
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                $this$getAllLocalDocumentFiles_u24lambda_u2d9_u24lambda_u2d8.setFileExtension(FilesKt.getExtension((File)file));
                $this$getAllLocalDocumentFiles_u24lambda_u2d9_u24lambda_u2d8.setDateAdded(file.lastModified());
                $this$getAllLocalDocumentFiles_u24lambda_u2d9_u24lambda_u2d8.setFileName(FilesKt.getNameWithoutExtension((File)file));
                $this$getAllLocalDocumentFiles_u24lambda_u2d9_u24lambda_u2d8.setFileDuration(0L);
                LocalFileModel localMedia = localFileModel;
                Boolean bl7 = allMediaFile.add(localMedia);
                collection.add(bl7);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        return allMediaFile;
    }

    @NotNull
    public final String getDocumentMimeType(@NotNull File file) {
        block34: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            try {
                String string2;
                String extension = FilesKt.getExtension((File)file);
                CharSequence charSequence = extension;
                boolean bl = false;
                if (!(charSequence.length() > 0)) break block34;
                switch (extension) {
                    case "doc": {
                        string2 = "application/msword";
                        break;
                    }
                    case "docx": {
                        string2 = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
                        break;
                    }
                    case "xls": {
                        string2 = "application/vnd.ms-excel";
                        break;
                    }
                    case "xlsx": {
                        string2 = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                        break;
                    }
                    case "ppt": {
                        string2 = "application/vnd.ms-powerpoint";
                        break;
                    }
                    case "pptx": {
                        string2 = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
                        break;
                    }
                    case "pdf": {
                        string2 = "application/pdf";
                        break;
                    }
                    case "zip": {
                        string2 = "application/zip";
                        break;
                    }
                    case "txt": {
                        string2 = "text/plain";
                        break;
                    }
                    default: {
                        String string3;
                        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
                        String string4 = extension;
                        int n = 1;
                        boolean bl2 = false;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                        String string7 = mimeTypeMap.getMimeTypeFromExtension(string6);
                        string2 = string3 = string7 == null ? "" : string7;
                    }
                }
                return string2;
            }
            catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException((Throwable)e);
                e.printStackTrace();
            }
        }
        return "";
    }

    @NotNull
    public final LocalFileModel getLocalFileByPath(@NotNull String path, @NotNull MediaType type, boolean isLocal) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        File file = com.netacom.base.chat.android_utils.FileUtils.getFileByPath((String)path);
        LocalFileModel localFileModel = new LocalFileModel(path, null, null, 0L, 0L, null, 0L, null, null, null, null, null, 0, 0L, null, false, null, 131070, null);
        boolean bl = false;
        boolean bl2 = false;
        LocalFileModel $this$getLocalFileByPath_u24lambda_u2d10 = localFileModel;
        boolean bl3 = false;
        if (type == MediaType.VIDEO || type == MediaType.AUDIO) {
            $this$getLocalFileByPath_u24lambda_u2d10.setFileDuration(INSTANCE.getDurationOfMediaByPath(path));
        } else {
            $this$getLocalFileByPath_u24lambda_u2d10.setFileDuration(0L);
        }
        $this$getLocalFileByPath_u24lambda_u2d10.setFileType(type);
        $this$getLocalFileByPath_u24lambda_u2d10.setFileSize(isLocal ? com.netacom.base.chat.android_utils.FileUtils.getLocalFileLength((String)path) : com.netacom.base.chat.android_utils.FileUtils.getFileLength((String)path));
        $this$getLocalFileByPath_u24lambda_u2d10.setFileSizeText(ConvertUtil.INSTANCE.convertSize($this$getLocalFileByPath_u24lambda_u2d10.getFileSize()));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        $this$getLocalFileByPath_u24lambda_u2d10.setFileExtension(FilesKt.getExtension((File)file));
        $this$getLocalFileByPath_u24lambda_u2d10.setDateAdded(file.lastModified());
        $this$getLocalFileByPath_u24lambda_u2d10.setFileName(FilesKt.getNameWithoutExtension((File)file));
        return localFileModel;
    }

    public static /* synthetic */ LocalFileModel getLocalFileByPath$default(FileUtils fileUtils, String string2, MediaType mediaType, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return fileUtils.getLocalFileByPath(string2, mediaType, bl);
    }

    public final boolean isFolderEmpty(@NotNull String path) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        if (file.isDirectory()) {
            String[] list;
            String[] stringArray = file.list();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"file.list()");
            stringArray = list = stringArray;
            boolean bl2 = false;
            bl = stringArray.length == 0;
        } else {
            bl = true;
        }
        return bl;
    }

    @Nullable
    public final String isCacheFileDownloaded(@NotNull String fileName, int fileType, @Nullable String extension) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File tempDir = new File(tempFolder);
        String fileFormat = this.getMediaType(fileType, extension);
        String cacheFileName = Intrinsics.stringPlus((String)"temp_file_", (Object)fileName);
        String path = tempDir + cacheFileName + fileFormat;
        return com.netacom.base.chat.android_utils.FileUtils.isFileExists((String)path) ? path : null;
    }

    public static /* synthetic */ String isCacheFileDownloaded$default(FileUtils fileUtils, String string2, int n, String string3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        return fileUtils.isCacheFileDownloaded(string2, n, string3);
    }

    @NotNull
    public final String getMediaType(int fileType, @Nullable String extension) {
        String string2;
        int n = fileType;
        switch (n) {
            case 2: {
                string2 = "png";
                break;
            }
            case 4: {
                string2 = "mp4";
                break;
            }
            case 3: {
                string2 = "wav";
                break;
            }
            case 12: {
                if (extension != null) {
                    CharSequence charSequence = extension;
                    boolean bl = false;
                    if (!StringsKt.isBlank((CharSequence)charSequence)) {
                        string2 = Intrinsics.stringPlus((String)".", (Object)extension);
                        break;
                    }
                }
                string2 = "tmp";
                break;
            }
            default: {
                string2 = "tmp";
            }
        }
        return string2;
    }

    public static /* synthetic */ String getMediaType$default(FileUtils fileUtils, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        return fileUtils.getMediaType(n, string2);
    }

    public final boolean isContainsExtensionFromName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String extension = StringsKt.substringAfterLast((String)fileName, (String)".", (String)"");
        CharSequence charSequence = extension;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            return supportExtension.contains(extension);
        }
        return false;
    }

    @NotNull
    public final FolderStatus folderIsEmptyOrNull(@NotNull String folderPath) {
        FolderStatus folderStatus;
        Intrinsics.checkNotNullParameter((Object)folderPath, (String)"folderPath");
        File directory = new File(folderPath);
        File[] contents = directory.listFiles();
        if (contents == null) {
            Logger.INSTANCE.e("2513 - folderIsNull", new Object[0]);
            folderStatus = FolderStatus.NULL;
        } else {
            File[] fileArray = contents;
            boolean bl = false;
            if (fileArray.length == 0) {
                Logger.INSTANCE.e("2513 - folderIsEmpty", new Object[0]);
                folderStatus = FolderStatus.EMPTY;
            } else {
                folderStatus = FolderStatus.EXISTS;
            }
        }
        return folderStatus;
    }

    static {
        Object[] objectArray = new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx", "zip", "rar", "rtf", "wav", "mp4", "mp3", "jpg", "jpeg", "txt", "gif", "3gp", "mpg", "mpe", "avi"};
        supportExtension = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/netacom/lite/util/FileUtils$FolderStatus;", "", "(Ljava/lang/String;I)V", "NULL", "EMPTY", "EXISTS", "netacom-sdk-lite_NetAloDevRelease"})
    public static final class FolderStatus
    extends Enum<FolderStatus> {
        public static final /* enum */ FolderStatus NULL = new FolderStatus();
        public static final /* enum */ FolderStatus EMPTY = new FolderStatus();
        public static final /* enum */ FolderStatus EXISTS = new FolderStatus();
        private static final /* synthetic */ FolderStatus[] $VALUES;

        public static FolderStatus[] values() {
            return (FolderStatus[])$VALUES.clone();
        }

        public static FolderStatus valueOf(String value) {
            return Enum.valueOf(FolderStatus.class, value);
        }

        static {
            $VALUES = folderStatusArray = new FolderStatus[]{FolderStatus.NULL, FolderStatus.EMPTY, FolderStatus.EXISTS};
        }
    }
}

