/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.widget.countdown;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.netacom.full.R;

public class TickTockView
extends View {
    private Paint mFillPaint = new Paint(1);
    private Paint mEmptyPaint = new Paint(1);
    private Paint mMiddlePaint = new Paint(1);
    private Paint mTextPaint = new Paint(1);
    private RectF mArc = new RectF();
    private Point mCenter = new Point();
    private Canvas mCanvas;
    private Bitmap mCanvasBitmap;
    private Matrix mMatrix = new Matrix();
    private float mRingRadius = 100.0f;
    private float mRingThickness = 3.0f;
    private float mDotRadius = 6.0f;
    private long mTimeRemaining = 0L;
    private float mTextPadding = 16.0f;
    private Rect mTextBounds = new Rect();
    private CharSequence mText = null;
    private int mEmptyRingColor = -1;
    private int mFillRingColor = -16776961;
    private int mMiddleColor = 0;
    private int mTextColor = -16776961;
    private float mTextSize = 80.0f;
    private boolean mCounterClockwise = false;
    private boolean mAutoFitText = true;
    private OnTickListener mTickListener;
    private final int DURATION_MINUTE = 0;
    private final int DURATION_TOTAL = 1;
    private int mCircleDuration = 0;
    private long mStartTime = 0L;
    private long mEndTime = 0L;
    private CountDownTimer mTimer = null;

    public TickTockView(Context context) {
        super(context);
        this.init(context, null);
    }

    public TickTockView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public TickTockView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public TickTockView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        float multi = context.getResources().getDisplayMetrics().density;
        this.mRingRadius *= multi;
        this.mRingThickness *= multi;
        this.mDotRadius *= multi;
        this.mTextPadding *= multi;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.TickTockView, 0, 0);
        try {
            this.mEmptyRingColor = ta.getColor(R.styleable.TickTockView_tickEmptyRingColor, this.mEmptyRingColor);
            this.mFillRingColor = ta.getColor(R.styleable.TickTockView_tickFillRingColor, this.mFillRingColor);
            this.mMiddleColor = ta.getColor(R.styleable.TickTockView_tickMiddleColor, this.mMiddleColor);
            this.mTextColor = ta.getColor(R.styleable.TickTockView_tickTextColor, this.mTextColor);
            this.mRingThickness = ta.getDimension(R.styleable.TickTockView_tickRingThickness, this.mRingThickness);
            this.mDotRadius = ta.getDimension(R.styleable.TickTockView_tickDotRadius, this.mDotRadius);
            this.mTextSize = ta.getDimension(R.styleable.TickTockView_tickTextSize, this.mTextSize);
            this.mText = ta.getText(R.styleable.TickTockView_tickText);
            this.mAutoFitText = ta.getBoolean(R.styleable.TickTockView_tickAutoFitText, this.mAutoFitText);
            this.mCounterClockwise = ta.getBoolean(R.styleable.TickTockView_tickMoveCounterClockwise, this.mCounterClockwise);
            this.mCircleDuration = ta.getInt(R.styleable.TickTockView_tickCircleDuration, this.mCircleDuration);
        }
        finally {
            ta.recycle();
        }
        this.mEmptyPaint.setColor(this.mEmptyRingColor);
        this.mFillPaint.setColor(this.mFillRingColor);
        this.mFillPaint.setStrokeWidth(this.mRingThickness);
        this.mEmptyPaint.setStrokeWidth(this.mRingThickness);
        this.mMiddlePaint.setColor(this.mMiddleColor);
        if (this.mMiddleColor == 0) {
            this.mMiddlePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        }
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setTextSize(this.mTextSize);
        if (this.isInEditMode()) {
            this.fitText(this.mText);
        }
        this.calculateEverything();
    }

    private void calculateEverything() {
        this.calculateCenter();
        this.calculateArc();
    }

    private void drawInitialCircle() {
        if (this.mCanvas == null || this.mCanvasBitmap.getWidth() != this.getWidth() || this.mCanvasBitmap.getHeight() != this.getHeight()) {
            if (this.mCanvasBitmap != null) {
                this.mCanvas = null;
                this.mCanvasBitmap.recycle();
                this.mCanvasBitmap = null;
            }
            this.mCanvasBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCanvas = new Canvas(this.mCanvasBitmap);
        }
        this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.mCanvas.drawCircle((float)this.mCenter.x, (float)this.mCenter.y, this.mRingRadius, this.mEmptyPaint);
    }

    private void calculateCenter() {
        this.mCenter.x = (this.getWidth() + this.getPaddingLeft() - this.getPaddingRight()) / 2;
        this.mCenter.y = (this.getHeight() + this.getPaddingTop() - this.getPaddingBottom()) / 2;
    }

    private void calculateArc() {
        this.mArc.left = (float)this.mCenter.x - this.mRingRadius;
        this.mArc.top = (float)this.mCenter.y - this.mRingRadius;
        this.mArc.right = (float)this.mCenter.x + this.mRingRadius;
        this.mArc.bottom = (float)this.mCenter.y + this.mRingRadius;
    }

    public void setSosColor() {
        int color2 = ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_red_d31027);
        int subColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_red_66d31027);
        this.mEmptyPaint.setColor(subColor);
        this.mFillPaint.setColor(color2);
    }

    public void setNormalColor(int color2, int subColor) {
        this.mEmptyPaint.setColor(subColor);
        this.mFillPaint.setColor(color2);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.calculateEverything();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mRingRadius = (float)((this.getMeasuredWidth() - this.getPaddingLeft()) / 2) - this.mDotRadius;
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            this.fitText(this.mText);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawInitialCircle();
        this.calculateArc();
        long ms = this.isInEditMode() ? System.currentTimeMillis() % 60000L : this.mTimeRemaining % 60000L;
        float angle = (float)((double)ms * 0.006);
        if (this.mCircleDuration == 1 && this.mStartTime != 0L) {
            long totalTime = this.mEndTime - this.mStartTime;
            float percentage = (float)this.mTimeRemaining / 1000.0f / (float)totalTime;
            angle = 360.0f * percentage;
        }
        if (this.isInEditMode()) {
            angle *= -1.0f;
        }
        if (!this.mCounterClockwise) {
            this.mCanvas.drawArc(this.mArc, 270.0f, angle, true, this.mFillPaint);
        } else {
            this.mCanvas.drawArc(this.mArc, 270.0f, 360.0f - angle, true, this.mFillPaint);
        }
        this.mCanvas.drawCircle((float)this.mCenter.x, (float)this.mCenter.y, this.mRingRadius - this.mRingThickness, this.mMiddlePaint);
        if (!this.mCounterClockwise) {
            this.mMatrix.setRotate(-angle, (float)(this.mCanvas.getWidth() / 2), (float)(this.mCanvas.getHeight() / 2));
        } else {
            this.mMatrix.setRotate(angle, (float)(this.mCanvas.getWidth() / 2), (float)(this.mCanvas.getHeight() / 2));
        }
        canvas.drawBitmap(this.mCanvasBitmap, this.mMatrix, this.mEmptyPaint);
        if (this.isInEditMode()) {
            this.mTimeRemaining = System.currentTimeMillis();
        }
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            canvas.drawText(this.mText.toString(), (float)(this.getWidth() / 2 - this.mTextBounds.width() / 2), (float)(this.getHeight() / 2 + this.mTextBounds.height() / 2), this.mTextPaint);
        }
    }

    private void drawDot() {
        float centerX = this.mCanvas.getWidth() / 2;
        float centerY = this.mDotRadius + this.mRingThickness / 2.0f;
        this.mCanvas.drawCircle(centerX, centerY, this.mDotRadius, this.mFillPaint);
    }

    public void start(long endTime) {
        if (endTime == 0L) {
            throw new IllegalArgumentException("endTime cannot be null and must be in the future");
        }
        if (!TextUtils.isEmpty((CharSequence)this.mText) && (this.mTextBounds.width() == 0 || this.mTextBounds.height() == 0) && this.mTextSize > 0.0f) {
            this.fitText(this.mText);
        }
        this.mEndTime = endTime;
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new CountDownTimer(endTime * 1000L - System.currentTimeMillis(), 500L){

            public void onTick(long millisUntilFinished) {
                TickTockView.this.mTimeRemaining = millisUntilFinished;
                TickTockView.this.updateText(TickTockView.this.mTimeRemaining);
                TickTockView.this.invalidate();
            }

            public void onFinish() {
                TickTockView.this.updateText(0L);
                TickTockView.this.invalidate();
            }
        }.start();
    }

    public void start(long startTime, long endTime) {
        if (startTime == 0L || endTime == 0L || startTime > endTime) {
            return;
        }
        this.mStartTime = startTime;
        this.start(endTime);
    }

    private void updateText(long timeRemaining) {
        if (this.mTickListener != null) {
            this.mTickListener.onTick(timeRemaining);
        }
    }

    public void stop() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mStartTime = 0L;
        this.mEndTime = 0L;
    }

    private void fitText(CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (this.mAutoFitText) {
            float textWidth = this.mFillPaint.measureText(text.toString());
            float multi = (this.mRingRadius * 2.0f - this.mTextPadding * 2.0f) / textWidth;
            this.mTextPaint.setTextSize(this.mFillPaint.getTextSize() * multi);
        }
        this.mTextPaint.getTextBounds(this.mText.toString(), 0, this.mText.length(), this.mTextBounds);
    }

    protected void onDetachedFromWindow() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        super.onDetachedFromWindow();
    }

    public void setOnTickListener(OnTickListener l) {
        this.mTickListener = l;
    }

    public static interface OnTickListener {
        public void onTick(long var1);

        public void onFinish();
    }
}

