/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.firebase;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import androidx.fragment.app.Fragment;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.netacom.base.chat.logger.Logger;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.full.firebase.LocationTrackerHelper;
import com.netacom.full.firebase.SensorDataUpdateCallback;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\f\u001a\u00020\r2\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\u0019\u001a\u00020\r2\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0014\u0010\u001a\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\bJ \u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007J\u000e\u0010 \u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/netacom/full/firebase/LocationTrackerHelper;", "", "()V", "locationCallback", "Lcom/google/android/gms/location/LocationCallback;", "locationRequest", "Lcom/google/android/gms/location/LocationRequest;", "locationUpdateCallback", "Lcom/netacom/full/firebase/SensorDataUpdateCallback;", "Landroid/location/Location;", "mFusedLocationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "getLastLocation", "", "onSuccess", "Lkotlin/Function1;", "context", "Landroid/content/Context;", "getLocationEnableDialog", "activity", "Landroid/app/Activity;", "requestCode", "", "fragment", "Landroidx/fragment/app/Fragment;", "requestSingleLocation", "setOnChangeListener", "callback", "startReceivingLocationUpdate", "applicationContext", "looper", "Landroid/os/Looper;", "stopReceivingLocationUpdates", "netacom-sdk-full_NetAloDevRelease"})
public final class LocationTrackerHelper {
    @NotNull
    public static final LocationTrackerHelper INSTANCE = new LocationTrackerHelper();
    @Nullable
    private static FusedLocationProviderClient mFusedLocationClient;
    @Nullable
    private static LocationCallback locationCallback;
    @Nullable
    private static LocationRequest locationRequest;
    @Nullable
    private static SensorDataUpdateCallback<Location> locationUpdateCallback;

    private LocationTrackerHelper() {
    }

    public final void setOnChangeListener(@NotNull SensorDataUpdateCallback<Location> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        locationUpdateCallback = callback;
    }

    @SuppressLint(value={"MissingPermission"})
    public final void startReceivingLocationUpdate(@NotNull Context applicationContext, @NotNull Looper looper, @NotNull LocationCallback locationCallback2) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
        Intrinsics.checkNotNullParameter((Object)locationCallback2, (String)"locationCallback");
        mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Context)applicationContext);
        try {
            FusedLocationProviderClient fusedLocationProviderClient = mFusedLocationClient;
            Intrinsics.checkNotNull((Object)fusedLocationProviderClient);
            fusedLocationProviderClient.requestLocationUpdates(locationRequest, locationCallback2, looper);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public final void stopReceivingLocationUpdates(@NotNull LocationCallback locationCallback2) {
        Intrinsics.checkNotNullParameter((Object)locationCallback2, (String)"locationCallback");
        if (mFusedLocationClient != null) {
            FusedLocationProviderClient fusedLocationProviderClient = mFusedLocationClient;
            Intrinsics.checkNotNull((Object)fusedLocationProviderClient);
            fusedLocationProviderClient.removeLocationUpdates(locationCallback2);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public final void getLastLocation(@NotNull Function1<? super Location, Unit> onSuccess, @NotNull Context context) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (ExtensionsUtilsKt.isNull((Object)mFusedLocationClient)) {
            mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Context)context);
        }
        FusedLocationProviderClient fusedLocationProviderClient = mFusedLocationClient;
        Intrinsics.checkNotNull((Object)fusedLocationProviderClient);
        fusedLocationProviderClient.getLastLocation().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Location>(onSuccess){
            final /* synthetic */ Function1<Location, Unit> $onSuccess;
            {
                this.$onSuccess = $onSuccess;
            }

            public final void onSuccess(Location it) {
                this.$onSuccess.invoke((Object)it);
            }
        }).addOnFailureListener(new OnFailureListener(onSuccess){
            final /* synthetic */ Function1<Location, Unit> $onSuccess;
            {
                this.$onSuccess = $onSuccess;
            }

            public final void onFailure(Exception it) {
                this.$onSuccess.invoke(null);
                Logger.INSTANCE.e(Intrinsics.stringPlus((String)"last location exception == ", (Object)it), new Object[0]);
            }
        });
    }

    public static /* synthetic */ void getLastLocation$default(LocationTrackerHelper locationTrackerHelper, Function1 function1, Context context, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = getLastLocation.1.INSTANCE;
        }
        locationTrackerHelper.getLastLocation((Function1<? super Location, Unit>)function1, context);
    }

    @SuppressLint(value={"MissingPermission"})
    public final void requestSingleLocation(@NotNull Function1<? super Location, Unit> onSuccess, @NotNull Context context) {
        Task task;
        FusedLocationProviderClient fusedLocationProviderClient;
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (ExtensionsUtilsKt.isNull((Object)mFusedLocationClient)) {
            mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Context)context);
        }
        if ((fusedLocationProviderClient = mFusedLocationClient) != null && (task = fusedLocationProviderClient.getLastLocation()) != null) {
            task.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Location>(onSuccess){
                final /* synthetic */ Function1<Location, Unit> $onSuccess;
                {
                    this.$onSuccess = $onSuccess;
                }

                public final void onSuccess(Location it) {
                    block2: {
                        Function1<Location, Unit> function1;
                        Function1<Location, Unit> function12;
                        Function1<Location, Unit> function13 = it;
                        if (function13 == null) {
                            function12 = null;
                        } else {
                            Function1<Location, Unit> function14 = function13;
                            Function1<Location, Unit> function15 = this.$onSuccess;
                            boolean bl = false;
                            boolean bl2 = false;
                            Function1<Location, Unit> $this$onSuccess_u24lambda_u2d0 = function14;
                            boolean bl3 = false;
                            function15.invoke($this$onSuccess_u24lambda_u2d0);
                            function12 = function1 = function14;
                        }
                        if (function1 != null) break block2;
                        function13 = this.$onSuccess;
                        boolean bl = false;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        FusedLocationProviderClient fusedLocationProviderClient = LocationTrackerHelper.access$getMFusedLocationClient$p();
                        Intrinsics.checkNotNull((Object)fusedLocationProviderClient);
                        fusedLocationProviderClient.requestLocationUpdates(LocationTrackerHelper.access$getLocationRequest$p(), new LocationCallback(function13){
                            final /* synthetic */ Function1<Location, Unit> $onSuccess;
                            {
                                this.$onSuccess = $onSuccess;
                            }

                            public void onLocationResult(@NotNull LocationResult locationResult) {
                                Intrinsics.checkNotNullParameter((Object)locationResult, (String)"locationResult");
                                this.$onSuccess.invoke((Object)locationResult.getLastLocation());
                                FusedLocationProviderClient fusedLocationProviderClient = LocationTrackerHelper.access$getMFusedLocationClient$p();
                                Intrinsics.checkNotNull((Object)fusedLocationProviderClient);
                                fusedLocationProviderClient.removeLocationUpdates((LocationCallback)this);
                            }
                        }, Looper.myLooper());
                    }
                }
            });
        }
    }

    public static /* synthetic */ void requestSingleLocation$default(LocationTrackerHelper locationTrackerHelper, Function1 function1, Context context, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = requestSingleLocation.1.INSTANCE;
        }
        locationTrackerHelper.requestSingleLocation((Function1<? super Location, Unit>)function1, context);
    }

    public final void getLocationEnableDialog(@NotNull Activity activity, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        locationRequest = new LocationRequest();
        LocationRequest locationRequest = LocationTrackerHelper.locationRequest;
        Intrinsics.checkNotNull((Object)locationRequest);
        locationRequest.setSmallestDisplacement(100.0f);
        locationRequest = LocationTrackerHelper.locationRequest;
        Intrinsics.checkNotNull((Object)locationRequest);
        locationRequest.setPriority(100);
        locationRequest = LocationTrackerHelper.locationRequest;
        if (locationRequest != null) {
            LocationRequest locationRequest2 = locationRequest;
            boolean bl = false;
            boolean bl2 = false;
            LocationRequest _locationRequest = locationRequest2;
            boolean bl3 = false;
            LocationSettingsRequest.Builder locationBuilder = new LocationSettingsRequest.Builder().addLocationRequest(_locationRequest);
            locationBuilder.setAlwaysShow(true);
            Task result2 = LocationServices.getSettingsClient((Activity)activity).checkLocationSettings(locationBuilder.build());
            result2.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<LocationSettingsResponse>(activity, requestCode){
                final /* synthetic */ Activity $activity;
                final /* synthetic */ int $requestCode;
                {
                    this.$activity = $activity;
                    this.$requestCode = $requestCode;
                }

                public final void onComplete(Task<LocationSettingsResponse> it) {
                    Exception exception;
                    if (!it.isSuccessful() && (exception = it.getException()) != null) {
                        Exception exception2 = exception;
                        Activity activity = this.$activity;
                        int n = this.$requestCode;
                        boolean bl = false;
                        boolean bl2 = false;
                        Exception exception3 = exception2;
                        boolean bl3 = false;
                        if (exception3 instanceof ApiException && ((ApiException)exception3).getStatusCode() == 6) {
                            ((ResolvableApiException)exception3).startResolutionForResult(activity, n);
                        }
                    }
                }
            });
        }
    }

    public final void getLocationEnableDialog(@NotNull Fragment fragment, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        locationRequest = new LocationRequest();
        LocationRequest locationRequest = LocationTrackerHelper.locationRequest;
        Intrinsics.checkNotNull((Object)locationRequest);
        locationRequest.setSmallestDisplacement(100.0f);
        locationRequest = LocationTrackerHelper.locationRequest;
        Intrinsics.checkNotNull((Object)locationRequest);
        locationRequest.setPriority(100);
        locationRequest = LocationTrackerHelper.locationRequest;
        if (locationRequest != null) {
            LocationRequest locationRequest2 = locationRequest;
            boolean bl = false;
            boolean bl2 = false;
            LocationRequest _locationRequest = locationRequest2;
            boolean bl3 = false;
            LocationSettingsRequest.Builder locationBuilder = new LocationSettingsRequest.Builder().addLocationRequest(_locationRequest);
            locationBuilder.setAlwaysShow(true);
            Task result2 = LocationServices.getSettingsClient((Context)fragment.requireContext()).checkLocationSettings(locationBuilder.build());
            result2.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<LocationSettingsResponse>(fragment, requestCode){
                final /* synthetic */ Fragment $fragment;
                final /* synthetic */ int $requestCode;
                {
                    this.$fragment = $fragment;
                    this.$requestCode = $requestCode;
                }

                public final void onComplete(Task<LocationSettingsResponse> it) {
                    Exception exception;
                    if (!it.isSuccessful() && (exception = it.getException()) != null) {
                        Exception exception2 = exception;
                        Fragment fragment = this.$fragment;
                        int n = this.$requestCode;
                        boolean bl = false;
                        boolean bl2 = false;
                        Exception exception3 = exception2;
                        boolean bl3 = false;
                        if (exception3 instanceof ApiException && ((ApiException)exception3).getStatusCode() == 6) {
                            fragment.startIntentSenderForResult(((ApiException)exception3).getStatus().getResolution().getIntentSender(), n, null, 0, 0, 0, null);
                        }
                    }
                }
            });
        }
    }

    public static final /* synthetic */ FusedLocationProviderClient access$getMFusedLocationClient$p() {
        return mFusedLocationClient;
    }

    public static final /* synthetic */ LocationRequest access$getLocationRequest$p() {
        return locationRequest;
    }

    static {
        locationRequest = new LocationRequest();
        LocationRequest locationRequest = LocationTrackerHelper.locationRequest;
        Intrinsics.checkNotNull((Object)locationRequest);
        locationRequest.setSmallestDisplacement(100.0f);
        locationRequest = LocationTrackerHelper.locationRequest;
        Intrinsics.checkNotNull((Object)locationRequest);
        locationRequest.setPriority(100);
        locationCallback = new LocationCallback(){

            public void onLocationResult(@NotNull LocationResult locationResult) {
                Intrinsics.checkNotNullParameter((Object)locationResult, (String)"locationResult");
                super.onLocationResult(locationResult);
                Location currentLocation = locationResult.getLastLocation();
                SensorDataUpdateCallback sensorDataUpdateCallback = locationUpdateCallback;
                if (sensorDataUpdateCallback != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)currentLocation, (String)"currentLocation");
                    sensorDataUpdateCallback.onUpdate(currentLocation);
                }
            }
        };
    }
}

