/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.ui.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import androidx.annotation.Keep;
import androidx.appcompat.app.AlertDialog;
import androidx.core.os.BundleKt;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.ActivityKt;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.ui.BottomNavigationViewKt;
import com.fondesa.kpermissions.PermissionStatus;
import com.fondesa.kpermissions.extension.PermissionsBuilderKt;
import com.fondesa.kpermissions.request.PermissionRequest;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.android_utils.LanguageUtils;
import com.netacom.base.chat.android_utils.UriUtils;
import com.netacom.base.chat.base.BaseDataActivity;
import com.netacom.base.chat.livedata.EventLiveData;
import com.netacom.base.chat.livedata.EventObserver;
import com.netacom.base.chat.logger.Logger;
import com.netacom.base.chat.model.NetAloSdkEntity;
import com.netacom.base.chat.type.RequestStatus;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.full.BR;
import com.netacom.full.R;
import com.netacom.full.databinding.ActivityNetaloBinding;
import com.netacom.full.dispatchers.Dispatcher;
import com.netacom.full.dispatchers.OneTimeEvent;
import com.netacom.full.extensions.NavControllerExtensionKt;
import com.netacom.full.ui.login.LoginActivity;
import com.netacom.full.ui.main.MainSdkViewModel;
import com.netacom.full.ui.main.calling.CallingUtils;
import com.netacom.full.ui.main.theme.ThemeHelperImpl;
import com.netacom.full.ui.sdk.Hilt_NetAloActivity;
import com.netacom.full.ui.sdk.NetAloActivity$initViews$1$invoke$;
import com.netacom.full.ui.sdk.NetAloSdkListener;
import com.netacom.full.ui.sdk.NetAloViewModel;
import com.netacom.full.ui.sdk.SdkActivity;
import com.netacom.full.utils.DialogUtil;
import com.netacom.lite.entity.socket.Call;
import com.netacom.lite.entity.ui.user.NeUser;
import com.netacom.lite.network.model.response.Popup;
import dagger.hilt.android.AndroidEntryPoint;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Signature claims super is com.netacom.full.ui.main.MainSdkActivity<com.netacom.full.databinding.ActivityNetaloBinding, com.netacom.full.ui.sdk.NetAloViewModel>, not com.netacom.full.ui.sdk.Hilt_NetAloActivity - discarding signature.
 */
@AndroidEntryPoint
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 :2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0016J\u0006\u0010&\u001a\u00020\u0013J\b\u0010'\u001a\u00020\u0013H\u0002J\b\u0010(\u001a\u00020\u0013H\u0014J\b\u0010)\u001a\u00020\u0013H\u0014J\b\u0010*\u001a\u00020+H\u0002J\u0014\u0010,\u001a\u00020\u00132\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130.J\u0014\u0010/\u001a\u00020\u00132\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130.J\b\u00100\u001a\u00020\u0013H\u0016J\b\u00101\u001a\u00020\u0013H\u0014J\b\u00102\u001a\u00020+H\u0016J\b\u00103\u001a\u00020\u0013H\u0002J\b\u00104\u001a\u00020\u0013H\u0002J\b\u00105\u001a\u00020\u0013H\u0003J\b\u00106\u001a\u00020\u001cH\u0014J\b\u00107\u001a\u00020\u0013H\u0002J\u0010\u00108\u001a\u00020\u00132\u0006\u00109\u001a\u00020+H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR0\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u00120\u00118\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u001e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006;"}, d2={"Lcom/netacom/full/ui/sdk/NetAloActivity;", "Lcom/netacom/full/ui/main/MainSdkActivity;", "Lcom/netacom/full/databinding/ActivityNetaloBinding;", "Lcom/netacom/full/ui/sdk/NetAloViewModel;", "()V", "mainSdkViewModel", "Lcom/netacom/full/ui/main/MainSdkViewModel;", "getMainSdkViewModel", "()Lcom/netacom/full/ui/main/MainSdkViewModel;", "mainSdkViewModel$delegate", "Lkotlin/Lazy;", "navController", "Landroidx/navigation/NavController;", "getNavController", "()Landroidx/navigation/NavController;", "navController$delegate", "navigationDispatcher", "Lcom/netacom/full/dispatchers/Dispatcher;", "Lkotlin/Function1;", "", "getNavigationDispatcher", "()Lcom/netacom/full/dispatchers/Dispatcher;", "setNavigationDispatcher", "(Lcom/netacom/full/dispatchers/Dispatcher;)V", "neUser", "Lcom/netacom/lite/entity/ui/user/NeUser;", "showNavFragments", "", "", "themeHelper", "Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;", "getThemeHelper", "()Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;", "setThemeHelper", "(Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;)V", "attachBaseContext", "newBase", "Landroid/content/Context;", "disConnectSocket", "eventExpire", "initData", "initViews", "isNetAlo", "", "logOutSdk", "callbackSuccess", "Lkotlin/Function0;", "logout", "onBackPressed", "onResume", "onSupportNavigateUp", "processReceiveCall", "receiveShare", "setUpNavigation", "setViewModel", "setupNavigationTheme", "showNavBottom", "isShow", "Companion", "netacom-sdk-full_NetAloDevRelease"})
@Keep
public final class NetAloActivity
extends Hilt_NetAloActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Inject
    public Dispatcher<Function1<NavController, Unit>> navigationDispatcher;
    @Inject
    public ThemeHelperImpl themeHelper;
    @Nullable
    private NeUser neUser;
    @NotNull
    private final Lazy navController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NavController>(this){
        final /* synthetic */ NetAloActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final NavController invoke() {
            return ActivityKt.findNavController((Activity)((Activity)this.this$0), (int)R.id.nav_host);
        }
    }));
    @NotNull
    private final Lazy mainSdkViewModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MainSdkViewModel>(this){
        final /* synthetic */ NetAloActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final MainSdkViewModel invoke() {
            ViewModel viewModel = new ViewModelProvider((ViewModelStoreOwner)this.this$0).get(MainSdkViewModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)viewModel, (String)"ViewModelProvider(this).get(MainSdkViewModel::class.java)");
            return (MainSdkViewModel)viewModel;
        }
    }));
    @NotNull
    private final List<Integer> showNavFragments;
    @NotNull
    private static final String IS_SDK = "IS_SDK";
    @NotNull
    private static final String USER_CHAT_NETALO = "USER_CHAT_NETALO";
    @NotNull
    private static final String CALL = "CALL";
    @NotNull
    private static final String NOTIFICATION = "NOTIFICATION";
    @Nullable
    private static NetAloSdkListener netAloSdkOutputListener;

    public NetAloActivity() {
        super(R.layout.activity_netalo, NetAloViewModel.class);
        Object[] objectArray = new Integer[]{R.id.groupFragment, R.id.callLogFragment, R.id.contactFragment, R.id.profileFragment};
        this.showNavFragments = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Dispatcher<Function1<NavController, Unit>> getNavigationDispatcher() {
        Dispatcher<Function1<NavController, Unit>> dispatcher = this.navigationDispatcher;
        if (dispatcher != null) {
            return dispatcher;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"navigationDispatcher");
        throw null;
    }

    public final void setNavigationDispatcher(@NotNull Dispatcher<Function1<NavController, Unit>> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"<set-?>");
        this.navigationDispatcher = dispatcher;
    }

    @NotNull
    public final ThemeHelperImpl getThemeHelper() {
        ThemeHelperImpl themeHelperImpl = this.themeHelper;
        if (themeHelperImpl != null) {
            return themeHelperImpl;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"themeHelper");
        throw null;
    }

    public final void setThemeHelper(@NotNull ThemeHelperImpl themeHelperImpl) {
        Intrinsics.checkNotNullParameter((Object)themeHelperImpl, (String)"<set-?>");
        this.themeHelper = themeHelperImpl;
    }

    protected int setViewModel() {
        return BR.viewModel;
    }

    private final NavController getNavController() {
        Lazy lazy = this.navController$delegate;
        boolean bl = false;
        return (NavController)lazy.getValue();
    }

    private final MainSdkViewModel getMainSdkViewModel() {
        Lazy lazy = this.mainSdkViewModel$delegate;
        boolean bl = false;
        return (MainSdkViewModel)((Object)lazy.getValue());
    }

    public final void disConnectSocket() {
        try {
            this.getMainSdkViewModel().disConnectSocket();
        }
        catch (Exception e) {
            e.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
        }
    }

    public final void logout(@NotNull Function0<Unit> callbackSuccess) {
        Intrinsics.checkNotNullParameter(callbackSuccess, (String)"callbackSuccess");
        NetAloSdkListener netAloSdkListener = netAloSdkOutputListener;
        if (netAloSdkListener != null) {
            netAloSdkListener.eventLogOut(callbackSuccess);
        }
    }

    private final void eventExpire() {
        NetAloSdkListener netAloSdkListener = netAloSdkOutputListener;
        if (netAloSdkListener != null) {
            netAloSdkListener.eventNetAloSessionExpire();
        }
    }

    public final void logOutSdk(@NotNull Function0<Unit> callbackSuccess) {
        Intrinsics.checkNotNullParameter(callbackSuccess, (String)"callbackSuccess");
        try {
            this.getMainSdkViewModel().logout(callbackSuccess);
        }
        catch (Exception e) {
            e.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
        }
    }

    private final boolean isNetAlo() {
        return !this.getIntent().getBooleanExtra(IS_SDK, false);
    }

    protected void initViews() {
        Bundle bundle = this.getIntent().getExtras();
        NeUser neUser = bundle == null ? null : (NeUser)bundle.getParcelable("neUser");
        this.neUser = neUser == null ? (NeUser)this.getIntent().getParcelableExtra(USER_CHAT_NETALO) : neUser;
        this.getMainSdkViewModel().initSDK(this.neUser, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ NetAloActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (NetAloActivity.access$getMainSdkViewModel(this.this$0).getGetPreferences().getGetUserId() == 0L) {
                    Activity $this$launchActivity_u24default$iv = (Activity)this.this$0;
                    int requestCode$iv = -1;
                    Bundle options$iv = null;
                    Function1 init$iv = initViews$1$invoke$$inlined$launchActivity$default$1.INSTANCE;
                    boolean $i$f$launchActivity = false;
                    boolean $i$f$newIntent = false;
                    Intent intent$iv = new Intent((Context)$this$launchActivity_u24default$iv, LoginActivity.class);
                    init$iv.invoke((Object)intent$iv);
                    $this$launchActivity_u24default$iv.startActivityForResult(intent$iv, requestCode$iv, options$iv);
                    this.this$0.finishAffinity();
                }
            }
        }));
        this.initTheme(this.getThemeHelper());
    }

    @Override
    protected void onResume() {
        super.onResume();
        CallingUtils.INSTANCE.setOnCall(false);
        this.receiveShare();
        this.setupNavigationTheme();
        this.processReceiveCall();
    }

    /*
     * WARNING - void declaration
     */
    protected void initData() {
        void this_$iv;
        this.checkPermissionAll();
        this.setUpNavigation();
        this.observe(this.getNavigationDispatcher().getEvent(), (Function1)new Function1<OneTimeEvent<Function1<? super NavController, ? extends Unit>>, Unit>(this){
            final /* synthetic */ NetAloActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull OneTimeEvent<Function1<NavController, Unit>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                event.consume((Function1<Function1<NavController, Unit>, Unit>)((Function1)new Function1<Function1<? super NavController, ? extends Unit>, Unit>(this.this$0){
                    final /* synthetic */ NetAloActivity this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Function1<? super NavController, Unit> command) {
                        Intrinsics.checkNotNullParameter(command, (String)"command");
                        command.invoke((Object)NetAloActivity.access$getNavController(this.this$0));
                    }
                }));
            }
        });
        this.observe(((NetAloViewModel)this.getViewModel()).getNetAloSdkEvent(), (Function1)new Function1<NetAloSdkEntity, Unit>(this){
            final /* synthetic */ NetAloActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull NetAloSdkEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int n = it.getErrorCode();
                if (n == RequestStatus.UNAUTHORIZED.getValue()) {
                    NetAloActivity.access$eventExpire(this.this$0);
                }
            }
        });
        BaseDataActivity baseDataActivity = this;
        LiveData<EventLiveData<Popup>> $this$observeOnce$iv = ((NetAloViewModel)this.getViewModel()).getShowReferral();
        boolean $i$f$observeOnce = false;
        $this$observeOnce$iv.observe((LifecycleOwner)this_$iv, (Observer)new EventObserver((Function1)new Function1<Popup, Unit>(this){
            final /* synthetic */ NetAloActivity this$0;
            {
                this.this$0 = netAloActivity;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(Object value) {
                Popup popup = (Popup)value;
                boolean bl = false;
                if (ExtensionsUtilsKt.isNotNull((Object)popup)) {
                    NavDestination navDestination = NetAloActivity.access$getNavController(this.this$0).getCurrentDestination();
                    Integer n = navDestination == null ? null : Integer.valueOf(navDestination.getId());
                    if (n != null && NetAloActivity.access$getNavController(this.this$0).getGraph().getStartDestination() == n.intValue()) {
                        DialogUtil.Companion.showImage((Context)this.this$0, popup.getBanner_url(), (Function1<? super AlertDialog, Unit>)((Function1)new Function1<AlertDialog, Unit>(popup, this.this$0){
                            final /* synthetic */ Popup $popup;
                            final /* synthetic */ NetAloActivity this$0;
                            {
                                this.$popup = $popup;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull AlertDialog it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if (ExtensionsUtilsKt.isNotNull((Object)this.$popup.getClick_url())) {
                                    ((NetAloViewModel)this.this$0.getViewModel()).gotoReferral(this.$popup.getClick_url());
                                }
                            }
                        }), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                            final /* synthetic */ NetAloActivity this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                ((NetAloViewModel)this.this$0.getViewModel()).showNextReferral();
                            }
                        }));
                    }
                }
            }
        }));
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.MainScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ CoroutineScope p$;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.p$ = (CoroutineScope)value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onBackPressed() {
        if (this.neUser == null) {
            NavDestination navDestination = this.getNavController().getCurrentDestination();
            Integer n = navDestination == null ? null : Integer.valueOf(navDestination.getId());
            if (n != null && this.getNavController().getGraph().getStartDestination() == n.intValue()) {
                Logger.INSTANCE.e("onBackPressed11111=disConnectSocket:finish", new Object[0]);
                if (this.isNetAlo()) {
                    this.moveTaskToBack(true);
                    return;
                }
                Logger.INSTANCE.e("onBackPressed2222=disConnectSocket:finish", new Object[0]);
                this.disConnectSocket();
                this.finish();
                return;
            }
        }
        if (this.neUser != null) {
            Logger.INSTANCE.e("onBackPressed3333=disConnectSocket:finish", new Object[0]);
            this.disConnectSocket();
            this.finish();
            return;
        }
        Logger.INSTANCE.e("onBackPressed44444=disConnectSocket:finish", new Object[0]);
        super.onBackPressed();
    }

    public boolean onSupportNavigateUp() {
        return this.getNavController().navigateUp();
    }

    public void attachBaseContext(@NotNull Context newBase) {
        Intrinsics.checkNotNullParameter((Object)newBase, (String)"newBase");
        super.attachBaseContext(newBase);
        LanguageUtils.Companion.attachBaseContext((Activity)this);
    }

    @SuppressLint(value={"RestrictedApi"})
    private final void setUpNavigation() {
        if (this.isNetAlo()) {
            NavController navController2 = this.getNavController();
            boolean bl = false;
            boolean bl2 = false;
            NavController $this$setUpNavigation_u24lambda_u2d1 = navController2;
            boolean bl3 = false;
            BottomNavigationView bottomNavigationView = ((ActivityNetaloBinding)this.getBinding()).navView;
            Intrinsics.checkNotNullExpressionValue((Object)bottomNavigationView, (String)"binding.navView");
            BottomNavigationViewKt.setupWithNavController((BottomNavigationView)bottomNavigationView, (NavController)$this$setUpNavigation_u24lambda_u2d1);
            $this$setUpNavigation_u24lambda_u2d1.addOnDestinationChangedListener(new NavController.OnDestinationChangedListener($this$setUpNavigation_u24lambda_u2d1, this){
                final /* synthetic */ NavController $this_with;
                final /* synthetic */ NetAloActivity this$0;
                {
                    this.$this_with = $receiver;
                    this.this$0 = $receiver2;
                }

                public final void onDestinationChanged(@NotNull NavController $noName_0, @NotNull NavDestination destination, @Nullable Bundle $noName_2) {
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                    Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                    int n = this.$this_with.getBackStack().size();
                    NetAloActivity netAloActivity = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    int $noName_02 = n;
                    boolean bl3 = false;
                    if (NetAloActivity.access$getShowNavFragments$p(netAloActivity).contains(destination.getId())) {
                        NetAloActivity.access$showNavBottom(netAloActivity, true);
                        NetAloActivity.access$setupNavigationTheme(netAloActivity);
                    } else {
                        NetAloActivity.access$showNavBottom(netAloActivity, false);
                    }
                }
            });
        } else {
            this.showNavBottom(false);
        }
    }

    private final void setupNavigationTheme() {
        if (this.isNetAlo()) {
            ThemeHelperImpl themeHelperImpl = this.getThemeHelper();
            View[] viewArray = new View[1];
            BottomNavigationView bottomNavigationView = ((ActivityNetaloBinding)this.getBinding()).navView;
            Intrinsics.checkNotNullExpressionValue((Object)bottomNavigationView, (String)"binding.navView");
            viewArray[0] = (View)bottomNavigationView;
            themeHelperImpl.setThemeColorForViews(viewArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showNavBottom(boolean isShow) {
        BottomNavigationView bottomNavigationView = ((ActivityNetaloBinding)this.getBinding()).navView;
        boolean bl = false;
        boolean bl2 = false;
        BottomNavigationView $this$showNavBottom_u24lambda_u2d2 = bottomNavigationView;
        boolean bl3 = false;
        if (isShow) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$showNavBottom_u24lambda_u2d2, (String)"");
            View $this$isGone$iv = (View)$this$showNavBottom_u24lambda_u2d2;
            boolean $i$f$isGone = false;
            if ($this$isGone$iv.getVisibility() == 8) {
                void $this$isVisible$iv;
                $this$isGone$iv = (View)$this$showNavBottom_u24lambda_u2d2;
                boolean value$iv = true;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
            }
        } else {
            NavDestination $this$isVisible$iv = this.getNavController().getCurrentDestination();
            if (!Intrinsics.areEqual((Object)($this$isVisible$iv == null ? null : $this$isVisible$iv.getNavigatorName()), (Object)"dialog")) {
                void $this$isGone$iv;
                Intrinsics.checkNotNullExpressionValue((Object)$this$showNavBottom_u24lambda_u2d2, (String)"");
                $this$isVisible$iv = (View)$this$showNavBottom_u24lambda_u2d2;
                boolean value$iv = true;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(8);
            }
        }
    }

    private final void processReceiveCall() {
        Call call;
        Call call2;
        Call call3;
        Parcelable parcelable = this.getIntent().getParcelableExtra(CALL);
        Call call4 = call3 = parcelable instanceof Call ? (Call)parcelable : null;
        if (call3 == null) {
            parcelable = this.getMainSdkViewModel().getMainViewModelCall();
            if (parcelable == null) {
                return;
            }
            call2 = parcelable;
        } else {
            call2 = call = call3;
        }
        if (Build.VERSION.SDK_INT > 27) {
            this.setShowWhenLocked(true);
            this.setTurnScreenOn(true);
            KeyguardManager keyguardManager = (KeyguardManager)this.getSystemService("keyguard");
            parcelable = keyguardManager;
            if (parcelable != null) {
                parcelable.requestDismissKeyguard((Activity)this, null);
            }
        } else {
            this.getWindow().addFlags(0x680080);
        }
        boolean isNotification = this.getIntent().getBooleanExtra(NOTIFICATION, false);
        this.getNavigationDispatcher().emit(new Function1<NavController, Unit>(call, this, isNotification){
            final /* synthetic */ Call $call;
            final /* synthetic */ NetAloActivity this$0;
            final /* synthetic */ boolean $isNotification;
            {
                this.$call = $call;
                this.this$0 = $receiver;
                this.$isNotification = $isNotification;
                super(1);
            }

            public final void invoke(@NotNull NavController navController2) {
                Intrinsics.checkNotNullParameter((Object)navController2, (String)"navController");
                Call call = this.$call;
                NetAloActivity netAloActivity = this.this$0;
                boolean bl = this.$isNotification;
                boolean bl2 = false;
                boolean bl3 = false;
                Call _call = call;
                boolean bl4 = false;
                NetAloActivity.access$getMainSdkViewModel(netAloActivity).setMainViewModelCall(null);
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"call", (Object)_call), TuplesKt.to((Object)"isNotification", (Object)bl)};
                navController2.navigate(R.id.inComeFragment, BundleKt.bundleOf((Pair[])pairArray));
            }
        });
    }

    private final void receiveShare() {
        Intent intent = this.getIntent();
        if (intent != null) {
            Object object;
            Intent intent2 = intent;
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$receiveShare_u24lambda_u2d8 = intent2;
            boolean bl3 = false;
            String string2 = $this$receiveShare_u24lambda_u2d8.getAction();
            if (Intrinsics.areEqual((Object)string2, (Object)"android.intent.action.SEND")) {
                String string3 = $this$receiveShare_u24lambda_u2d8.getType();
                if (Intrinsics.areEqual(string3 == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string3, (String)"text/", (boolean)false, (int)2, null)), (Object)true)) {
                    string3 = $this$receiveShare_u24lambda_u2d8.getStringExtra("android.intent.extra.TEXT");
                    if (string3 != null) {
                        String string4 = string3;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        String it = string4;
                        boolean bl6 = false;
                        this.getNavigationDispatcher().emit(new Function1<NavController, Unit>(it){
                            final /* synthetic */ String $it;
                            {
                                this.$it = $it;
                                super(1);
                            }

                            public final void invoke(@NotNull NavController nav) {
                                Intrinsics.checkNotNullParameter((Object)nav, (String)"nav");
                                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"forwardMediaPath", (Object)this.$it)};
                                NavControllerExtensionKt.navigateIfSafe$default(nav, R.id.ForwardMessageDialog, pairArray, null, null, 12, null);
                            }
                        });
                        Logger.INSTANCE.e(Intrinsics.stringPlus((String)"handleSendText=text=", (Object)it), new Object[0]);
                    }
                } else {
                    string3 = $this$receiveShare_u24lambda_u2d8.getType();
                    if ((Intrinsics.areEqual(string3 == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string3, (String)"image/", (boolean)false, (int)2, null)), (Object)true) || Intrinsics.areEqual((string3 = $this$receiveShare_u24lambda_u2d8.getType()) == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string3, (String)"audio/", (boolean)false, (int)2, null)), (Object)true) || Intrinsics.areEqual((string3 = $this$receiveShare_u24lambda_u2d8.getType()) == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string3, (String)"video/", (boolean)false, (int)2, null)), (Object)true)) && (string3 = $this$receiveShare_u24lambda_u2d8.getParcelableExtra("android.intent.extra.STREAM")) != null) {
                        String string5;
                        String string6 = string3;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        String it = string6;
                        boolean bl9 = false;
                        File file = UriUtils.uri2File((Uri)(it instanceof Uri ? (Uri)it : null));
                        if (file != null && (string5 = file.getPath()) != null) {
                            String string7 = string5;
                            boolean bl10 = false;
                            boolean bl11 = false;
                            String $this$receiveShare_u24lambda_u2d8_u24lambda_u2d5_u24lambda_u2d4 = string7;
                            boolean bl12 = false;
                            Logger.INSTANCE.e(Intrinsics.stringPlus((String)"image=url=", (Object)$this$receiveShare_u24lambda_u2d8_u24lambda_u2d5_u24lambda_u2d4), new Object[0]);
                            this.getNavigationDispatcher().emit(new Function1<NavController, Unit>($this$receiveShare_u24lambda_u2d8_u24lambda_u2d5_u24lambda_u2d4){
                                final /* synthetic */ String $this_apply;
                                {
                                    this.$this_apply = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull NavController nav) {
                                    Intrinsics.checkNotNullParameter((Object)nav, (String)"nav");
                                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"forwardMediaPath", (Object)this.$this_apply)};
                                    nav.navigate(R.id.ForwardMessageDialog, BundleKt.bundleOf((Pair[])pairArray));
                                }
                            });
                        }
                    }
                }
            } else if (Intrinsics.areEqual((Object)string2, (Object)"android.intent.action.SEND_MULTIPLE") && (Intrinsics.areEqual((object = $this$receiveShare_u24lambda_u2d8.getType()) == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)object, (String)"image/", (boolean)false, (int)2, null)), (Object)true) || Intrinsics.areEqual((object = $this$receiveShare_u24lambda_u2d8.getType()) == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)object, (String)"audio/", (boolean)false, (int)2, null)), (Object)true) || Intrinsics.areEqual((object = $this$receiveShare_u24lambda_u2d8.getType()) == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)object, (String)"video/", (boolean)false, (int)2, null)), (Object)true)) && (object = $this$receiveShare_u24lambda_u2d8.getParcelableArrayListExtra("android.intent.extra.STREAM")) != null) {
                Object object2 = object;
                boolean bl13 = false;
                boolean bl14 = false;
                Object it = object2;
                boolean bl15 = false;
                Object object3 = ((ArrayList)it).get(0);
                File file = UriUtils.uri2File((Uri)(object3 instanceof Uri ? (Uri)object3 : null));
                if (file != null && (object3 = file.getPath()) != null) {
                    Object object4 = object3;
                    boolean bl16 = false;
                    boolean bl17 = false;
                    Object $this$receiveShare_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6 = object4;
                    boolean bl18 = false;
                    Logger.INSTANCE.e(Intrinsics.stringPlus((String)"image=url=", $this$receiveShare_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6), new Object[0]);
                    this.getNavigationDispatcher().emit(new Function1<NavController, Unit>($this$receiveShare_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6){
                        final /* synthetic */ String $this_apply;
                        {
                            this.$this_apply = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull NavController nav) {
                            Intrinsics.checkNotNullParameter((Object)nav, (String)"nav");
                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"forwardMediaPath", (Object)this.$this_apply)};
                            nav.navigate(R.id.ForwardMessageDialog, BundleKt.bundleOf((Pair[])pairArray));
                        }
                    });
                }
            }
        }
    }

    public static final /* synthetic */ MainSdkViewModel access$getMainSdkViewModel(NetAloActivity $this) {
        return $this.getMainSdkViewModel();
    }

    public static final /* synthetic */ NavController access$getNavController(NetAloActivity $this) {
        return $this.getNavController();
    }

    public static final /* synthetic */ void access$eventExpire(NetAloActivity $this) {
        $this.eventExpire();
    }

    public static final /* synthetic */ List access$getShowNavFragments$p(NetAloActivity $this) {
        return $this.showNavFragments;
    }

    public static final /* synthetic */ void access$showNavBottom(NetAloActivity $this, boolean isShow) {
        $this.showNavBottom(isShow);
    }

    public static final /* synthetic */ void access$setupNavigationTheme(NetAloActivity $this) {
        $this.setupNavigationTheme();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J:\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/netacom/full/ui/sdk/NetAloActivity$Companion;", "", "()V", "CALL", "", "IS_SDK", "NOTIFICATION", "USER_CHAT_NETALO", "netAloSdkOutputListener", "Lcom/netacom/full/ui/sdk/NetAloSdkListener;", "eventFireBase", "", "data", "", "initListener", "context", "Landroid/content/Context;", "initPermission", "activity", "Landroidx/fragment/app/FragmentActivity;", "startGallery", "startSDK", "isSdk", "", "neUserChat", "Lcom/netacom/lite/entity/ui/user/NeUser;", "call", "Lcom/netacom/lite/entity/socket/Call;", "isNotification", "netacom-sdk-full_NetAloDevRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final void startSDK(@NotNull Context context, boolean isSdk, @Nullable NeUser neUserChat, @Nullable Call call, boolean isNotification) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, NetAloActivity.class);
            intent.putExtra(IS_SDK, isSdk);
            intent.putExtra(USER_CHAT_NETALO, (Parcelable)neUserChat);
            intent.putExtra(CALL, (Parcelable)call);
            intent.putExtra(NOTIFICATION, isNotification);
            Call call2 = call;
            if (call2 != null) {
                Call call3 = call2;
                boolean bl = false;
                boolean bl2 = false;
                Call it = call3;
                boolean bl3 = false;
                intent.addFlags(0x800000);
                intent.addFlags(0x10000000);
            }
            context.startActivity(intent);
        }

        public static /* synthetic */ void startSDK$default(Companion companion, Context context, boolean bl, NeUser neUser, Call call, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                neUser = null;
            }
            if ((n & 8) != 0) {
                call = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            companion.startSDK(context, bl, neUser, call, bl2);
        }

        public final void startGallery(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, SdkActivity.class);
            context.startActivity(intent);
        }

        public final void initListener(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            netAloSdkOutputListener = context instanceof NetAloSdkListener ? (NetAloSdkListener)context : null;
        }

        public final void initPermission(@NotNull FragmentActivity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            String[] stringArray = new String[]{"android.permission.WRITE_CONTACTS", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"};
            PermissionRequest $this$send$iv = PermissionsBuilderKt.permissionsBuilder((FragmentActivity)activity, (String)"android.permission.READ_CONTACTS", (String[])stringArray).build();
            boolean $i$f$send = false;
            $this$send$iv.addListener(new PermissionRequest.Listener($this$send$iv){
                final /* synthetic */ PermissionRequest $this_send;
                {
                    this.$this_send = $receiver;
                }

                public void onPermissionsResult(@NotNull List<? extends PermissionStatus> result2) {
                    Intrinsics.checkNotNullParameter(result2, (String)"result");
                    List<? extends PermissionStatus> status = result2;
                    boolean bl = false;
                    Logger.INSTANCE.e(Intrinsics.stringPlus((String)"initPermission==", status), new Object[0]);
                    this.$this_send.removeListener((PermissionRequest.Listener)this);
                }
            });
            $this$send$iv.send();
        }

        public final void eventFireBase(@NotNull Map<String, String> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            NetAloSdkListener netAloSdkListener = netAloSdkOutputListener;
            if (netAloSdkListener != null) {
                NetAloSdkListener netAloSdkListener2 = netAloSdkListener;
                boolean bl = false;
                boolean bl2 = false;
                NetAloSdkListener $this$eventFireBase_u24lambda_u2d2 = netAloSdkListener2;
                boolean bl3 = false;
                $this$eventFireBase_u24lambda_u2d2.eventFirebase(data);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

